/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class ColumnAccessAnalyzer {
    private static final Log LOG = LogFactory.getLog(ColumnAccessAnalyzer.class.getName());
    private final ParseContext pGraphContext;

    public ColumnAccessAnalyzer() {
        this.pGraphContext = null;
    }

    public ColumnAccessAnalyzer(ParseContext pactx) {
        this.pGraphContext = pactx;
    }

    public ColumnAccessInfo analyzeColumnAccess() throws SemanticException {
        ColumnAccessInfo columnAccessInfo = new ColumnAccessInfo();
        Collection<Operator<? extends OperatorDesc>> topOps = this.pGraphContext.getTopOps().values();
        for (Operator<? extends OperatorDesc> op : topOps) {
            PrunedPartitionList parts;
            if (!(op instanceof TableScanOperator)) continue;
            TableScanOperator top = (TableScanOperator)op;
            Table table = ((TableScanDesc)top.getConf()).getTableMetadata();
            String tableName = table.getCompleteName();
            List<String> referenced = top.getReferencedColumns();
            for (String column : referenced) {
                columnAccessInfo.add(tableName, column);
            }
            if (!table.isPartitioned() || (parts = this.pGraphContext.getPrunedPartitions(table.getTableName(), top)).getReferredPartCols() == null) continue;
            for (String partKey : parts.getReferredPartCols()) {
                columnAccessInfo.add(tableName, partKey);
            }
        }
        return columnAccessInfo;
    }
}

