/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import javaewah.EWAHCompressedBitmap;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapObjectInput;
import org.apache.hadoop.hive.ql.index.bitmap.BitmapObjectOutput;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.StringUtils;

@Description(name="ewah_bitmap", value="_FUNC_(expr) - Returns an EWAH-compressed bitmap representation of a column.")
public class GenericUDAFEWAHBitmap
extends AbstractGenericUDAFResolver {
    static final Log LOG = LogFactory.getLog(GenericUDAFEWAHBitmap.class.getName());

    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        if (parameters.length != 1) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Exactly one argument is expected.");
        }
        ObjectInspector oi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(parameters[0]);
        if (!ObjectInspectorUtils.compareSupported(oi)) {
            throw new UDFArgumentTypeException(parameters.length - 1, "Cannot support comparison of map<> type or complex type containing map<>.");
        }
        return new GenericUDAFEWAHBitmapEvaluator();
    }

    public static class GenericUDAFEWAHBitmapEvaluator
    extends GenericUDAFEvaluator {
        private PrimitiveObjectInspector inputOI;
        private transient StandardListObjectInspector loi;
        private transient StandardListObjectInspector internalMergeOI;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (m == GenericUDAFEvaluator.Mode.PARTIAL1) {
                this.inputOI = (PrimitiveObjectInspector)parameters[0];
                return ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            }
            if (m == GenericUDAFEvaluator.Mode.PARTIAL2 || m == GenericUDAFEvaluator.Mode.FINAL) {
                this.internalMergeOI = (StandardListObjectInspector)parameters[0];
                this.inputOI = (PrimitiveObjectInspector)this.internalMergeOI.getListElementObjectInspector();
                this.loi = ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
                return this.loi;
            }
            this.inputOI = (PrimitiveObjectInspector)parameters[0];
            this.loi = ObjectInspectorFactory.getStandardListObjectInspector(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
            return this.loi;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((BitmapAgg)agg).bitmap = new EWAHCompressedBitmap();
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            BitmapAgg result = new BitmapAgg();
            this.reset(result);
            return result;
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            assert (parameters.length == 1);
            Object p = parameters[0];
            if (p != null) {
                BitmapAgg myagg = (BitmapAgg)agg;
                try {
                    int row = PrimitiveObjectInspectorUtils.getInt(p, this.inputOI);
                    this.addBitmap(row, myagg);
                }
                catch (NumberFormatException e) {
                    LOG.warn(this.getClass().getSimpleName() + " " + StringUtils.stringifyException((Throwable)e));
                }
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BitmapAgg myagg = (BitmapAgg)agg;
            BitmapObjectOutput bitmapObjOut = new BitmapObjectOutput();
            try {
                myagg.bitmap.writeExternal((ObjectOutput)bitmapObjOut);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bitmapObjOut.list();
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            BitmapAgg myagg = (BitmapAgg)agg;
            ArrayList partialResult = (ArrayList)this.internalMergeOI.getList(partial);
            BitmapObjectInput bitmapObjIn = new BitmapObjectInput(partialResult);
            EWAHCompressedBitmap partialBitmap = new EWAHCompressedBitmap();
            try {
                partialBitmap.readExternal((ObjectInput)bitmapObjIn);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            myagg.bitmap = myagg.bitmap.or(partialBitmap);
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            BitmapAgg myagg = (BitmapAgg)agg;
            BitmapObjectOutput bitmapObjOut = new BitmapObjectOutput();
            try {
                myagg.bitmap.writeExternal((ObjectOutput)bitmapObjOut);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bitmapObjOut.list();
        }

        private void addBitmap(int newRow, BitmapAgg myagg) {
            if (!myagg.bitmap.set(newRow)) {
                throw new RuntimeException("Can't set bits out of order with EWAHCompressedBitmap");
            }
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class BitmapAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            EWAHCompressedBitmap bitmap;

            BitmapAgg() {
            }

            @Override
            public int estimate() {
                return this.bitmap.sizeInBytes();
            }
        }
    }
}

