/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import com.facebook.presto.hive.$internal.org.apache.commons.lang.ArrayUtils;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.PTFPartition;
import org.apache.hadoop.hive.ql.exec.PTFRollingPartition;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.ValueBoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFunctionDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public class WindowingTableFunction
extends TableFunctionEvaluator {
    public static final Log LOG = LogFactory.getLog(WindowingTableFunction.class.getName());
    StreamingState streamingState;
    RankLimit rnkLimitDef;
    Map<String, WindowingFunctionInfoHelper> windowingFunctionHelpers = null;

    public Map<String, WindowingFunctionInfoHelper> getWindowingFunctionHelpers() {
        return this.windowingFunctionHelpers;
    }

    public void setWindowingFunctionHelpers(Map<String, WindowingFunctionInfoHelper> windowingFunctionHelpers) {
        this.windowingFunctionHelpers = windowingFunctionHelpers;
    }

    @Override
    public void execute(PTFPartition.PTFPartitionIterator<Object> pItr, PTFPartition outP) throws HiveException {
        ArrayList<List> oColumns = new ArrayList<List>();
        PTFPartition iPart = pItr.getPartition();
        StructObjectInspector inputOI = iPart.getOutputOI();
        WindowTableFunctionDef wTFnDef = (WindowTableFunctionDef)this.getTableDef();
        PTFInvocationSpec.Order order = wTFnDef.getOrder().getExpressions().get(0).getOrder();
        for (WindowFunctionDef wFn : wTFnDef.getWindowFunctions()) {
            boolean processWindow = this.processWindow(wFn);
            pItr.reset();
            if (!processWindow) {
                SameList<Object> out = this.evaluateWindowFunction(wFn, pItr);
                if (!wFn.isPivotResult()) {
                    out = new SameList<Object>(iPart.size(), out);
                }
                oColumns.add(out);
                continue;
            }
            oColumns.add(this.executeFnwithWindow(this.getQueryDef(), wFn, iPart, order));
        }
        for (int i = 0; i < iPart.size(); ++i) {
            ArrayList<Object> oRow = new ArrayList<Object>();
            Object iRow = iPart.getAt(i);
            for (int j = 0; j < oColumns.size(); ++j) {
                oRow.add(((List)oColumns.get(j)).get(i));
            }
            for (StructField structField : inputOI.getAllStructFieldRefs()) {
                oRow.add(inputOI.getStructFieldData(iRow, structField));
            }
            outP.append(oRow);
        }
    }

    Object evaluateWindowFunction(WindowFunctionDef wFn, PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
        GenericUDAFEvaluator fEval = wFn.getWFnEval();
        Object[] args = new Object[wFn.getArgs() == null ? 0 : wFn.getArgs().size()];
        GenericUDAFEvaluator.AggregationBuffer aggBuffer = fEval.getNewAggregationBuffer();
        while (pItr.hasNext()) {
            Object row = pItr.next();
            int i = 0;
            if (wFn.getArgs() != null) {
                for (PTFExpressionDef arg : wFn.getArgs()) {
                    args[i++] = arg.getExprEvaluator().evaluate(row);
                }
            }
            fEval.aggregate(aggBuffer, args);
        }
        Object out = fEval.evaluate(aggBuffer);
        out = ObjectInspectorUtils.copyToStandardObject(out, wFn.getOI());
        return out;
    }

    private boolean processWindow(WindowFunctionDef wFn) {
        WindowFrameDef frame = wFn.getWindowFrame();
        if (frame == null) {
            return false;
        }
        return frame.getStart().getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT || frame.getEnd().getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT;
    }

    private boolean streamingPossible(Configuration cfg, WindowFunctionDef wFnDef) throws HiveException {
        WindowFrameDef wdwFrame = wFnDef.getWindowFrame();
        WindowingFunctionInfoHelper wFnInfo = this.getWindowingFunctionInfoHelper(wFnDef.getName());
        if (!wFnInfo.isSupportsWindow()) {
            return true;
        }
        BoundaryDef start = wdwFrame.getStart();
        BoundaryDef end = wdwFrame.getEnd();
        if (start instanceof ValueBoundaryDef || end instanceof ValueBoundaryDef) {
            return false;
        }
        if (end.getAmt() == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
            return false;
        }
        if (start.getAmt() == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
            return true;
        }
        int windowLimit = HiveConf.getIntVar(cfg, HiveConf.ConfVars.HIVEJOINCACHESIZE);
        return windowLimit >= start.getAmt() + end.getAmt() + 1;
    }

    private int[] setCanAcceptInputAsStream(Configuration cfg) throws HiveException {
        this.canAcceptInputAsStream = false;
        if (this.ptfDesc.getLlInfo().getLeadLagExprs() != null) {
            return null;
        }
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        int precedingSpan = 0;
        int followingSpan = 0;
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            GenericUDAFEvaluator streamingEval;
            WindowFunctionDef wFnDef = tabDef.getWindowFunctions().get(i);
            WindowFrameDef wdwFrame = wFnDef.getWindowFrame();
            GenericUDAFEvaluator fnEval = wFnDef.getWFnEval();
            boolean streamingPossible = this.streamingPossible(cfg, wFnDef);
            GenericUDAFEvaluator genericUDAFEvaluator = streamingEval = streamingPossible ? fnEval.getWindowingEvaluator(wdwFrame) : null;
            if (streamingEval != null && streamingEval instanceof ISupportStreamingModeForWindowing) continue;
            BoundaryDef start = wdwFrame.getStart();
            BoundaryDef end = wdwFrame.getEnd();
            if (!(end instanceof ValueBoundaryDef) && !(start instanceof ValueBoundaryDef) && end.getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && start.getAmt() != WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT && end.getDirection() != WindowingSpec.Direction.PRECEDING && start.getDirection() != WindowingSpec.Direction.FOLLOWING) {
                int amt = wdwFrame.getStart().getAmt();
                if (amt > precedingSpan) {
                    precedingSpan = amt;
                }
                if ((amt = wdwFrame.getEnd().getAmt()) <= followingSpan) continue;
                followingSpan = amt;
                continue;
            }
            return null;
        }
        int windowLimit = HiveConf.getIntVar(cfg, HiveConf.ConfVars.HIVEJOINCACHESIZE);
        if (windowLimit < followingSpan + precedingSpan + 1) {
            return null;
        }
        this.canAcceptInputAsStream = true;
        return new int[]{precedingSpan, followingSpan};
    }

    private void initializeWindowingFunctionInfoHelpers() throws SemanticException {
        if (this.windowingFunctionHelpers != null) {
            return;
        }
        this.windowingFunctionHelpers = new HashMap<String, WindowingFunctionInfoHelper>();
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
            GenericUDAFEvaluator fnEval = wFn.getWFnEval();
            WindowFunctionInfo wFnInfo = FunctionRegistry.getWindowFunctionInfo(wFn.getName());
            boolean supportsWindow = wFnInfo.isSupportsWindow();
            this.windowingFunctionHelpers.put(wFn.getName(), new WindowingFunctionInfoHelper(supportsWindow));
        }
    }

    @Override
    protected void setOutputOI(StructObjectInspector outputOI) {
        super.setOutputOI(outputOI);
        try {
            this.initializeWindowingFunctionInfoHelpers();
        }
        catch (SemanticException err) {
            throw new RuntimeException("Unexpected error while setting up windowing function", err);
        }
    }

    private WindowingFunctionInfoHelper getWindowingFunctionInfoHelper(String fnName) {
        WindowingFunctionInfoHelper wFnInfoHelper = this.windowingFunctionHelpers.get(fnName);
        if (wFnInfoHelper == null) {
            throw new RuntimeException("No cached WindowingFunctionInfoHelper for " + fnName);
        }
        return wFnInfoHelper;
    }

    @Override
    public void initializeStreaming(Configuration cfg, StructObjectInspector inputOI, boolean isMapSide) throws HiveException {
        int[] span = this.setCanAcceptInputAsStream(cfg);
        if (!this.canAcceptInputAsStream) {
            return;
        }
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            WindowFunctionDef wFnDef = tabDef.getWindowFunctions().get(i);
            WindowFrameDef wdwFrame = wFnDef.getWindowFrame();
            GenericUDAFEvaluator fnEval = wFnDef.getWFnEval();
            GenericUDAFEvaluator streamingEval = fnEval.getWindowingEvaluator(wdwFrame);
            if (streamingEval == null) continue;
            wFnDef.setWFnEval(streamingEval);
            if (!wFnDef.isPivotResult()) continue;
            ListObjectInspector listOI = (ListObjectInspector)wFnDef.getOI();
            wFnDef.setOI(listOI.getListElementObjectInspector());
        }
        if (tabDef.getRankLimit() != -1) {
            this.rnkLimitDef = new RankLimit(tabDef.getRankLimit(), tabDef.getRankLimitFunction(), tabDef.getWindowFunctions());
        }
        this.streamingState = new StreamingState(cfg, inputOI, isMapSide, tabDef, span[0], span[1]);
    }

    @Override
    public void startPartition() throws HiveException {
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        this.streamingState.reset(tabDef);
    }

    @Override
    public List<Object> processRow(Object row) throws HiveException {
        boolean hasRow;
        if (this.streamingState.rankLimitReached()) {
            return null;
        }
        this.streamingState.rollingPart.append(row);
        row = this.streamingState.rollingPart.getAt(this.streamingState.rollingPart.size() - 1);
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
            GenericUDAFEvaluator fnEval = wFn.getWFnEval();
            int a = 0;
            if (wFn.getArgs() != null) {
                for (PTFExpressionDef arg : wFn.getArgs()) {
                    this.streamingState.funcArgs[i][a++] = arg.getExprEvaluator().evaluate(row);
                }
            }
            if (fnEval instanceof ISupportStreamingModeForWindowing) {
                fnEval.aggregate(this.streamingState.aggBuffers[i], this.streamingState.funcArgs[i]);
                Object out = ((ISupportStreamingModeForWindowing)((Object)fnEval)).getNextResult(this.streamingState.aggBuffers[i]);
                if (out == null) continue;
                this.streamingState.fnOutputs[i].add(out == ISupportStreamingModeForWindowing.NULL_RESULT ? null : out);
                continue;
            }
            int rowToProcess = this.streamingState.rollingPart.rowToProcess(wFn);
            if (rowToProcess < 0) continue;
            Range rng = this.getRange(wFn, rowToProcess, this.streamingState.rollingPart, this.streamingState.order);
            PTFPartition.PTFPartitionIterator<Object> rItr = rng.iterator();
            PTFOperator.connectLeadLagFunctionsToPartition(this.ptfDesc, rItr);
            Object out = this.evaluateWindowFunction(wFn, rItr);
            this.streamingState.fnOutputs[i].add(out);
        }
        ArrayList<Object> oRows = new ArrayList<Object>();
        while (hasRow = this.streamingState.hasOutputRow()) {
            oRows.add(this.streamingState.nextOutputRow());
        }
        return oRows.size() == 0 ? null : oRows;
    }

    @Override
    public List<Object> finishPartition() throws HiveException {
        if (this.streamingState.rankLimitReached()) {
            return null;
        }
        WindowTableFunctionDef tabDef = (WindowTableFunctionDef)this.getTableDef();
        for (int i = 0; i < tabDef.getWindowFunctions().size(); ++i) {
            int numRowsRemaining;
            WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
            GenericUDAFEvaluator fnEval = wFn.getWFnEval();
            if (fnEval instanceof ISupportStreamingModeForWindowing) {
                fnEval.terminate(this.streamingState.aggBuffers[i]);
                WindowingFunctionInfoHelper wFnInfo = this.getWindowingFunctionInfoHelper(wFn.getName());
                if (!wFnInfo.isSupportsWindow()) {
                    numRowsRemaining = ((ISupportStreamingModeForWindowing)((Object)fnEval)).getRowsRemainingAfterTerminate();
                }
                if (numRowsRemaining == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) continue;
                while (numRowsRemaining > 0) {
                    Object out = ((ISupportStreamingModeForWindowing)((Object)fnEval)).getNextResult(this.streamingState.aggBuffers[i]);
                    if (out != null) {
                        this.streamingState.fnOutputs[i].add(out == ISupportStreamingModeForWindowing.NULL_RESULT ? null : out);
                    }
                    --numRowsRemaining;
                }
                continue;
            }
            for (numRowsRemaining = wFn.getWindowFrame().getEnd().getAmt(); numRowsRemaining > 0; --numRowsRemaining) {
                int rowToProcess = this.streamingState.rollingPart.size() - numRowsRemaining;
                Range rng = this.getRange(wFn, rowToProcess, this.streamingState.rollingPart, this.streamingState.order);
                PTFPartition.PTFPartitionIterator<Object> rItr = rng.iterator();
                PTFOperator.connectLeadLagFunctionsToPartition(this.ptfDesc, rItr);
                Object out = this.evaluateWindowFunction(wFn, rItr);
                this.streamingState.fnOutputs[i].add(out);
            }
        }
        ArrayList<Object> oRows = new ArrayList<Object>();
        while (!this.streamingState.rollingPart.processedAllRows() && !this.streamingState.rankLimitReached()) {
            boolean hasRow = this.streamingState.hasOutputRow();
            if (!hasRow && !this.streamingState.rankLimitReached()) {
                throw new HiveException("Internal Error: cannot generate all output rows for a Partition");
            }
            if (!hasRow) continue;
            oRows.add(this.streamingState.nextOutputRow());
        }
        return oRows.size() == 0 ? null : oRows;
    }

    @Override
    public boolean canIterateOutput() {
        return true;
    }

    @Override
    public Iterator<Object> iterator(PTFPartition.PTFPartitionIterator<Object> pItr) throws HiveException {
        WindowTableFunctionDef wTFnDef = (WindowTableFunctionDef)this.getTableDef();
        ArrayList<Object> output = new ArrayList<Object>();
        List[] outputFromPivotFunctions = new List[wTFnDef.getWindowFunctions().size()];
        ArrayList<Integer> wFnsWithWindows = new ArrayList<Integer>();
        PTFPartition iPart = pItr.getPartition();
        int i = 0;
        for (WindowFunctionDef wFn : wTFnDef.getWindowFunctions()) {
            boolean processWindow = this.processWindow(wFn);
            pItr.reset();
            if (!processWindow && !wFn.isPivotResult()) {
                Object out = this.evaluateWindowFunction(wFn, pItr);
                output.add(out);
            } else if (wFn.isPivotResult()) {
                GenericUDAFEvaluator streamingEval = wFn.getWFnEval().getWindowingEvaluator(wFn.getWindowFrame());
                if (streamingEval != null && streamingEval instanceof ISupportStreamingModeForWindowing) {
                    ISupportStreamingModeForWindowing strEval = (ISupportStreamingModeForWindowing)((Object)streamingEval);
                    if (strEval.getRowsRemainingAfterTerminate() == 0) {
                        wFn.setWFnEval(streamingEval);
                        if (wFn.getOI() instanceof ListObjectInspector) {
                            ListObjectInspector listOI = (ListObjectInspector)wFn.getOI();
                            wFn.setOI(listOI.getListElementObjectInspector());
                        }
                        output.add(null);
                        wFnsWithWindows.add(i);
                    } else {
                        outputFromPivotFunctions[i] = (List)this.evaluateWindowFunction(wFn, pItr);
                        output.add(null);
                    }
                } else {
                    outputFromPivotFunctions[i] = (List)this.evaluateWindowFunction(wFn, pItr);
                    output.add(null);
                }
            } else {
                output.add(null);
                wFnsWithWindows.add(i);
            }
            ++i;
        }
        for (i = 0; i < iPart.getOutputOI().getAllStructFieldRefs().size(); ++i) {
            output.add(null);
        }
        if (wTFnDef.getRankLimit() != -1) {
            this.rnkLimitDef = new RankLimit(wTFnDef.getRankLimit(), wTFnDef.getRankLimitFunction(), wTFnDef.getWindowFunctions());
        }
        return new WindowingIterator(iPart, output, outputFromPivotFunctions, ArrayUtils.toPrimitive(wFnsWithWindows.toArray(new Integer[wFnsWithWindows.size()])));
    }

    ArrayList<Object> executeFnwithWindow(PTFDesc ptfDesc, WindowFunctionDef wFnDef, PTFPartition iPart, PTFInvocationSpec.Order order) throws HiveException {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (int i = 0; i < iPart.size(); ++i) {
            Range rng = this.getRange(wFnDef, i, iPart, order);
            PTFPartition.PTFPartitionIterator<Object> rItr = rng.iterator();
            PTFOperator.connectLeadLagFunctionsToPartition(ptfDesc, rItr);
            Object out = this.evaluateWindowFunction(wFnDef, rItr);
            vals.add(out);
        }
        return vals;
    }

    Range getRange(WindowFunctionDef wFnDef, int currRow, PTFPartition p, PTFInvocationSpec.Order order) throws HiveException {
        int end;
        int start;
        BoundaryDef startB = wFnDef.getWindowFrame().getStart();
        BoundaryDef endB = wFnDef.getWindowFrame().getEnd();
        boolean rowFrame = true;
        if (startB instanceof ValueBoundaryDef || endB instanceof ValueBoundaryDef) {
            rowFrame = false;
        }
        if (rowFrame) {
            start = this.getRowBoundaryStart(startB, currRow);
            end = this.getRowBoundaryEnd(endB, currRow, p);
        } else {
            ValueBoundaryScanner vbs = startB instanceof ValueBoundaryDef ? ValueBoundaryScanner.getScanner((ValueBoundaryDef)startB, order) : ValueBoundaryScanner.getScanner((ValueBoundaryDef)endB, order);
            vbs.reset(startB);
            start = vbs.computeStart(currRow, p);
            vbs.reset(endB);
            end = vbs.computeEnd(currRow, p);
        }
        start = start < 0 ? 0 : start;
        end = end > p.size() ? p.size() : end;
        return new Range(start, end, p);
    }

    int getRowBoundaryStart(BoundaryDef b, int currRow) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    return 0;
                }
                return currRow - amt;
            }
            case CURRENT: {
                return currRow;
            }
            case FOLLOWING: {
                return currRow + amt;
            }
        }
        throw new HiveException("Unknown Start Boundary Direction: " + (Object)((Object)d));
    }

    int getRowBoundaryEnd(BoundaryDef b, int currRow, PTFPartition p) throws HiveException {
        WindowingSpec.Direction d = b.getDirection();
        int amt = b.getAmt();
        switch (d) {
            case PRECEDING: {
                if (amt == 0) {
                    return currRow + 1;
                }
                return currRow - amt;
            }
            case CURRENT: {
                return currRow + 1;
            }
            case FOLLOWING: {
                if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                    return p.size();
                }
                return currRow + amt + 1;
            }
        }
        throw new HiveException("Unknown End Boundary Direction: " + (Object)((Object)d));
    }

    static class RankLimit {
        final int rankLimit;
        int currentRank;
        final int rankFnIdx;
        final PrimitiveObjectInspector fnOutOI;

        RankLimit(int rankLimit, int rankFnIdx, List<WindowFunctionDef> wdwFnDefs) {
            this.rankLimit = rankLimit;
            this.rankFnIdx = rankFnIdx;
            this.fnOutOI = (PrimitiveObjectInspector)wdwFnDefs.get(rankFnIdx).getOI();
            this.currentRank = -1;
        }

        RankLimit(RankLimit rl) {
            this.rankLimit = rl.rankLimit;
            this.rankFnIdx = rl.rankFnIdx;
            this.fnOutOI = rl.fnOutOI;
            this.currentRank = -1;
        }

        void reset() {
            this.currentRank = -1;
        }

        void updateRank(List<Object> oRow) {
            int r = (Integer)this.fnOutOI.getPrimitiveJavaObject(oRow.get(this.rankFnIdx));
            if (r > this.currentRank) {
                this.currentRank = r;
            }
        }

        boolean limitReached() {
            return this.currentRank >= this.rankLimit;
        }
    }

    class StreamingState {
        PTFRollingPartition rollingPart;
        List<Object>[] fnOutputs;
        GenericUDAFEvaluator.AggregationBuffer[] aggBuffers;
        Object[][] funcArgs;
        PTFInvocationSpec.Order order;
        RankLimit rnkLimit;

        StreamingState(Configuration cfg, StructObjectInspector inputOI, boolean isMapSide, WindowTableFunctionDef tabDef, int precedingSpan, int followingSpan) throws HiveException {
            SerDe serde = isMapSide ? tabDef.getInput().getOutputShape().getSerde() : tabDef.getRawInputShape().getSerde();
            StructObjectInspector outputOI = isMapSide ? tabDef.getInput().getOutputShape().getOI() : tabDef.getRawInputShape().getOI();
            this.rollingPart = PTFPartition.createRolling(cfg, serde, inputOI, outputOI, precedingSpan, followingSpan);
            this.order = tabDef.getOrder().getExpressions().get(0).getOrder();
            int numFns = tabDef.getWindowFunctions().size();
            this.fnOutputs = new ArrayList[numFns];
            this.aggBuffers = new GenericUDAFEvaluator.AggregationBuffer[numFns];
            this.funcArgs = new Object[numFns][];
            for (int i = 0; i < numFns; ++i) {
                this.fnOutputs[i] = new ArrayList<Object>();
                WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
                this.funcArgs[i] = new Object[wFn.getArgs() == null ? 0 : wFn.getArgs().size()];
                this.aggBuffers[i] = wFn.getWFnEval().getNewAggregationBuffer();
            }
            if (WindowingTableFunction.this.rnkLimitDef != null) {
                this.rnkLimit = new RankLimit(WindowingTableFunction.this.rnkLimitDef);
            }
        }

        void reset(WindowTableFunctionDef tabDef) throws HiveException {
            int i;
            int numFns = tabDef.getWindowFunctions().size();
            this.rollingPart.reset();
            for (i = 0; i < this.fnOutputs.length; ++i) {
                this.fnOutputs[i].clear();
            }
            for (i = 0; i < numFns; ++i) {
                WindowFunctionDef wFn = tabDef.getWindowFunctions().get(i);
                this.aggBuffers[i] = wFn.getWFnEval().getNewAggregationBuffer();
            }
            if (this.rnkLimit != null) {
                this.rnkLimit.reset();
            }
        }

        boolean hasOutputRow() {
            if (this.rankLimitReached()) {
                return false;
            }
            for (int i = 0; i < this.fnOutputs.length; ++i) {
                if (this.fnOutputs[i].size() != 0) continue;
                return false;
            }
            return true;
        }

        List<Object> nextOutputRow() throws HiveException {
            ArrayList<Object> oRow = new ArrayList<Object>();
            Object iRow = this.rollingPart.nextOutputRow();
            for (int i = 0; i < this.fnOutputs.length; ++i) {
                oRow.add(this.fnOutputs[i].remove(0));
            }
            for (StructField structField : this.rollingPart.getOutputOI().getAllStructFieldRefs()) {
                oRow.add(this.rollingPart.getOutputOI().getStructFieldData(iRow, structField));
            }
            if (this.rnkLimit != null) {
                this.rnkLimit.updateRank(oRow);
            }
            return oRow;
        }

        boolean rankLimitReached() {
            return this.rnkLimit != null && this.rnkLimit.limitReached();
        }
    }

    public class WindowingIterator
    implements Iterator<Object> {
        ArrayList<Object> output;
        List<?>[] outputFromPivotFunctions;
        int currIdx;
        PTFPartition iPart;
        int[] wFnsToProcess;
        WindowTableFunctionDef wTFnDef;
        PTFInvocationSpec.Order order;
        PTFDesc ptfDesc;
        StructObjectInspector inputOI;
        GenericUDAFEvaluator.AggregationBuffer[] aggBuffers;
        Object[][] args;
        RankLimit rnkLimit;

        WindowingIterator(PTFPartition iPart, ArrayList<Object> output, List<?>[] outputFromPivotFunctions, int[] wFnsToProcess) {
            this.iPart = iPart;
            this.output = output;
            this.outputFromPivotFunctions = outputFromPivotFunctions;
            this.wFnsToProcess = wFnsToProcess;
            this.currIdx = 0;
            this.wTFnDef = (WindowTableFunctionDef)WindowingTableFunction.this.getTableDef();
            this.order = this.wTFnDef.getOrder().getExpressions().get(0).getOrder();
            this.ptfDesc = WindowingTableFunction.this.getQueryDef();
            this.inputOI = iPart.getOutputOI();
            this.aggBuffers = new GenericUDAFEvaluator.AggregationBuffer[this.wTFnDef.getWindowFunctions().size()];
            this.args = new Object[this.wTFnDef.getWindowFunctions().size()][];
            try {
                for (int j : wFnsToProcess) {
                    WindowFunctionDef wFn = this.wTFnDef.getWindowFunctions().get(j);
                    this.aggBuffers[j] = wFn.getWFnEval().getNewAggregationBuffer();
                    this.args[j] = new Object[wFn.getArgs() == null ? 0 : wFn.getArgs().size()];
                }
            }
            catch (HiveException he) {
                throw new RuntimeException(he);
            }
            if (WindowingTableFunction.this.rnkLimitDef != null) {
                this.rnkLimit = new RankLimit(WindowingTableFunction.this.rnkLimitDef);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.rnkLimit != null && this.rnkLimit.limitReached()) {
                return false;
            }
            return this.currIdx < this.iPart.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object next() {
            int i;
            for (i = 0; i < this.outputFromPivotFunctions.length; ++i) {
                if (this.outputFromPivotFunctions[i] == null) continue;
                this.output.set(i, this.outputFromPivotFunctions[i].get(this.currIdx));
            }
            try {
                void var4_7;
                int[] arr$ = this.wFnsToProcess;
                int len$ = arr$.length;
                boolean bl = false;
                while (var4_7 < len$) {
                    int j = arr$[var4_7];
                    WindowFunctionDef wFn = this.wTFnDef.getWindowFunctions().get(j);
                    if (wFn.getWFnEval() instanceof ISupportStreamingModeForWindowing) {
                        Object iRow = this.iPart.getAt(this.currIdx);
                        int a = 0;
                        if (wFn.getArgs() != null) {
                            for (PTFExpressionDef arg : wFn.getArgs()) {
                                this.args[j][a++] = arg.getExprEvaluator().evaluate(iRow);
                            }
                        }
                        wFn.getWFnEval().aggregate(this.aggBuffers[j], this.args[j]);
                        Object out = ((ISupportStreamingModeForWindowing)((Object)wFn.getWFnEval())).getNextResult(this.aggBuffers[j]);
                        out = ObjectInspectorUtils.copyToStandardObject(out, wFn.getOI());
                        this.output.set(j, out);
                    } else {
                        Range rng = WindowingTableFunction.this.getRange(wFn, this.currIdx, this.iPart, this.order);
                        PTFPartition.PTFPartitionIterator<Object> rItr = rng.iterator();
                        PTFOperator.connectLeadLagFunctionsToPartition(this.ptfDesc, rItr);
                        this.output.set(j, WindowingTableFunction.this.evaluateWindowFunction(wFn, rItr));
                    }
                    ++var4_7;
                }
                Object iRow = this.iPart.getAt(this.currIdx);
                i = this.wTFnDef.getWindowFunctions().size();
                for (StructField structField : this.inputOI.getAllStructFieldRefs()) {
                    this.output.set(i++, this.inputOI.getStructFieldData(iRow, structField));
                }
            }
            catch (HiveException he) {
                throw new RuntimeException(he);
            }
            if (this.rnkLimit != null) {
                this.rnkLimit.updateRank(this.output);
            }
            ++this.currIdx;
            return this.output;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class SameList<E>
    extends AbstractList<E> {
        int sz;
        E val;

        public SameList(int sz, E val) {
            this.sz = sz;
            this.val = val;
        }

        @Override
        public E get(int index) {
            return this.val;
        }

        @Override
        public int size() {
            return this.sz;
        }
    }

    public static class StringValueBoundaryScanner
    extends ValueBoundaryScanner {
        public StringValueBoundaryScanner(BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFExpressionDef expressionDef) {
            super(bndDef, order, expressionDef);
        }

        @Override
        public boolean isGreater(Object v1, Object v2, int amt) {
            String s1 = PrimitiveObjectInspectorUtils.getString(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            String s2 = PrimitiveObjectInspectorUtils.getString(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return s1 != null && s2 != null && s1.compareTo(s2) > 0;
        }

        @Override
        public boolean isEqual(Object v1, Object v2) {
            String s1 = PrimitiveObjectInspectorUtils.getString(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            String s2 = PrimitiveObjectInspectorUtils.getString(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return s1 == null && s2 == null || s1 != null && s1.equals(s2);
        }
    }

    public static class HiveDecimalValueBoundaryScanner
    extends ValueBoundaryScanner {
        public HiveDecimalValueBoundaryScanner(BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFExpressionDef expressionDef) {
            super(bndDef, order, expressionDef);
        }

        @Override
        public boolean isGreater(Object v1, Object v2, int amt) {
            HiveDecimal d1 = PrimitiveObjectInspectorUtils.getHiveDecimal(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            HiveDecimal d2 = PrimitiveObjectInspectorUtils.getHiveDecimal(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
            if (d1 == null || d2 == null) {
                return false;
            }
            return d1.subtract(d2).intValue() > amt;
        }

        @Override
        public boolean isEqual(Object v1, Object v2) {
            HiveDecimal d1 = PrimitiveObjectInspectorUtils.getHiveDecimal(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            HiveDecimal d2 = PrimitiveObjectInspectorUtils.getHiveDecimal(v2, (PrimitiveObjectInspector)this.expressionDef.getOI());
            if (d1 == null || d2 == null) {
                return false;
            }
            return d1.equals(d2);
        }
    }

    public static class DoubleValueBoundaryScanner
    extends ValueBoundaryScanner {
        public DoubleValueBoundaryScanner(BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFExpressionDef expressionDef) {
            super(bndDef, order, expressionDef);
        }

        @Override
        public boolean isGreater(Object v1, Object v2, int amt) {
            double d2;
            double d1 = PrimitiveObjectInspectorUtils.getDouble(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return d1 - (d2 = PrimitiveObjectInspectorUtils.getDouble(v2, (PrimitiveObjectInspector)this.expressionDef.getOI())) > (double)amt;
        }

        @Override
        public boolean isEqual(Object v1, Object v2) {
            double d2;
            double d1 = PrimitiveObjectInspectorUtils.getDouble(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return d1 == (d2 = PrimitiveObjectInspectorUtils.getDouble(v2, (PrimitiveObjectInspector)this.expressionDef.getOI()));
        }
    }

    public static class LongValueBoundaryScanner
    extends ValueBoundaryScanner {
        public LongValueBoundaryScanner(BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFExpressionDef expressionDef) {
            super(bndDef, order, expressionDef);
        }

        @Override
        public boolean isGreater(Object v1, Object v2, int amt) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getLong(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return l1 - (l2 = PrimitiveObjectInspectorUtils.getLong(v2, (PrimitiveObjectInspector)this.expressionDef.getOI())) > (long)amt;
        }

        @Override
        public boolean isEqual(Object v1, Object v2) {
            long l2;
            long l1 = PrimitiveObjectInspectorUtils.getLong(v1, (PrimitiveObjectInspector)this.expressionDef.getOI());
            return l1 == (l2 = PrimitiveObjectInspectorUtils.getLong(v2, (PrimitiveObjectInspector)this.expressionDef.getOI()));
        }
    }

    static abstract class ValueBoundaryScanner {
        BoundaryDef bndDef;
        PTFInvocationSpec.Order order;
        PTFExpressionDef expressionDef;

        public ValueBoundaryScanner(BoundaryDef bndDef, PTFInvocationSpec.Order order, PTFExpressionDef expressionDef) {
            this.bndDef = bndDef;
            this.order = order;
            this.expressionDef = expressionDef;
        }

        public void reset(BoundaryDef bndDef) {
            this.bndDef = bndDef;
        }

        protected int computeStart(int rowIdx, PTFPartition p) throws HiveException {
            switch (this.bndDef.getDirection()) {
                case PRECEDING: {
                    return this.computeStartPreceding(rowIdx, p);
                }
                case CURRENT: {
                    return this.computeStartCurrentRow(rowIdx, p);
                }
            }
            return this.computeStartFollowing(rowIdx, p);
        }

        protected int computeStartPreceding(int rowIdx, PTFPartition p) throws HiveException {
            int amt = this.bndDef.getAmt();
            if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                return 0;
            }
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.ASC) {
                    return 0;
                }
                while (sortKey == null && rowIdx >= 0) {
                    if (--rowIdx < 0) continue;
                    sortKey = this.computeValue(p.getAt(rowIdx));
                }
                return rowIdx + 1;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r >= 0 && !this.isGreater(rowVal, sortKey, amt)) {
                    if (--r < 0) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r + 1;
            }
            while (r >= 0 && !this.isGreater(sortKey, rowVal, amt)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }

        protected int computeStartCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                while (sortKey == null && rowIdx >= 0) {
                    if (--rowIdx < 0) continue;
                    sortKey = this.computeValue(p.getAt(rowIdx));
                }
                return rowIdx + 1;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            while (r >= 0 && this.isEqual(rowVal, sortKey)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }

        protected int computeStartFollowing(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey;
            int amt = this.bndDef.getAmt();
            Object rowVal = sortKey = this.computeValue(p.getAt(rowIdx));
            int r = rowIdx;
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.DESC) {
                    return p.size();
                }
                while (r < p.size() && rowVal == null) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r < p.size() && !this.isGreater(sortKey, rowVal, amt)) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            while (r < p.size() && !this.isGreater(rowVal, sortKey, amt)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }

        protected int computeEnd(int rowIdx, PTFPartition p) throws HiveException {
            switch (this.bndDef.getDirection()) {
                case PRECEDING: {
                    return this.computeEndPreceding(rowIdx, p);
                }
                case CURRENT: {
                    return this.computeEndCurrentRow(rowIdx, p);
                }
            }
            return this.computeEndFollowing(rowIdx, p);
        }

        protected int computeEndPreceding(int rowIdx, PTFPartition p) throws HiveException {
            int amt = this.bndDef.getAmt();
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.DESC) {
                    return p.size();
                }
                return 0;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r >= 0 && !this.isGreater(rowVal, sortKey, amt)) {
                    if (--r < 0) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r + 1;
            }
            while (r >= 0 && !this.isGreater(sortKey, rowVal, amt)) {
                if (--r < 0) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r + 1;
        }

        protected int computeEndCurrentRow(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey = this.computeValue(p.getAt(rowIdx));
            if (sortKey == null) {
                while (sortKey == null && rowIdx < p.size()) {
                    if (++rowIdx >= p.size()) continue;
                    sortKey = this.computeValue(p.getAt(rowIdx));
                }
                return rowIdx;
            }
            Object rowVal = sortKey;
            int r = rowIdx;
            while (r < p.size() && this.isEqual(sortKey, rowVal)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }

        protected int computeEndFollowing(int rowIdx, PTFPartition p) throws HiveException {
            Object sortKey;
            int amt = this.bndDef.getAmt();
            if (amt == WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT) {
                return p.size();
            }
            Object rowVal = sortKey = this.computeValue(p.getAt(rowIdx));
            int r = rowIdx;
            if (sortKey == null) {
                if (this.order == PTFInvocationSpec.Order.DESC) {
                    return p.size();
                }
                while (r < p.size() && rowVal == null) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            if (this.order == PTFInvocationSpec.Order.DESC) {
                while (r < p.size() && !this.isGreater(sortKey, rowVal, amt)) {
                    if (++r >= p.size()) continue;
                    rowVal = this.computeValue(p.getAt(r));
                }
                return r;
            }
            while (r < p.size() && !this.isGreater(rowVal, sortKey, amt)) {
                if (++r >= p.size()) continue;
                rowVal = this.computeValue(p.getAt(r));
            }
            return r;
        }

        public Object computeValue(Object row) throws HiveException {
            Object o = this.expressionDef.getExprEvaluator().evaluate(row);
            return ObjectInspectorUtils.copyToStandardObject(o, this.expressionDef.getOI());
        }

        public abstract boolean isGreater(Object var1, Object var2, int var3);

        public abstract boolean isEqual(Object var1, Object var2);

        public static ValueBoundaryScanner getScanner(ValueBoundaryDef vbDef, PTFInvocationSpec.Order order) throws HiveException {
            PrimitiveObjectInspector pOI = (PrimitiveObjectInspector)vbDef.getOI();
            switch (pOI.getPrimitiveCategory()) {
                case BYTE: 
                case INT: 
                case LONG: 
                case SHORT: 
                case TIMESTAMP: {
                    return new LongValueBoundaryScanner(vbDef, order, vbDef.getExpressionDef());
                }
                case DOUBLE: 
                case FLOAT: {
                    return new DoubleValueBoundaryScanner(vbDef, order, vbDef.getExpressionDef());
                }
                case DECIMAL: {
                    return new HiveDecimalValueBoundaryScanner(vbDef, order, vbDef.getExpressionDef());
                }
                case STRING: {
                    return new StringValueBoundaryScanner(vbDef, order, vbDef.getExpressionDef());
                }
            }
            throw new HiveException(String.format("Internal Error: attempt to setup a Window for datatype %s", new Object[]{pOI.getPrimitiveCategory()}));
        }
    }

    static class Range {
        int start;
        int end;
        PTFPartition p;

        public Range(int start, int end, PTFPartition p) {
            this.start = start;
            this.end = end;
            this.p = p;
        }

        public PTFPartition.PTFPartitionIterator<Object> iterator() {
            return this.p.range(this.start, this.end);
        }
    }

    public static class WindowingTableFunctionResolver
    extends TableFunctionResolver {
        private transient StructObjectInspector wdwProcessingOutputOI;

        public StructObjectInspector getWdwProcessingOutputOI() {
            return this.wdwProcessingOutputOI;
        }

        public void setWdwProcessingOutputOI(StructObjectInspector wdwProcessingOutputOI) {
            this.wdwProcessingOutputOI = wdwProcessingOutputOI;
        }

        @Override
        protected TableFunctionEvaluator createEvaluator(PTFDesc ptfDesc, PartitionedTableFunctionDef tDef) {
            return new WindowingTableFunction();
        }

        @Override
        public void setupOutputOI() throws SemanticException {
            this.setOutputOI(this.wdwProcessingOutputOI);
        }

        @Override
        public void initializeOutputOI() throws HiveException {
            this.setupOutputOI();
        }

        @Override
        public boolean transformsRawInput() {
            return false;
        }

        @Override
        public boolean carryForwardNames() {
            return true;
        }

        public ArrayList<String> getOutputColumnNames() {
            return null;
        }
    }

    static class WindowingFunctionInfoHelper {
        private boolean supportsWindow;

        WindowingFunctionInfoHelper() {
        }

        public WindowingFunctionInfoHelper(boolean supportsWindow) {
            this.supportsWindow = supportsWindow;
        }

        public boolean isSupportsWindow() {
            return this.supportsWindow;
        }

        public void setSupportsWindow(boolean supportsWindow) {
            this.supportsWindow = supportsWindow;
        }
    }
}

