/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.Map;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParametersImpl;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyMapObjectInspector
implements MapObjectInspector {
    public static final Log LOG = LogFactory.getLog(LazyMapObjectInspector.class.getName());
    private ObjectInspector mapKeyObjectInspector;
    private ObjectInspector mapValueObjectInspector;
    private byte itemSeparator;
    private byte keyValueSeparator;
    private LazyObjectInspectorParameters lazyParams;

    protected LazyMapObjectInspector() {
        this.lazyParams = new LazyObjectInspectorParametersImpl();
    }

    protected LazyMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, byte itemSeparator, byte keyValueSeparator, Text nullSequence, boolean escaped, byte escapeChar) {
        this.mapKeyObjectInspector = mapKeyObjectInspector;
        this.mapValueObjectInspector = mapValueObjectInspector;
        this.itemSeparator = itemSeparator;
        this.keyValueSeparator = keyValueSeparator;
        this.lazyParams = new LazyObjectInspectorParametersImpl(escaped, escapeChar, false, null, null, nullSequence);
    }

    protected LazyMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, byte itemSeparator, byte keyValueSeparator, LazyObjectInspectorParameters lazyParams) {
        this.mapKeyObjectInspector = mapKeyObjectInspector;
        this.mapValueObjectInspector = mapValueObjectInspector;
        this.itemSeparator = itemSeparator;
        this.keyValueSeparator = keyValueSeparator;
        this.lazyParams = lazyParams;
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.MAP;
    }

    @Override
    public String getTypeName() {
        return "map<" + this.mapKeyObjectInspector.getTypeName() + "," + this.mapValueObjectInspector.getTypeName() + ">";
    }

    @Override
    public ObjectInspector getMapKeyObjectInspector() {
        return this.mapKeyObjectInspector;
    }

    @Override
    public ObjectInspector getMapValueObjectInspector() {
        return this.mapValueObjectInspector;
    }

    @Override
    public Object getMapValueElement(Object data, Object key) {
        return data == null || key == null ? null : ((LazyMap)data).getMapValueElement(key);
    }

    @Override
    public Map<?, ?> getMap(Object data) {
        if (data == null) {
            return null;
        }
        return ((LazyMap)data).getMap();
    }

    @Override
    public int getMapSize(Object data) {
        if (data == null) {
            return -1;
        }
        return ((LazyMap)data).getMapSize();
    }

    public byte getItemSeparator() {
        return this.itemSeparator;
    }

    public byte getKeyValueSeparator() {
        return this.keyValueSeparator;
    }

    public Text getNullSequence() {
        return this.lazyParams.getNullSequence();
    }

    public boolean isEscaped() {
        return this.lazyParams.isEscaped();
    }

    public byte getEscapeChar() {
        return this.lazyParams.getEscapeChar();
    }

    public LazyObjectInspectorParameters getLazyParams() {
        return this.lazyParams;
    }
}

