/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.base.Throwables;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.joda.time.DateTimeZone;

public class HivePageSource
implements ConnectorPageSource {
    private List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Object[] prefilledValues;
    private final Type[] types;
    private final Function<Block, Block>[] coercers;
    private final ConnectorPageSource delegate;

    public HivePageSource(List<HivePageSourceProvider.ColumnMapping> columnMappings, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, ConnectorPageSource delegate) {
        Objects.requireNonNull(columnMappings, "columnMappings is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        int size = columnMappings.size();
        this.prefilledValues = new Object[size];
        this.types = new Type[size];
        this.coercers = new Function[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Comparable<Boolean> prefilledValue;
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            HiveColumnHandle column = columnMapping.getHiveColumnHandle();
            String name = column.getName();
            this.types[columnIndex] = type = typeManager.getType(column.getTypeSignature());
            if (columnMapping.getCoercionFrom().isPresent()) {
                this.coercers[columnIndex] = HivePageSource.createCoercer(typeManager, columnMapping.getCoercionFrom().get(), columnMapping.getHiveColumnHandle().getHiveType());
            }
            if (!columnMapping.isPrefilled()) continue;
            String columnValue = columnMapping.getPrefilledValue();
            byte[] bytes = columnValue.getBytes(StandardCharsets.UTF_8);
            if (HiveUtil.isHiveNull(bytes)) {
                prefilledValue = null;
            } else if (type.equals(BooleanType.BOOLEAN)) {
                prefilledValue = HiveUtil.booleanPartitionKey(columnValue, name);
            } else if (type.equals(BigintType.BIGINT)) {
                prefilledValue = HiveUtil.bigintPartitionKey(columnValue, name);
            } else if (type.equals(IntegerType.INTEGER)) {
                prefilledValue = HiveUtil.integerPartitionKey(columnValue, name);
            } else if (type.equals(SmallintType.SMALLINT)) {
                prefilledValue = HiveUtil.smallintPartitionKey(columnValue, name);
            } else if (type.equals(TinyintType.TINYINT)) {
                prefilledValue = HiveUtil.tinyintPartitionKey(columnValue, name);
            } else if (type.equals(RealType.REAL)) {
                prefilledValue = HiveUtil.floatPartitionKey(columnValue, name);
            } else if (type.equals(DoubleType.DOUBLE)) {
                prefilledValue = HiveUtil.doublePartitionKey(columnValue, name);
            } else if (Varchars.isVarcharType((Type)type)) {
                prefilledValue = HiveUtil.varcharPartitionKey(columnValue, name, type);
            } else if (Chars.isCharType((Type)type)) {
                prefilledValue = HiveUtil.charPartitionKey(columnValue, name, type);
            } else if (type.equals(DateType.DATE)) {
                prefilledValue = HiveUtil.datePartitionKey(columnValue, name);
            } else if (type.equals(TimestampType.TIMESTAMP)) {
                prefilledValue = HiveUtil.timestampPartitionKey(columnValue, hiveStorageTimeZone, name);
            } else if (Decimals.isShortDecimal((Type)type)) {
                prefilledValue = HiveUtil.shortDecimalPartitionKey(columnValue, (DecimalType)type, name);
            } else if (Decimals.isLongDecimal((Type)type)) {
                prefilledValue = HiveUtil.longDecimalPartitionKey(columnValue, (DecimalType)type, name);
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for prefilled column: %s", type.getDisplayName(), name));
            }
            this.prefilledValues[columnIndex] = prefilledValue;
        }
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Block[] blocks = new Block[this.columnMappings.size()];
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            int batchSize = dataPage.getPositionCount();
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(fieldId);
                if (columnMapping.isPrefilled()) {
                    blocks[fieldId] = RunLengthEncodedBlock.create((Type)this.types[fieldId], (Object)this.prefilledValues[fieldId], (int)batchSize);
                    continue;
                }
                blocks[fieldId] = dataPage.getBlock(columnMapping.getIndex());
                if (this.coercers[fieldId] == null) continue;
                blocks[fieldId] = new LazyBlock(batchSize, (LazyBlockLoader)new CoercionLazyBlockLoader(blocks[fieldId], this.coercers[fieldId]));
            }
            return new Page(batchSize, blocks);
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    public ConnectorPageSource getPageSource() {
        return this.delegate;
    }

    private static Function<Block, Block> createCoercer(TypeManager typeManager, HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = typeManager.getType(toHiveType.getTypeSignature());
        if (toType instanceof VarcharType && (fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG))) {
            return new IntegerNumberToVarcharCoercer(fromType, toType);
        }
        if (fromType instanceof VarcharType && (toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG))) {
            return new VarcharToIntegerNumberCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE) && toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT) && toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_INT) && toHiveType.equals(HiveType.HIVE_LONG)) {
            return new IntegerNumberUpscaleCoercer(fromType, toType);
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT) && toHiveType.equals(HiveType.HIVE_DOUBLE)) {
            return new FloatToDoubleCoercer();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported coercion from %s to %s", fromHiveType, toHiveType));
    }

    private final class CoercionLazyBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final Function<Block, Block> coercer;
        private Block block;

        public CoercionLazyBlockLoader(Block block, Function<Block, Block> coercer) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.coercer = Objects.requireNonNull(coercer, "coercer is null");
        }

        public void load(LazyBlock lazyBlock) {
            if (this.block == null) {
                return;
            }
            Block coercedBlock = this.coercer.apply(this.block);
            lazyBlock.setBlock(coercedBlock);
            this.block = null;
        }
    }

    private static class FloatToDoubleCoercer
    implements Function<Block, Block> {
        private FloatToDoubleCoercer() {
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(new BlockBuilderStatus(), block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                DoubleType.DOUBLE.writeDouble(blockBuilder, (double)Float.intBitsToFloat((int)RealType.REAL.getLong(block, i)));
            }
            return blockBuilder.build();
        }
    }

    private static class VarcharToIntegerNumberCoercer
    implements Function<Block, Block> {
        private final Type fromType;
        private final Type toType;
        private final long minValue;
        private final long maxValue;

        public VarcharToIntegerNumberCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
            if (toType.equals(TinyintType.TINYINT)) {
                this.minValue = -128L;
                this.maxValue = 127L;
            } else if (toType.equals(SmallintType.SMALLINT)) {
                this.minValue = -32768L;
                this.maxValue = 32767L;
            } else if (toType.equals(IntegerType.INTEGER)) {
                this.minValue = Integer.MIN_VALUE;
                this.maxValue = Integer.MAX_VALUE;
            } else if (toType.equals(BigintType.BIGINT)) {
                this.minValue = Long.MIN_VALUE;
                this.maxValue = Long.MAX_VALUE;
            } else {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Could not create Coercer from from varchar to %s", toType));
            }
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(new BlockBuilderStatus(), block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                try {
                    long value = Long.parseLong(this.fromType.getSlice(block, i).toStringUtf8());
                    if (this.minValue <= value && value <= this.maxValue) {
                        this.toType.writeLong(blockBuilder, value);
                        continue;
                    }
                    blockBuilder.appendNull();
                    continue;
                }
                catch (NumberFormatException e) {
                    blockBuilder.appendNull();
                }
            }
            return blockBuilder.build();
        }
    }

    private static class IntegerNumberToVarcharCoercer
    implements Function<Block, Block> {
        private final Type fromType;
        private final Type toType;

        public IntegerNumberToVarcharCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(new BlockBuilderStatus(), block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.toType.writeSlice(blockBuilder, Slices.utf8Slice((String)String.valueOf(this.fromType.getLong(block, i))));
            }
            return blockBuilder.build();
        }
    }

    private static class IntegerNumberUpscaleCoercer
    implements Function<Block, Block> {
        private final Type fromType;
        private final Type toType;

        public IntegerNumberUpscaleCoercer(Type fromType, Type toType) {
            this.fromType = Objects.requireNonNull(fromType, "fromType is null");
            this.toType = Objects.requireNonNull(toType, "toType is null");
        }

        @Override
        public Block apply(Block block) {
            BlockBuilder blockBuilder = this.toType.createBlockBuilder(new BlockBuilderStatus(), block.getPositionCount());
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    blockBuilder.appendNull();
                    continue;
                }
                this.toType.writeLong(blockBuilder, this.fromType.getLong(block, i));
            }
            return blockBuilder.build();
        }
    }
}

