/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveClientConfig;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.List;
import javax.inject.Inject;

public final class HiveSessionProperties {
    private static final String BUCKET_EXECUTION_ENABLED = "bucket_execution_enabled";
    private static final String FORCE_LOCAL_SCHEDULING = "force_local_scheduling";
    private static final String ORC_BLOOM_FILTERS_ENABLED = "orc_bloom_filters_enabled";
    private static final String ORC_MAX_MERGE_DISTANCE = "orc_max_merge_distance";
    private static final String ORC_MAX_BUFFER_SIZE = "orc_max_buffer_size";
    private static final String ORC_STREAM_BUFFER_SIZE = "orc_stream_buffer_size";
    private static final String ORC_MAX_READ_BLOCK_SIZE = "orc_max_read_block_size";
    private static final String ORC_LAZY_READ_SMALL_RANGES = "orc_lazy_read_small_ranges";
    private static final String ORC_OPTIMIZED_WRITER_ENABLED = "orc_optimized_writer_enabled";
    private static final String ORC_OPTIMIZED_WRITER_VALIDATE = "orc_optimized_writer_validate";
    private static final String PARQUET_PREDICATE_PUSHDOWN_ENABLED = "parquet_predicate_pushdown_enabled";
    private static final String PARQUET_OPTIMIZED_READER_ENABLED = "parquet_optimized_reader_enabled";
    private static final String MAX_SPLIT_SIZE = "max_split_size";
    private static final String MAX_INITIAL_SPLIT_SIZE = "max_initial_split_size";
    public static final String RCFILE_OPTIMIZED_WRITER_ENABLED = "rcfile_optimized_writer_enabled";
    private static final String RCFILE_OPTIMIZED_WRITER_VALIDATE = "rcfile_optimized_writer_validate";
    private static final String STATISTICS_ENABLED = "statistics_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public HiveSessionProperties(HiveClientConfig config) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanSessionProperty((String)BUCKET_EXECUTION_ENABLED, (String)"Enable bucket-aware execution: only use a single worker per bucket", (Boolean)config.isBucketExecutionEnabled(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)FORCE_LOCAL_SCHEDULING, (String)"Only schedule splits on workers colocated with data node", (Boolean)config.isForceLocalScheduling(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_BLOOM_FILTERS_ENABLED, (String)"ORC: Enable bloom filters for predicate pushdown", (Boolean)config.isOrcBloomFiltersEnabled(), (boolean)false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_MERGE_DISTANCE, "ORC: Maximum size of gap between two reads to merge into a single read", config.getOrcMaxMergeDistance(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_BUFFER_SIZE, "ORC: Maximum size of a single read", config.getOrcMaxBufferSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_STREAM_BUFFER_SIZE, "ORC: Size of buffer for streaming reads", config.getOrcStreamBufferSize(), false), HiveSessionProperties.dataSizeSessionProperty(ORC_MAX_READ_BLOCK_SIZE, "ORC: Maximum size of a block to read", config.getOrcMaxReadBlockSize(), false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_LAZY_READ_SMALL_RANGES, (String)"Experimental: ORC: Read small file segments lazily", (Boolean)config.isOrcLazyReadSmallRanges(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: ORC: Enable optimized writer", (Boolean)config.isOrcOptimizedWriterEnabled(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)ORC_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: ORC: Validate writer files", (Boolean)true, (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)PARQUET_OPTIMIZED_READER_ENABLED, (String)"Experimental: Parquet: Enable optimized reader", (Boolean)config.isParquetOptimizedReaderEnabled(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)PARQUET_PREDICATE_PUSHDOWN_ENABLED, (String)"Experimental: Parquet: Enable predicate pushdown for Parquet", (Boolean)config.isParquetPredicatePushdownEnabled(), (boolean)false), (Object[])new PropertyMetadata[]{HiveSessionProperties.dataSizeSessionProperty(MAX_SPLIT_SIZE, "Max split size", config.getMaxSplitSize(), true), HiveSessionProperties.dataSizeSessionProperty(MAX_INITIAL_SPLIT_SIZE, "Max initial split size", config.getMaxInitialSplitSize(), true), PropertyMetadata.booleanSessionProperty((String)RCFILE_OPTIMIZED_WRITER_ENABLED, (String)"Experimental: RCFile: Enable optimized writer", (Boolean)config.isRcfileOptimizedWriterEnabled(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)RCFILE_OPTIMIZED_WRITER_VALIDATE, (String)"Experimental: RCFile: Validate writer files", (Boolean)config.isRcfileWriterValidate(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)STATISTICS_ENABLED, (String)"Experimental: Expose table statistics", (Boolean)config.isTableStatisticsEnabled(), (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isBucketExecutionEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(BUCKET_EXECUTION_ENABLED, Boolean.class);
    }

    public static boolean isForceLocalScheduling(ConnectorSession session) {
        return (Boolean)session.getProperty(FORCE_LOCAL_SCHEDULING, Boolean.class);
    }

    public static boolean isParquetOptimizedReaderEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_OPTIMIZED_READER_ENABLED, Boolean.class);
    }

    public static boolean isOrcBloomFiltersEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_BLOOM_FILTERS_ENABLED, Boolean.class);
    }

    public static DataSize getOrcMaxMergeDistance(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_MERGE_DISTANCE, DataSize.class);
    }

    public static DataSize getOrcMaxBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcStreamBufferSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_STREAM_BUFFER_SIZE, DataSize.class);
    }

    public static DataSize getOrcMaxReadBlockSize(ConnectorSession session) {
        return (DataSize)session.getProperty(ORC_MAX_READ_BLOCK_SIZE, DataSize.class);
    }

    public static boolean getOrcLazyReadSmallRanges(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_LAZY_READ_SMALL_RANGES, Boolean.class);
    }

    public static boolean isOrcOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isOrcOptimizedWriterValidate(ConnectorSession session) {
        return (Boolean)session.getProperty(ORC_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
    }

    public static boolean isParquetPredicatePushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PARQUET_PREDICATE_PUSHDOWN_ENABLED, Boolean.class);
    }

    public static DataSize getMaxSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_SPLIT_SIZE, DataSize.class);
    }

    public static DataSize getMaxInitialSplitSize(ConnectorSession session) {
        return (DataSize)session.getProperty(MAX_INITIAL_SPLIT_SIZE, DataSize.class);
    }

    public static boolean isRcfileOptimizedWriterEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_ENABLED, Boolean.class);
    }

    public static boolean isRcfileOptimizedWriterValidate(ConnectorSession session) {
        return (Boolean)session.getProperty(RCFILE_OPTIMIZED_WRITER_VALIDATE, Boolean.class);
    }

    public static boolean isStatisticsEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(STATISTICS_ENABLED, Boolean.class);
    }

    public static PropertyMetadata<DataSize> dataSizeSessionProperty(String name, String description, DataSize defaultValue, boolean hidden) {
        return new PropertyMetadata(name, description, (Type)VarcharType.createUnboundedVarcharType(), DataSize.class, (Object)defaultValue, hidden, value -> DataSize.valueOf((String)((String)value)), DataSize::toString);
    }
}

