/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class HiveTableLayoutHandle
implements ConnectorTableLayoutHandle {
    private final String clientId;
    private final List<ColumnHandle> partitionColumns;
    private final List<HivePartition> partitions;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final TupleDomain<ColumnHandle> promisedPredicate;
    private final Optional<HiveBucketHandle> bucketHandle;

    @JsonCreator
    public HiveTableLayoutHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="partitionColumns") List<ColumnHandle> partitionColumns, @JsonProperty(value="compactEffectivePredicate") TupleDomain<ColumnHandle> compactEffectivePredicate, @JsonProperty(value="promisedPredicate") TupleDomain<ColumnHandle> promisedPredicate, @JsonProperty(value="bucketHandle") Optional<HiveBucketHandle> bucketHandle) {
        this.clientId = Objects.requireNonNull(clientId, "clientId is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.partitions = null;
        this.promisedPredicate = Objects.requireNonNull(promisedPredicate, "promisedPredicate is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
    }

    public HiveTableLayoutHandle(String clientId, List<ColumnHandle> partitionColumns, List<HivePartition> partitions, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, TupleDomain<ColumnHandle> promisedPredicate, Optional<HiveBucketHandle> bucketHandle) {
        this.clientId = Objects.requireNonNull(clientId, "clientId is null");
        this.partitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.promisedPredicate = Objects.requireNonNull(promisedPredicate, "promisedPredicate is null");
        this.bucketHandle = Objects.requireNonNull(bucketHandle, "bucketHandle is null");
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public List<ColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    @JsonIgnore
    public Optional<List<HivePartition>> getPartitions() {
        return Optional.ofNullable(this.partitions);
    }

    @JsonProperty
    public TupleDomain<? extends ColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getPromisedPredicate() {
        return this.promisedPredicate;
    }

    @JsonProperty
    public Optional<HiveBucketHandle> getBucketHandle() {
        return this.bucketHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveTableLayoutHandle that = (HiveTableLayoutHandle)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.partitionColumns, that.partitionColumns) && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.partitionColumns, this.partitions);
    }

    public String toString() {
        return this.clientId.toString();
    }
}

