/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.PrincipalType;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Database {
    public static final String DEFAULT_DATABASE_NAME = "default";
    private final String databaseName;
    private final Optional<String> location;
    private final String ownerName;
    private final PrincipalType ownerType;
    private final Optional<String> comment;
    private final Map<String, String> parameters;

    public Database(String databaseName, Optional<String> location, String ownerName, PrincipalType ownerType, Optional<String> comment, Map<String, String> parameters) {
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.ownerName = Objects.requireNonNull(ownerName, "ownerName is null");
        this.ownerType = Objects.requireNonNull(ownerType, "ownerType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Optional<String> getLocation() {
        return this.location;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public PrincipalType getOwnerType() {
        return this.ownerType;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Database database) {
        return new Builder(database);
    }

    public static class Builder {
        private String databaseName;
        private Optional<String> location = Optional.empty();
        private String ownerName;
        private PrincipalType ownerType;
        private Optional<String> comment = Optional.empty();
        private Map<String, String> parameters = new LinkedHashMap<String, String>();

        public Builder() {
        }

        public Builder(Database database) {
            this.databaseName = database.databaseName;
            this.location = database.location;
            this.ownerName = database.ownerName;
            this.ownerType = database.ownerType;
            this.comment = database.comment;
            this.parameters = database.parameters;
        }

        public Builder setDatabaseName(String databaseName) {
            Objects.requireNonNull(databaseName, "databaseName is null");
            this.databaseName = databaseName;
            return this;
        }

        public Builder setLocation(Optional<String> location) {
            Objects.requireNonNull(location, "location is null");
            this.location = location;
            return this;
        }

        public Builder setOwnerName(String ownerName) {
            Objects.requireNonNull(ownerName, "ownerName is null");
            this.ownerName = ownerName;
            return this;
        }

        public Builder setOwnerType(PrincipalType ownerType) {
            Objects.requireNonNull(ownerType, "ownerType is null");
            this.ownerType = ownerType;
            return this;
        }

        public Builder setComment(Optional<String> comment) {
            Objects.requireNonNull(comment, "comment is null");
            this.comment = comment;
            return this;
        }

        public Builder setParameters(Map<String, String> parameters) {
            Objects.requireNonNull(parameters, "parameters is null");
            this.parameters = parameters;
            return this;
        }

        public Database build() {
            return new Database(this.databaseName, this.location, this.ownerName, this.ownerType, this.comment, this.parameters);
        }
    }
}

