/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Objects;

public class PrincipalPrivileges {
    private final SetMultimap<String, HivePrivilegeInfo> userPrivileges;
    private final SetMultimap<String, HivePrivilegeInfo> rolePrivileges;

    public PrincipalPrivileges(Multimap<String, HivePrivilegeInfo> userPrivileges, Multimap<String, HivePrivilegeInfo> rolePrivileges) {
        this.userPrivileges = ImmutableSetMultimap.copyOf(Objects.requireNonNull(userPrivileges, "userPrivileges is null"));
        this.rolePrivileges = ImmutableSetMultimap.copyOf(Objects.requireNonNull(rolePrivileges, "rolePrivileges is null"));
    }

    public SetMultimap<String, HivePrivilegeInfo> getUserPrivileges() {
        return this.userPrivileges;
    }

    public SetMultimap<String, HivePrivilegeInfo> getRolePrivileges() {
        return this.rolePrivileges;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PrincipalPrivileges table) {
        return new Builder(table);
    }

    public static class Builder {
        private Multimap<String, HivePrivilegeInfo> userPrivileges = ArrayListMultimap.create();
        private Multimap<String, HivePrivilegeInfo> rolePrivileges = ArrayListMultimap.create();

        public Builder() {
        }

        public Builder(PrincipalPrivileges principalPrivileges) {
            this.userPrivileges.putAll(principalPrivileges.getUserPrivileges());
            this.rolePrivileges.putAll(principalPrivileges.getRolePrivileges());
        }

        public Builder setUserPrivileges(Multimap<String, HivePrivilegeInfo> userPrivileges) {
            this.userPrivileges = ArrayListMultimap.create(userPrivileges);
            return this;
        }

        public Builder addUserPriviledge(String userName, HivePrivilegeInfo privilege) {
            this.userPrivileges.put((Object)userName, (Object)privilege);
            return this;
        }

        public Builder setRolePrivileges(Multimap<String, HivePrivilegeInfo> rolePrivileges) {
            this.rolePrivileges = ArrayListMultimap.create(rolePrivileges);
            return this;
        }

        public Builder addRolePriviledge(String roleName, HivePrivilegeInfo privilege) {
            this.rolePrivileges.put((Object)roleName, (Object)privilege);
            return this;
        }
    }
}

