/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.HiveStorageFormat;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class StorageFormat {
    public static final StorageFormat VIEW_STORAGE_FORMAT = StorageFormat.createNullable(null, null, null);
    private final String serDe;
    private final String inputFormat;
    private final String outputFormat;

    private StorageFormat(String serDe, String inputFormat, String outputFormat) {
        this.serDe = serDe;
        this.inputFormat = inputFormat;
        this.outputFormat = outputFormat;
    }

    public String getSerDe() {
        if (this.serDe == null) {
            throw new IllegalStateException("serDe should not be accessed from a null StorageFormat");
        }
        return this.serDe;
    }

    public String getInputFormat() {
        if (this.inputFormat == null) {
            throw new IllegalStateException("inputFormat should not be accessed from a null StorageFormat");
        }
        return this.inputFormat;
    }

    public String getOutputFormat() {
        if (this.outputFormat == null) {
            throw new IllegalStateException("outputFormat should not be accessed from a null StorageFormat");
        }
        return this.outputFormat;
    }

    @JsonProperty(value="serDe")
    public String getSerDeNullable() {
        return this.serDe;
    }

    @JsonProperty(value="inputFormat")
    public String getInputFormatNullable() {
        return this.inputFormat;
    }

    @JsonProperty(value="outputFormat")
    public String getOutputFormatNullable() {
        return this.outputFormat;
    }

    public static StorageFormat fromHiveStorageFormat(HiveStorageFormat hiveStorageFormat) {
        return new StorageFormat(hiveStorageFormat.getSerDe(), hiveStorageFormat.getInputFormat(), hiveStorageFormat.getOutputFormat());
    }

    public static StorageFormat create(String serde, String inputFormat, String outputFormat) {
        return new StorageFormat(Objects.requireNonNull(serde, "serDe is null"), Objects.requireNonNull(inputFormat, "inputFormat is null"), Objects.requireNonNull(outputFormat, "outputFormat is null"));
    }

    @JsonCreator
    public static StorageFormat createNullable(@JsonProperty(value="serDe") String serDe, @JsonProperty(value="inputFormat") String inputFormat, @JsonProperty(value="outputFormat") String outputFormat) {
        return new StorageFormat(serDe, inputFormat, outputFormat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageFormat that = (StorageFormat)o;
        return Objects.equals(this.serDe, that.serDe) && Objects.equals(this.inputFormat, that.inputFormat) && Objects.equals(this.outputFormat, that.outputFormat);
    }

    public int hashCode() {
        return Objects.hash(this.serDe, this.inputFormat, this.outputFormat);
    }
}

