/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore;

import com.facebook.presto.hive.HiveCluster;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveViewNotSupportedException;
import com.facebook.presto.hive.PartitionNotFoundException;
import com.facebook.presto.hive.RetryDriver;
import com.facebook.presto.hive.SchemaAlreadyExistsException;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.HiveMetastore;
import com.facebook.presto.hive.metastore.HiveMetastoreClient;
import com.facebook.presto.hive.metastore.HivePrincipal;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.ThriftHiveMetastoreStats;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.thrift.TException;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ThriftHiveMetastore
implements HiveMetastore {
    private final ThriftHiveMetastoreStats stats;
    private final HiveCluster clientProvider;
    private final Function<Exception, Exception> exceptionMapper;

    @Inject
    public ThriftHiveMetastore(HiveCluster hiveCluster) {
        this(hiveCluster, new ThriftHiveMetastoreStats(), Function.identity());
    }

    ThriftHiveMetastore(HiveCluster hiveCluster, ThriftHiveMetastoreStats stats, Function<Exception, Exception> exceptionMapper) {
        this.clientProvider = Objects.requireNonNull(hiveCluster, "hiveCluster is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.exceptionMapper = Objects.requireNonNull(exceptionMapper, "exceptionMapper is null");
    }

    @Managed
    @Flatten
    public ThriftHiveMetastoreStats getStats() {
        return this.stats;
    }

    @Override
    public List<String> getAllDatabases() {
        try {
            return this.retry().stopOnIllegalExceptions().run("getAllDatabases", this.stats.getGetAllDatabases().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List<String> list = client.getAllDatabases();
                    return list;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getDatabase", this.stats.getGetDatabase().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<Database> optional = Optional.of(client.getDatabase(databaseName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getAllTables(String databaseName) {
        Callable<List> getAllTables = this.stats.getGetAllTables().wrap(() -> {
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                List<String> list = client.getAllTables(databaseName);
                return list;
            }
        });
        Callable<Void> getDatabase = this.stats.getGetDatabase().wrap(() -> {
            try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                client.getDatabase(databaseName);
                Void void_ = null;
                return void_;
            }
        });
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getAllTables", () -> {
                List tables = (List)getAllTables.call();
                if (tables.isEmpty()) {
                    getDatabase.call();
                }
                return Optional.of(tables);
            });
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTable", this.stats.getGetTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Table table = client.getTable(databaseName, tableName);
                    if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name()) && !this.isPrestoView(table)) {
                        throw new HiveViewNotSupportedException(new SchemaTableName(databaseName, tableName));
                    }
                    Optional<Table> optional = Optional.of(table);
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<Set<ColumnStatisticsObj>> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getTableColumnStatistics", this.stats.getGetTableColumnStatistics().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<ImmutableSet> optional = Optional.of(ImmutableSet.copyOf(client.getTableColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)columnNames))));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<Map<String, Set<ColumnStatisticsObj>>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionValues, Set<String> columnNames) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class, HiveViewNotSupportedException.class).stopOnIllegalExceptions().run("getPartitionColumnStatistics", this.stats.getGetPartitionColumnStatistics().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Map<String, List<ColumnStatisticsObj>> partitionColumnStatistics = client.getPartitionColumnStatistics(databaseName, tableName, (List<String>)ImmutableList.copyOf((Collection)columnNames), (List<String>)ImmutableList.copyOf((Collection)partitionValues));
                    Optional<Map<String, Set>> optional = Optional.of(partitionColumnStatistics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ImmutableSet.copyOf((Collection)((Collection)entry.getValue())))));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getAllViews(String databaseName) {
        try {
            return this.retry().stopOn(UnknownDBException.class).stopOnIllegalExceptions().run("getAllViews", this.stats.getGetAllViews().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    String filter = "hive_filter_field_params__presto_view = \"true\"";
                    Optional<List<String>> optional = Optional.of(client.getTableNamesByFilter(databaseName, filter));
                    return optional;
                }
            }));
        }
        catch (UnknownDBException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void createDatabase(Database database) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class).stopOnIllegalExceptions().run("createDatabase", this.stats.getCreateDatabase().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.createDatabase(database);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(database.getName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void dropDatabase(String databaseName) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, InvalidOperationException.class).stopOnIllegalExceptions().run("dropDatabase", this.stats.getDropDatabase().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.dropDatabase(databaseName, false, false);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void alterDatabase(String databaseName, Database database) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterDatabase", this.stats.getAlterDatabase().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.alterDatabase(databaseName, database);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(databaseName);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void createTable(Table table) {
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class).stopOnIllegalExceptions().run("createTable", this.stats.getCreateTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.createTable(table);
                }
                return null;
            }));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDbName(), table.getTableName()));
        }
        catch (NoSuchObjectException e) {
            throw new SchemaNotFoundException(table.getDbName());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("dropTable", this.stats.getDropTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.dropTable(databaseName, tableName, deleteData);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void alterTable(String databaseName, String tableName, Table table) {
        try {
            this.retry().stopOn(InvalidOperationException.class, MetaException.class).stopOnIllegalExceptions().run("alterTable", this.stats.getAlterTable().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<Table> source = this.getTable(databaseName, tableName);
                    if (!source.isPresent()) {
                        throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
                    }
                    client.alterTable(databaseName, tableName, table);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private boolean isPrestoView(Table table) {
        return "true".equals(table.getParameters().get("presto_view"));
    }

    @Override
    public Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNames", this.stats.getGetPartitionNames().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNames(databaseName, tableName));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionNamesByParts", this.stats.getGetPartitionNamesPs().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<List<String>> optional = Optional.of(client.getPartitionNamesFiltered(databaseName, tableName, parts));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void addPartitions(String databaseName, String tableName, List<Partition> partitions) {
        if (partitions.isEmpty()) {
            return;
        }
        try {
            this.retry().stopOn(AlreadyExistsException.class, InvalidObjectException.class, MetaException.class, NoSuchObjectException.class, PrestoException.class).stopOnIllegalExceptions().run("addPartitions", this.stats.getAddPartitions().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    int partitionsAdded = client.addPartitions(partitions);
                    if (partitionsAdded != partitions.size()) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, String.format("Hive metastore only added %s of %s partitions", partitionsAdded, partitions.size()));
                    }
                    Object var5_6 = null;
                    return var5_6;
                }
            }));
        }
        catch (AlreadyExistsException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("One or more partitions already exist for table '%s.%s'", databaseName, tableName), (Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("dropPartition", this.stats.getDropPartition().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.dropPartition(databaseName, tableName, parts, deleteData);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), parts);
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void alterPartition(String databaseName, String tableName, Partition partition) {
        try {
            this.retry().stopOn(NoSuchObjectException.class, MetaException.class).stopOnIllegalExceptions().run("alterPartition", this.stats.getAlterPartition().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    client.alterPartition(databaseName, tableName, partition);
                }
                return null;
            }));
        }
        catch (NoSuchObjectException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partition.getValues());
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartition", this.stats.getGetPartition().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    Optional<Partition> optional = Optional.of(client.getPartition(databaseName, tableName, partitionValues));
                    return optional;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return Optional.empty();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        Preconditions.checkArgument((!Iterables.isEmpty(partitionNames) ? 1 : 0) != 0, (Object)"partitionNames is empty");
        try {
            return this.retry().stopOn(NoSuchObjectException.class).stopOnIllegalExceptions().run("getPartitionsByNames", this.stats.getGetPartitionsByNames().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List<Partition> list = client.getPartitionsByNames(databaseName, tableName, partitionNames);
                    return list;
                }
            }));
        }
        catch (NoSuchObjectException e) {
            return ImmutableList.of();
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Set<String> getRoles(String user) {
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("listRoles", this.stats.getLoadRoles().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    List<Role> roles = client.listRoles(user, PrincipalType.USER);
                    if (roles == null) {
                        ImmutableSet immutableSet = ImmutableSet.of();
                        return immutableSet;
                    }
                    ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)roles.stream().map(Role::getRoleName).collect(Collectors.toSet()));
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public Set<HivePrivilegeInfo> getDatabasePrivileges(String user, String databaseName) {
        ImmutableSet.Builder privileges = ImmutableSet.builder();
        if (this.isDatabaseOwner(user, databaseName)) {
            privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true));
        }
        privileges.addAll(this.getUserPrivileges(new HivePrincipal(user, PrincipalType.USER), new HiveObjectRef(HiveObjectType.DATABASE, databaseName, null, null, null)));
        return privileges.build();
    }

    @Override
    public Set<HivePrivilegeInfo> getTablePrivileges(String user, String databaseName, String tableName) {
        ImmutableSet.Builder privileges = ImmutableSet.builder();
        if (this.isTableOwner(user, databaseName, tableName)) {
            privileges.add((Object)new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true));
        }
        privileges.addAll(this.getUserPrivileges(new HivePrincipal(user, PrincipalType.USER), new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null)));
        return privileges.build();
    }

    @Override
    public void grantTablePrivileges(String databaseName, String tableName, String grantee, Set<PrivilegeGrantInfo> requestedPrivileges) {
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("grantTablePrivileges", this.stats.getGrantTablePrivileges().wrap(() -> {
                try (HiveMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    HivePrincipal hivePrincipal = HivePrincipal.toHivePrincipal(grantee);
                    Set<HivePrivilegeInfo> existingPrivileges = this.getTablePrivileges(hivePrincipal, databaseName, tableName);
                    HashSet privilegesToGrant = Sets.newHashSet((Iterable)requestedPrivileges);
                    Iterator iterator = privilegesToGrant.iterator();
                    while (iterator.hasNext()) {
                        HivePrivilegeInfo requestedPrivilege = (HivePrivilegeInfo)Iterables.getOnlyElement(HivePrivilegeInfo.parsePrivilege((PrivilegeGrantInfo)iterator.next()));
                        for (HivePrivilegeInfo existingPrivilege : existingPrivileges) {
                            if (requestedPrivilege.isContainedIn(existingPrivilege)) {
                                iterator.remove();
                                continue;
                            }
                            if (!existingPrivilege.isContainedIn(requestedPrivilege)) continue;
                            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Granting %s WITH GRANT OPTION is not supported while %s possesses %s", requestedPrivilege.getHivePrivilege().name(), grantee, requestedPrivilege.getHivePrivilege().name()));
                        }
                    }
                    if (privilegesToGrant.isEmpty()) {
                        Object var10_12 = null;
                        return var10_12;
                    }
                    metastoreClient.grantPrivileges(this.buildPrivilegeBag(databaseName, tableName, hivePrincipal, privilegesToGrant));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Override
    public void revokeTablePrivileges(String databaseName, String tableName, String grantee, Set<PrivilegeGrantInfo> requestedPrivileges) {
        Preconditions.checkArgument((!this.containsAllPrivilege(requestedPrivileges) ? 1 : 0) != 0, (Object)"\"ALL\" not supported in PrivilegeGrantInfo.privilege");
        try {
            this.retry().stopOnIllegalExceptions().run("revokeTablePrivileges", this.stats.getRevokeTablePrivileges().wrap(() -> {
                try (HiveMetastoreClient metastoreClient = this.clientProvider.createMetastoreClient();){
                    HivePrincipal hivePrincipal = HivePrincipal.toHivePrincipal(grantee);
                    Set existingHivePrivileges = this.getTablePrivileges(hivePrincipal, databaseName, tableName).stream().map(HivePrivilegeInfo::getHivePrivilege).collect(Collectors.toSet());
                    Set<PrivilegeGrantInfo> privilegesToRevoke = requestedPrivileges.stream().filter(privilegeGrantInfo -> existingHivePrivileges.contains((Object)((HivePrivilegeInfo)Iterables.getOnlyElement(HivePrivilegeInfo.parsePrivilege(privilegeGrantInfo))).getHivePrivilege())).collect(Collectors.toSet());
                    if (privilegesToRevoke.isEmpty()) {
                        Object var10_12 = null;
                        return var10_12;
                    }
                    metastoreClient.revokePrivileges(this.buildPrivilegeBag(databaseName, tableName, hivePrincipal, privilegesToRevoke));
                }
                return null;
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw Throwables.propagate((Throwable)e);
        }
    }

    private PrivilegeBag buildPrivilegeBag(String databaseName, String tableName, HivePrincipal hivePrincipal, Set<PrivilegeGrantInfo> privilegeGrantInfos) throws TException {
        ImmutableList.Builder privilegeBagBuilder = ImmutableList.builder();
        for (PrivilegeGrantInfo privilegeGrantInfo : privilegeGrantInfos) {
            privilegeBagBuilder.add((Object)new HiveObjectPrivilege(new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null), hivePrincipal.getPrincipalName(), hivePrincipal.getPrincipalType(), privilegeGrantInfo));
        }
        return new PrivilegeBag((List)privilegeBagBuilder.build());
    }

    private boolean containsAllPrivilege(Set<PrivilegeGrantInfo> requestedPrivileges) {
        return requestedPrivileges.stream().anyMatch(privilege -> privilege.getPrivilege().equalsIgnoreCase("all"));
    }

    private Set<HivePrivilegeInfo> getTablePrivileges(HivePrincipal hivePrincipal, String databaseName, String tableName) {
        if (hivePrincipal.getPrincipalType() == PrincipalType.ROLE) {
            return this.getRolePrivileges(hivePrincipal, new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
        }
        return this.getUserPrivileges(hivePrincipal, new HiveObjectRef(HiveObjectType.TABLE, databaseName, tableName, null, null));
    }

    private Set<HivePrivilegeInfo> getRolePrivileges(HivePrincipal hivePrincipal, HiveObjectRef hiveObjectRef) {
        Preconditions.checkArgument((hivePrincipal.getPrincipalType() == PrincipalType.ROLE ? 1 : 0) != 0, (Object)"Expected ROLE PrincipalType but found USER");
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("getListPrivileges", this.stats.getListPrivileges().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    ImmutableSet.Builder privileges = ImmutableSet.builder();
                    List<HiveObjectPrivilege> hiveObjectPrivilegeList = client.listPrivileges(hivePrincipal.getPrincipalName(), hivePrincipal.getPrincipalType(), hiveObjectRef);
                    for (HiveObjectPrivilege hiveObjectPrivilege : hiveObjectPrivilegeList) {
                        privileges.addAll(HivePrivilegeInfo.parsePrivilege(hiveObjectPrivilege.getGrantInfo()));
                    }
                    ImmutableSet immutableSet = privileges.build();
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw this.propagate(e);
        }
    }

    private Set<HivePrivilegeInfo> getUserPrivileges(HivePrincipal hivePrincipal, HiveObjectRef objectReference) {
        Preconditions.checkArgument((hivePrincipal.getPrincipalType() == PrincipalType.USER ? 1 : 0) != 0, (Object)"Expected USER PrincipalType but found ROLE");
        try {
            return (Set)this.retry().stopOnIllegalExceptions().run("getPrivilegeSet", this.stats.getGetPrivilegeSet().wrap(() -> {
                try (HiveMetastoreClient client = this.clientProvider.createMetastoreClient();){
                    ImmutableSet.Builder privileges = ImmutableSet.builder();
                    String principalName = hivePrincipal.getPrincipalName();
                    PrincipalPrivilegeSet privilegeSet = client.getPrivilegeSet(objectReference, principalName, null);
                    if (privilegeSet != null) {
                        Map rolePrivilegesMap;
                        Map userPrivileges = privilegeSet.getUserPrivileges();
                        if (userPrivileges != null) {
                            privileges.addAll(MetastoreUtil.toGrants((List)userPrivileges.get(principalName)));
                        }
                        if ((rolePrivilegesMap = privilegeSet.getRolePrivileges()) != null) {
                            for (List rolePrivileges : rolePrivilegesMap.values()) {
                                privileges.addAll(MetastoreUtil.toGrants(rolePrivileges));
                            }
                        }
                    }
                    ImmutableSet immutableSet = privileges.build();
                    return immutableSet;
                }
            }));
        }
        catch (TException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            throw this.propagate(e);
        }
    }

    private RetryDriver retry() {
        return RetryDriver.retry().exceptionMapper(this.exceptionMapper).stopOn(PrestoException.class);
    }

    private RuntimeException propagate(Throwable throwable) {
        if (throwable instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        throw Throwables.propagate((Throwable)throwable);
    }
}

