/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.metastore.file;

import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.SchemaAlreadyExistsException;
import com.facebook.presto.hive.TableAlreadyExistsException;
import com.facebook.presto.hive.metastore.Column;
import com.facebook.presto.hive.metastore.Database;
import com.facebook.presto.hive.metastore.ExtendedHiveMetastore;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.HivePrivilegeInfo;
import com.facebook.presto.hive.metastore.MetastoreUtil;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.PrincipalPrivileges;
import com.facebook.presto.hive.metastore.PrincipalType;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.metastore.file.DatabaseMetadata;
import com.facebook.presto.hive.metastore.file.FileHiveMetastoreConfig;
import com.facebook.presto.hive.metastore.file.PartitionMetadata;
import com.facebook.presto.hive.metastore.file.PermissionMetadata;
import com.facebook.presto.hive.metastore.file.TableMetadata;
import com.facebook.presto.spi.ColumnNotFoundException;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaNotFoundException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableNotFoundException;
import com.facebook.presto.spi.security.Identity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteStreams;
import io.airlift.json.JsonCodec;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;

@ThreadSafe
public class FileHiveMetastore
implements ExtendedHiveMetastore {
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String PRESTO_SCHEMA_FILE_NAME = ".prestoSchema";
    private static final String PRESTO_PERMISSIONS_DIRECTORY_NAME = ".prestoPermissions";
    private final HdfsEnvironment hdfsEnvironment;
    private final Path catalogDirectory;
    private final HdfsEnvironment.HdfsContext hdfsContext;
    private final FileSystem metadataFileSystem;
    private final JsonCodec<DatabaseMetadata> databaseCodec = JsonCodec.jsonCodec(DatabaseMetadata.class);
    private final JsonCodec<TableMetadata> tableCodec = JsonCodec.jsonCodec(TableMetadata.class);
    private final JsonCodec<PartitionMetadata> partitionCodec = JsonCodec.jsonCodec(PartitionMetadata.class);
    private final JsonCodec<List<PermissionMetadata>> permissionsCodec = JsonCodec.listJsonCodec(PermissionMetadata.class);

    @Inject
    public FileHiveMetastore(HdfsEnvironment hdfsEnvironment, FileHiveMetastoreConfig config) {
        this(hdfsEnvironment, config.getCatalogDirectory(), config.getMetastoreUser());
    }

    public FileHiveMetastore(HdfsEnvironment hdfsEnvironment, String catalogDirectory, String metastoreUser) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.catalogDirectory = new Path(Objects.requireNonNull(catalogDirectory, "baseDirectory is null"));
        this.hdfsContext = new HdfsEnvironment.HdfsContext(new Identity(metastoreUser, Optional.empty()));
        try {
            this.metadataFileSystem = hdfsEnvironment.getFileSystem(this.hdfsContext, this.catalogDirectory);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public synchronized void createDatabase(Database database) {
        Objects.requireNonNull(database, "database is null");
        if (database.getLocation().isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Database can not be created with a location set");
        }
        this.verifyDatabaseNotExists(database.getDatabaseName());
        Path databaseMetadataDirectory = this.getDatabaseMetadataDirectory(database.getDatabaseName());
        this.writeSchemaFile("database", databaseMetadataDirectory, this.databaseCodec, new DatabaseMetadata(database), false);
    }

    @Override
    public synchronized void dropDatabase(String databaseName) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        this.getRequiredDatabase(databaseName);
        if (!this.getAllTables(databaseName).orElse((List<String>)ImmutableList.of()).isEmpty()) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Database " + databaseName + " is not empty");
        }
        this.deleteMetadataDirectory(this.getDatabaseMetadataDirectory(databaseName));
    }

    @Override
    public synchronized void renameDatabase(String databaseName, String newDatabaseName) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(newDatabaseName, "newDatabaseName is null");
        this.getRequiredDatabase(databaseName);
        this.verifyDatabaseNotExists(newDatabaseName);
        try {
            if (!this.metadataFileSystem.rename(this.getDatabaseMetadataDirectory(databaseName), this.getDatabaseMetadataDirectory(newDatabaseName))) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not rename database metadata directory");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public synchronized Optional<Database> getDatabase(String databaseName) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Path databaseMetadataDirectory = this.getDatabaseMetadataDirectory(databaseName);
        return this.readSchemaFile("database", databaseMetadataDirectory, this.databaseCodec).map(databaseMetadata -> databaseMetadata.toDatabase(databaseName, databaseMetadataDirectory.toString()));
    }

    private Database getRequiredDatabase(String databaseName) {
        return this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
    }

    private void verifyDatabaseNotExists(String databaseName) {
        if (this.getDatabase(databaseName).isPresent()) {
            throw new SchemaAlreadyExistsException(databaseName);
        }
    }

    @Override
    public synchronized List<String> getAllDatabases() {
        List databases = this.getChildSchemaDirectories(this.catalogDirectory).stream().map(Path::getName).collect(Collectors.toList());
        return ImmutableList.copyOf(databases);
    }

    @Override
    public synchronized void createTable(Table table, PrincipalPrivileges principalPrivileges) {
        Path tableMetadataDirectory;
        block12: {
            this.verifyTableNotExists(table.getDatabaseName(), table.getTableName());
            tableMetadataDirectory = this.getTableMetadataDirectory(table);
            if (table.getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
                Preconditions.checkArgument((boolean)table.getStorage().getLocation().isEmpty(), (Object)"Storage location for view must be empty");
            } else if (table.getTableType().equals(TableType.MANAGED_TABLE.name())) {
                if (!tableMetadataDirectory.equals((Object)new Path(table.getStorage().getLocation()))) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Table directory must be " + tableMetadataDirectory);
                }
            } else {
                if (table.getTableType().equals(TableType.EXTERNAL_TABLE.name())) {
                    try {
                        Path externalLocation = new Path(table.getStorage().getLocation());
                        FileSystem externalFileSystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, externalLocation);
                        if (!externalFileSystem.isDirectory(externalLocation)) {
                            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "External table location does not exist");
                        }
                        if (FileHiveMetastore.isChildDirectory(this.catalogDirectory, externalLocation)) {
                            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "External table location can not be inside the system metadata directory");
                        }
                        break block12;
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not validate external location", (Throwable)e);
                    }
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table type not supported: " + table.getTableType());
            }
        }
        this.writeSchemaFile("table", tableMetadataDirectory, this.tableCodec, new TableMetadata(table), false);
        for (Map.Entry entry : principalPrivileges.getUserPrivileges().asMap().entrySet()) {
            this.setTablePrivileges((String)entry.getKey(), PrincipalType.USER, table.getDatabaseName(), table.getTableName(), (Collection)entry.getValue());
        }
        for (Map.Entry entry : principalPrivileges.getRolePrivileges().asMap().entrySet()) {
            this.setTablePrivileges((String)entry.getKey(), PrincipalType.ROLE, table.getDatabaseName(), table.getTableName(), (Collection)entry.getValue());
        }
    }

    @Override
    public synchronized Optional<Table> getTable(String databaseName, String tableName) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Path tableMetadataDirectory = this.getTableMetadataDirectory(databaseName, tableName);
        return this.readSchemaFile("table", tableMetadataDirectory, this.tableCodec).map(tableMetadata -> tableMetadata.toTable(databaseName, tableName, tableMetadataDirectory.toString()));
    }

    @Override
    public Optional<Map<String, HiveColumnStatistics>> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        return Optional.of(ImmutableMap.of());
    }

    @Override
    public Optional<Map<String, Map<String, HiveColumnStatistics>>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        return Optional.of(ImmutableMap.of());
    }

    private Table getRequiredTable(String databaseName, String tableName) {
        return this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
    }

    private void verifyTableNotExists(String newDatabaseName, String newTableName) {
        if (this.getTable(newDatabaseName, newTableName).isPresent()) {
            throw new TableAlreadyExistsException(new SchemaTableName(newDatabaseName, newTableName));
        }
    }

    @Override
    public synchronized Optional<List<String>> getAllTables(String databaseName) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Optional<Database> database = this.getDatabase(databaseName);
        if (!database.isPresent()) {
            return Optional.empty();
        }
        Path databaseMetadataDirectory = this.getDatabaseMetadataDirectory(databaseName);
        List tables = this.getChildSchemaDirectories(databaseMetadataDirectory).stream().map(Path::getName).collect(Collectors.toList());
        return Optional.of(ImmutableList.copyOf(tables));
    }

    @Override
    public synchronized Optional<List<String>> getAllViews(String databaseName) {
        Optional<List<String>> tables = this.getAllTables(databaseName);
        if (!tables.isPresent()) {
            return Optional.empty();
        }
        List views = tables.get().stream().map(tableName -> this.getTable(databaseName, (String)tableName)).filter(Optional::isPresent).map(Optional::get).filter(table -> table.getTableType().equals(TableType.VIRTUAL_VIEW.name())).map(Table::getTableName).collect(Collectors.toList());
        return Optional.of(ImmutableList.copyOf(views));
    }

    @Override
    public synchronized void dropTable(String databaseName, String tableName, boolean deleteData) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Table table = this.getRequiredTable(databaseName, tableName);
        Path tableMetadataDirectory = this.getTableMetadataDirectory(databaseName, tableName);
        if (!table.getTableType().equals(TableType.MANAGED_TABLE.name()) || deleteData) {
            this.deleteMetadataDirectory(tableMetadataDirectory);
        } else {
            this.deleteSchemaFile("table", tableMetadataDirectory);
            this.deleteTablePrivileges(table);
        }
    }

    @Override
    public synchronized void replaceTable(String databaseName, String tableName, Table newTable, PrincipalPrivileges principalPrivileges) {
        Table table = this.getRequiredTable(databaseName, tableName);
        if (!table.getTableType().equals(TableType.VIRTUAL_VIEW.name()) || !newTable.getTableType().equals(TableType.VIRTUAL_VIEW.name())) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Only views can be updated with replaceTable");
        }
        if (!table.getDatabaseName().equals(databaseName) || !table.getTableName().equals(tableName)) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Replacement table must have same name");
        }
        Path tableMetadataDirectory = this.getTableMetadataDirectory(table);
        this.writeSchemaFile("table", tableMetadataDirectory, this.tableCodec, new TableMetadata(newTable), true);
        this.deleteTablePrivileges(table);
        for (Map.Entry entry : principalPrivileges.getUserPrivileges().asMap().entrySet()) {
            this.setTablePrivileges((String)entry.getKey(), PrincipalType.USER, table.getDatabaseName(), table.getTableName(), (Collection)entry.getValue());
        }
        for (Map.Entry entry : principalPrivileges.getRolePrivileges().asMap().entrySet()) {
            this.setTablePrivileges((String)entry.getKey(), PrincipalType.ROLE, table.getDatabaseName(), table.getTableName(), (Collection)entry.getValue());
        }
    }

    @Override
    public synchronized void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(newDatabaseName, "newDatabaseName is null");
        Objects.requireNonNull(newTableName, "newTableName is null");
        this.getRequiredTable(databaseName, tableName);
        this.getRequiredDatabase(newDatabaseName);
        this.verifyTableNotExists(newDatabaseName, newTableName);
        try {
            if (!this.metadataFileSystem.rename(this.getTableMetadataDirectory(databaseName, tableName), this.getTableMetadataDirectory(newDatabaseName, newTableName))) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not rename table directory");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    @Override
    public synchronized void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        this.alterTable(databaseName, tableName, oldTable -> {
            if (oldTable.getColumn(columnName).isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Column already exists: " + columnName);
            }
            return oldTable.withDataColumns((List<Column>)ImmutableList.builder().addAll(oldTable.getDataColumns()).add((Object)new Column(columnName, columnType, Optional.ofNullable(columnComment))).build());
        });
    }

    @Override
    public synchronized void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.alterTable(databaseName, tableName, oldTable -> {
            if (oldTable.getColumn(newColumnName).isPresent()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Column already exists: " + newColumnName);
            }
            if (!oldTable.getColumn(oldColumnName).isPresent()) {
                SchemaTableName name = new SchemaTableName(databaseName, tableName);
                throw new ColumnNotFoundException(name, oldColumnName);
            }
            for (Column column : oldTable.getPartitionColumns()) {
                if (!column.getName().equals(oldColumnName)) continue;
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
            }
            ImmutableList.Builder newDataColumns = ImmutableList.builder();
            for (Column fieldSchema : oldTable.getDataColumns()) {
                if (fieldSchema.getName().equals(oldColumnName)) {
                    newDataColumns.add((Object)new Column(newColumnName, fieldSchema.getType(), fieldSchema.getComment()));
                    continue;
                }
                newDataColumns.add((Object)fieldSchema);
            }
            return oldTable.withDataColumns((List<Column>)newDataColumns.build());
        });
    }

    @Override
    public synchronized void dropColumn(String databaseName, String tableName, String columnName) {
        this.alterTable(databaseName, tableName, oldTable -> {
            MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
            if (!oldTable.getColumn(columnName).isPresent()) {
                SchemaTableName name = new SchemaTableName(databaseName, tableName);
                throw new ColumnNotFoundException(name, columnName);
            }
            ImmutableList.Builder newDataColumns = ImmutableList.builder();
            for (Column fieldSchema : oldTable.getDataColumns()) {
                if (fieldSchema.getName().equals(columnName)) continue;
                newDataColumns.add((Object)fieldSchema);
            }
            return oldTable.withDataColumns((List<Column>)newDataColumns.build());
        });
    }

    private void alterTable(String databaseName, String tableName, Function<TableMetadata, TableMetadata> alterFunction) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Path tableMetadataDirectory = this.getTableMetadataDirectory(databaseName, tableName);
        TableMetadata oldTableSchema = this.readSchemaFile("table", tableMetadataDirectory, this.tableCodec).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        TableMetadata newTableSchema = alterFunction.apply(oldTableSchema);
        if (oldTableSchema == newTableSchema) {
            return;
        }
        this.writeSchemaFile("table", tableMetadataDirectory, this.tableCodec, newTableSchema, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void addPartitions(String databaseName, String tableName, List<Partition> partitions) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitions, "partitions is null");
        Table table = this.getRequiredTable(databaseName, tableName);
        TableType tableType = TableType.valueOf((String)table.getTableType());
        Preconditions.checkArgument((boolean)EnumSet.of(TableType.MANAGED_TABLE, TableType.EXTERNAL_TABLE).contains(tableType), (String)"Invalid table type: %s", (Object)tableType);
        try {
            LinkedHashMap<Path, byte[]> schemaFiles = new LinkedHashMap<Path, byte[]>();
            for (Partition partition : partitions) {
                this.verifiedPartition(table, partition);
                Path path = this.getPartitionMetadataDirectory(table, partition.getValues());
                Path schemaPath = new Path(path, PRESTO_SCHEMA_FILE_NAME);
                if (this.metadataFileSystem.exists(schemaPath)) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Partition already exists");
                }
                byte[] schemaJson = this.partitionCodec.toJsonBytes((Object)new PartitionMetadata(table, partition));
                schemaFiles.put(schemaPath, schemaJson);
            }
            LinkedHashSet createdFiles = new LinkedHashSet();
            try {
                for (Map.Entry entry : schemaFiles.entrySet()) {
                    try {
                        FSDataOutputStream outputStream = this.metadataFileSystem.create((Path)entry.getKey());
                        Throwable throwable = null;
                        try {
                            createdFiles.add(entry.getKey());
                            outputStream.write((byte[])entry.getValue());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (outputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not write partition schema", (Throwable)e);
                        return;
                    }
                }
            }
            catch (Throwable throwable) {
                for (Path createdFile : createdFiles) {
                    try {
                        this.metadataFileSystem.delete(createdFile, false);
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private void verifiedPartition(Table table, Partition partition) {
        block8: {
            Path partitionMetadataDirectory = this.getPartitionMetadataDirectory(table, partition.getValues());
            if (table.getTableType().equals(TableType.MANAGED_TABLE.name())) {
                if (!partitionMetadataDirectory.equals((Object)new Path(partition.getStorage().getLocation()))) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Partition directory must be " + partitionMetadataDirectory);
                }
            } else {
                if (table.getTableType().equals(TableType.EXTERNAL_TABLE.name())) {
                    try {
                        Path externalLocation = new Path(partition.getStorage().getLocation());
                        FileSystem externalFileSystem = this.hdfsEnvironment.getFileSystem(this.hdfsContext, externalLocation);
                        if (!externalFileSystem.isDirectory(externalLocation)) {
                            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "External partition location does not exist");
                        }
                        if (FileHiveMetastore.isChildDirectory(this.catalogDirectory, externalLocation)) {
                            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "External partition location can not be inside the system metadata directory");
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not validate external partition location", (Throwable)e);
                    }
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Partitions can not be added to " + table.getTableType());
            }
        }
    }

    @Override
    public synchronized void dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        Optional<Table> tableReference = this.getTable(databaseName, tableName);
        if (!tableReference.isPresent()) {
            return;
        }
        Table table = tableReference.get();
        Path partitionMetadataDirectory = this.getPartitionMetadataDirectory(table, partitionValues);
        if (deleteData) {
            this.deleteMetadataDirectory(partitionMetadataDirectory);
        } else {
            this.deleteSchemaFile("partition", partitionMetadataDirectory);
        }
    }

    @Override
    public synchronized void alterPartition(String databaseName, String tableName, Partition partition) {
        Table table = this.getRequiredTable(databaseName, tableName);
        this.verifiedPartition(table, partition);
        Path partitionMetadataDirectory = this.getPartitionMetadataDirectory(table, partition.getValues());
        this.writeSchemaFile("partition", partitionMetadataDirectory, this.partitionCodec, new PartitionMetadata(table, partition), true);
    }

    @Override
    public synchronized Optional<List<String>> getPartitionNames(String databaseName, String tableName) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<Table> tableReference = this.getTable(databaseName, tableName);
        if (!tableReference.isPresent()) {
            return Optional.empty();
        }
        Table table = tableReference.get();
        Path tableMetadataDirectory = this.getTableMetadataDirectory(table);
        List<ArrayDeque<String>> partitions = this.listPartitions(tableMetadataDirectory, table.getPartitionColumns());
        List partitionNames = partitions.stream().map(partitionValues -> MetastoreUtil.makePartName(table.getPartitionColumns(), (List<String>)ImmutableList.copyOf((Collection)partitionValues))).collect(Collectors.toList());
        return Optional.of(ImmutableList.copyOf(partitionNames));
    }

    private List<ArrayDeque<String>> listPartitions(Path director, List<Column> partitionColumns) {
        if (partitionColumns.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            String directoryPrefix = partitionColumns.get(0).getName() + '=';
            ArrayList<ArrayDeque<String>> partitionValues = new ArrayList<ArrayDeque<String>>();
            for (FileStatus fileStatus : this.metadataFileSystem.listStatus(director)) {
                if (!fileStatus.isDirectory() || !fileStatus.getPath().getName().startsWith(directoryPrefix)) continue;
                Object childPartitionValues = partitionColumns.size() == 1 ? ImmutableList.of(new ArrayDeque()) : this.listPartitions(fileStatus.getPath(), partitionColumns.subList(1, partitionColumns.size()));
                String value = fileStatus.getPath().getName().substring(directoryPrefix.length());
                Iterator iterator = childPartitionValues.iterator();
                while (iterator.hasNext()) {
                    ArrayDeque childPartition = (ArrayDeque)iterator.next();
                    childPartition.addFirst(value);
                    partitionValues.add(childPartition);
                }
            }
            return partitionValues;
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Error listing partition directories", (Throwable)e);
        }
    }

    @Override
    public synchronized Optional<Partition> getPartition(String databaseName, String tableName, List<String> partitionValues) {
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(partitionValues, "partitionValues is null");
        Optional<Table> tableReference = this.getTable(databaseName, tableName);
        if (!tableReference.isPresent()) {
            return Optional.empty();
        }
        Table table = tableReference.get();
        Path partitionDirectory = this.getPartitionMetadataDirectory(table, partitionValues);
        return this.readSchemaFile("partition", partitionDirectory, this.partitionCodec).map(partitionMetadata -> partitionMetadata.toPartition(databaseName, tableName, partitionValues, partitionDirectory.toString()));
    }

    @Override
    public synchronized Optional<List<String>> getPartitionNamesByParts(String databaseName, String tableName, List<String> parts) {
        return this.getPartitionNames(databaseName, tableName).map(partitionNames -> partitionNames.stream().filter(partitionName -> FileHiveMetastore.partitionMatches(partitionName, parts)).collect(Collectors.toList()));
    }

    private static boolean partitionMatches(String partitionName, List<String> parts) {
        List<String> values = HiveUtil.toPartitionValues(partitionName);
        if (values.size() != parts.size()) {
            return false;
        }
        for (int i = 0; i < values.size(); ++i) {
            String part = parts.get(i);
            if (part.isEmpty() || values.get(i).equals(part)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized Map<String, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String partitionName : partitionNames) {
            List<String> partitionValues = HiveUtil.toPartitionValues(partitionName);
            builder.put((Object)partitionName, this.getPartition(databaseName, tableName, partitionValues));
        }
        return builder.build();
    }

    @Override
    public synchronized Set<String> getRoles(String user) {
        return ImmutableSet.builder().add((Object)PUBLIC_ROLE_NAME).add((Object)"admin").build();
    }

    @Override
    public synchronized Set<HivePrivilegeInfo> getDatabasePrivileges(String user, String databaseName) {
        HashSet<HivePrivilegeInfo> privileges = new HashSet<HivePrivilegeInfo>();
        if (this.isDatabaseOwner(user, databaseName)) {
            privileges.add(new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true));
        }
        return privileges;
    }

    @Override
    public synchronized Set<HivePrivilegeInfo> getTablePrivileges(String user, String databaseName, String tableName) {
        Table table = this.getRequiredTable(databaseName, tableName);
        HashSet<HivePrivilegeInfo> privileges = new HashSet<HivePrivilegeInfo>();
        if (user.equals(table.getOwner())) {
            privileges.add(new HivePrivilegeInfo(HivePrivilegeInfo.HivePrivilege.OWNERSHIP, true));
        }
        Path permissionsDirectory = this.getPermissionsDirectory(table);
        privileges.addAll(this.getTablePrivileges(permissionsDirectory, user, PrincipalType.USER));
        for (String role : this.getRoles(user)) {
            privileges.addAll(this.getTablePrivileges(permissionsDirectory, role, PrincipalType.ROLE));
        }
        return privileges;
    }

    private synchronized Collection<HivePrivilegeInfo> getTablePrivileges(Path permissionsDirectory, String principalName, PrincipalType principalType) {
        Path permissionFilePath = FileHiveMetastore.getPermissionsPath(permissionsDirectory, principalName, principalType);
        return this.readFile("permissions", permissionFilePath, this.permissionsCodec).orElse((List<PermissionMetadata>)ImmutableList.of()).stream().map(PermissionMetadata::toHivePrivilegeInfo).collect(Collectors.toList());
    }

    @Override
    public synchronized void grantTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        this.setTablePrivileges(grantee, PrincipalType.USER, databaseName, tableName, privileges);
    }

    @Override
    public synchronized void revokeTablePrivileges(String databaseName, String tableName, String grantee, Set<HivePrivilegeInfo> privileges) {
        Set<HivePrivilegeInfo> currentPrivileges = this.getTablePrivileges(grantee, databaseName, tableName);
        currentPrivileges.removeAll(privileges);
        this.setTablePrivileges(grantee, PrincipalType.USER, databaseName, tableName, currentPrivileges);
    }

    private synchronized void setTablePrivileges(String principalName, PrincipalType principalType, String databaseName, String tableName, Collection<HivePrivilegeInfo> privileges) {
        Objects.requireNonNull(principalName, "principalName is null");
        Objects.requireNonNull(principalType, "principalType is null");
        Objects.requireNonNull(databaseName, "databaseName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Objects.requireNonNull(privileges, "privileges is null");
        try {
            Table table = this.getRequiredTable(databaseName, tableName);
            Path permissionsDirectory = this.getPermissionsDirectory(table);
            this.metadataFileSystem.mkdirs(permissionsDirectory);
            if (!this.metadataFileSystem.isDirectory(permissionsDirectory)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not create permissions directory");
            }
            Path permissionFilePath = FileHiveMetastore.getPermissionsPath(permissionsDirectory, principalName, principalType);
            List permissions = privileges.stream().map(PermissionMetadata::new).collect(Collectors.toList());
            this.writeFile("permissions", permissionFilePath, this.permissionsCodec, permissions, true);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private synchronized void deleteTablePrivileges(Table table) {
        try {
            Path permissionsDirectory = this.getPermissionsDirectory(table);
            this.metadataFileSystem.delete(permissionsDirectory, true);
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not delete table permissions", (Throwable)e);
        }
    }

    private boolean isDatabaseOwner(String user, String databaseName) {
        if ("default".equalsIgnoreCase(databaseName)) {
            return true;
        }
        Optional<Database> databaseMetadata = this.getDatabase(databaseName);
        if (!databaseMetadata.isPresent()) {
            return false;
        }
        Database database = databaseMetadata.get();
        if (database.getOwnerType() == PrincipalType.USER && user.equals(database.getOwnerName())) {
            return true;
        }
        return database.getOwnerType() == PrincipalType.ROLE && this.getRoles(user).contains(database.getOwnerName());
    }

    private Path getDatabaseMetadataDirectory(String databaseName) {
        return new Path(this.catalogDirectory, databaseName);
    }

    private Path getTableMetadataDirectory(Table table) {
        return this.getTableMetadataDirectory(table.getDatabaseName(), table.getTableName());
    }

    private Path getTableMetadataDirectory(String databaseName, String tableName) {
        return new Path(this.getDatabaseMetadataDirectory(databaseName), tableName);
    }

    private Path getPartitionMetadataDirectory(Table table, List<String> values) {
        String partitionName = MetastoreUtil.makePartName(table.getPartitionColumns(), values);
        return this.getPartitionMetadataDirectory(table, partitionName);
    }

    private Path getPartitionMetadataDirectory(Table table, String partitionName) {
        Path tableMetadataDirectory = this.getTableMetadataDirectory(table);
        return new Path(tableMetadataDirectory, partitionName);
    }

    private Path getPermissionsDirectory(Table table) {
        return new Path(this.getTableMetadataDirectory(table), PRESTO_PERMISSIONS_DIRECTORY_NAME);
    }

    private static Path getPermissionsPath(Path permissionsDirectory, String principalName, PrincipalType principalType) {
        return new Path(permissionsDirectory, principalType.name().toLowerCase(Locale.US) + "_" + principalName);
    }

    private List<Path> getChildSchemaDirectories(Path metadataDirectory) {
        try {
            if (!this.metadataFileSystem.isDirectory(metadataDirectory)) {
                return ImmutableList.of();
            }
            ImmutableList.Builder childSchemaDirectories = ImmutableList.builder();
            for (FileStatus child : this.metadataFileSystem.listStatus(metadataDirectory)) {
                Path childPath;
                if (!child.isDirectory() || (childPath = child.getPath()).getName().startsWith(".") || !this.metadataFileSystem.isFile(new Path(childPath, PRESTO_SCHEMA_FILE_NAME))) continue;
                childSchemaDirectories.add((Object)childPath);
            }
            return childSchemaDirectories.build();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private void deleteMetadataDirectory(Path metadataDirectory) {
        try {
            Path schemaPath = new Path(metadataDirectory, PRESTO_SCHEMA_FILE_NAME);
            if (!this.metadataFileSystem.isFile(schemaPath)) {
                return;
            }
            if (!this.metadataFileSystem.delete(metadataDirectory, true)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not delete metadata directory");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private <T> Optional<T> readSchemaFile(String type, Path metadataDirectory, JsonCodec<T> codec) {
        Path schemaPath = new Path(metadataDirectory, PRESTO_SCHEMA_FILE_NAME);
        return this.readFile(type + " schema", schemaPath, codec);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> Optional<T> readFile(String type, Path path, JsonCodec<T> codec) {
        try {
            if (!this.metadataFileSystem.isFile(path)) {
                return Optional.empty();
            }
            try (FSDataInputStream inputStream = this.metadataFileSystem.open(path);){
                byte[] json = ByteStreams.toByteArray((InputStream)inputStream);
                Optional<Object> optional = Optional.of(codec.fromJson(json));
                return optional;
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not read " + type, (Throwable)e);
        }
    }

    private <T> void writeSchemaFile(String type, Path directory, JsonCodec<T> codec, T value, boolean overwrite) {
        Path schemaPath = new Path(directory, PRESTO_SCHEMA_FILE_NAME);
        this.writeFile(type + " schema", schemaPath, codec, value, overwrite);
    }

    private <T> void writeFile(String type, Path path, JsonCodec<T> codec, T value, boolean overwrite) {
        try {
            byte[] json = codec.toJsonBytes(value);
            if (!overwrite && this.metadataFileSystem.exists(path)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, type + " file already exists");
            }
            this.metadataFileSystem.mkdirs(path.getParent());
            try (FSDataOutputStream outputStream = this.metadataFileSystem.create(path, overwrite);){
                outputStream.write(json);
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not write " + type, (Throwable)e);
        }
    }

    private void deleteSchemaFile(String type, Path metadataDirectory) {
        try {
            if (!this.metadataFileSystem.delete(new Path(metadataDirectory, PRESTO_SCHEMA_FILE_NAME), false)) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not delete " + type + " schema");
            }
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Could not delete " + type + " schema", (Throwable)e);
        }
    }

    private static boolean isChildDirectory(Path parentDirectory, Path childDirectory) {
        if (parentDirectory.equals((Object)childDirectory)) {
            return true;
        }
        if (childDirectory.isRoot()) {
            return false;
        }
        return FileHiveMetastore.isChildDirectory(parentDirectory, childDirectory.getParent());
    }
}

