/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.predicate;

import com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import com.facebook.presto.hive.parquet.ParquetTypeUtils;
import com.facebook.presto.hive.parquet.RichColumnDescriptor;
import com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import com.facebook.presto.hive.parquet.predicate.ParquetDictionaryDescriptor;
import com.facebook.presto.hive.parquet.predicate.ParquetDoubleStatistics;
import com.facebook.presto.hive.parquet.predicate.ParquetIntegerStatistics;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicate;
import com.facebook.presto.hive.parquet.predicate.ParquetPredicateUtils;
import com.facebook.presto.hive.parquet.predicate.ParquetRangeStatistics;
import com.facebook.presto.hive.parquet.predicate.ParquetStringStatistics;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.predicate.ValueSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import parquet.column.ColumnDescriptor;
import parquet.column.statistics.BinaryStatistics;
import parquet.column.statistics.BooleanStatistics;
import parquet.column.statistics.DoubleStatistics;
import parquet.column.statistics.FloatStatistics;
import parquet.column.statistics.IntStatistics;
import parquet.column.statistics.LongStatistics;
import parquet.column.statistics.Statistics;
import parquet.schema.PrimitiveType;

public class TupleDomainParquetPredicate
implements ParquetPredicate {
    private final TupleDomain<ColumnDescriptor> effectivePredicate;
    private final List<RichColumnDescriptor> columns;

    public TupleDomainParquetPredicate(TupleDomain<ColumnDescriptor> effectivePredicate, List<RichColumnDescriptor> columns) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
    }

    @Override
    public boolean matches(long numberOfRows, Map<ColumnDescriptor, Statistics<?>> statistics) {
        if (numberOfRows == 0L) {
            return false;
        }
        ImmutableMap.Builder domains = ImmutableMap.builder();
        for (RichColumnDescriptor column : this.columns) {
            Statistics<?> columnStatistics = statistics.get((Object)column);
            Type type = ParquetTypeUtils.getPrestoType(column);
            Domain domain = columnStatistics == null || columnStatistics.isEmpty() ? Domain.all((Type)type) : TupleDomainParquetPredicate.getDomain(type, numberOfRows, columnStatistics);
            domains.put((Object)column, (Object)domain);
        }
        TupleDomain stripeDomain = TupleDomain.withColumnDomains((Map)domains.build());
        return this.effectivePredicate.overlaps(stripeDomain);
    }

    @Override
    public boolean matches(Map<ColumnDescriptor, ParquetDictionaryDescriptor> dictionaries) {
        ImmutableMap.Builder domains = ImmutableMap.builder();
        for (RichColumnDescriptor column : this.columns) {
            ParquetDictionaryDescriptor dictionaryDescriptor = dictionaries.get((Object)column);
            Domain domain = TupleDomainParquetPredicate.getDomain(ParquetTypeUtils.getPrestoType(column), dictionaryDescriptor);
            if (domain == null) continue;
            domains.put((Object)column, (Object)domain);
        }
        TupleDomain stripeDomain = TupleDomain.withColumnDomains((Map)domains.build());
        return this.effectivePredicate.overlaps(stripeDomain);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, long rowCount, Statistics<?> statistics) {
        boolean hasNullValue;
        if (statistics == null || statistics.isEmpty()) {
            return Domain.all((Type)type);
        }
        if (statistics.getNumNulls() == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = statistics.getNumNulls() != 0L;
        if (statistics.genericGetMin() == null || statistics.genericGetMax() == null) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        if (type.equals(BooleanType.BOOLEAN) && statistics instanceof BooleanStatistics) {
            boolean hasFalseValues;
            BooleanStatistics booleanStatistics = (BooleanStatistics)statistics;
            boolean hasTrueValues = booleanStatistics.getMax() || booleanStatistics.getMin();
            boolean bl2 = hasFalseValues = !booleanStatistics.getMax() || !booleanStatistics.getMin();
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)type);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
        } else {
            if ((type.equals(BigintType.BIGINT) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER)) && (statistics instanceof LongStatistics || statistics instanceof IntStatistics)) {
                ParquetIntegerStatistics parquetIntegerStatistics;
                if (statistics instanceof LongStatistics) {
                    LongStatistics longStatistics = (LongStatistics)statistics;
                    if (longStatistics.genericGetMin() > longStatistics.genericGetMax()) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    parquetIntegerStatistics = new ParquetIntegerStatistics(longStatistics.genericGetMin(), longStatistics.genericGetMax());
                } else {
                    IntStatistics intStatistics = (IntStatistics)statistics;
                    if (intStatistics.genericGetMin() > intStatistics.genericGetMax()) {
                        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                    }
                    parquetIntegerStatistics = new ParquetIntegerStatistics(Long.valueOf(intStatistics.getMin()), Long.valueOf(intStatistics.getMax()));
                }
                if (ParquetPredicateUtils.isStatisticsOverflow(type, parquetIntegerStatistics)) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetIntegerStatistics);
            }
            if (type.equals(RealType.REAL) && statistics instanceof FloatStatistics) {
                FloatStatistics floatStatistics = (FloatStatistics)statistics;
                if (floatStatistics.genericGetMin().floatValue() > floatStatistics.genericGetMax().floatValue()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ParquetIntegerStatistics parquetStatistics = new ParquetIntegerStatistics(Long.valueOf(Float.floatToRawIntBits(floatStatistics.getMin())), Long.valueOf(Float.floatToRawIntBits(floatStatistics.getMax())));
                return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetStatistics);
            }
            if (type.equals(DoubleType.DOUBLE) && statistics instanceof DoubleStatistics) {
                DoubleStatistics doubleStatistics = (DoubleStatistics)statistics;
                if (doubleStatistics.genericGetMin() > doubleStatistics.genericGetMax()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ParquetDoubleStatistics parquetDoubleStatistics = new ParquetDoubleStatistics(doubleStatistics.genericGetMin(), doubleStatistics.genericGetMax());
                return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetDoubleStatistics);
            }
            if (Varchars.isVarcharType((Type)type) && statistics instanceof BinaryStatistics) {
                Slice maxSlice;
                BinaryStatistics binaryStatistics = (BinaryStatistics)statistics;
                Slice minSlice = Slices.wrappedBuffer((byte[])binaryStatistics.getMin().getBytes());
                if (minSlice.compareTo(maxSlice = Slices.wrappedBuffer((byte[])binaryStatistics.getMax().getBytes())) > 0) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ParquetStringStatistics parquetStringStatistics = new ParquetStringStatistics(minSlice, maxSlice);
                return TupleDomainParquetPredicate.createDomain(type, hasNullValue, parquetStringStatistics);
            }
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, ParquetDictionaryDescriptor dictionaryDescriptor) {
        ParquetDictionary dictionary;
        if (dictionaryDescriptor == null) {
            return null;
        }
        ColumnDescriptor columnDescriptor = dictionaryDescriptor.getColumnDescriptor();
        Optional<ParquetDictionaryPage> dictionaryPage = dictionaryDescriptor.getDictionaryPage();
        if (!dictionaryPage.isPresent()) {
            return null;
        }
        try {
            dictionary = dictionaryPage.get().getEncoding().initDictionary(columnDescriptor, dictionaryPage.get());
        }
        catch (Exception e) {
            return null;
        }
        int dictionarySize = dictionaryPage.get().getDictionarySize();
        if (type.equals(BigintType.BIGINT) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.INT64) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToLong(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(BigintType.BIGINT) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.INT32) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToInt(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.DOUBLE) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToDouble(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (type.equals(DoubleType.DOUBLE) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.FLOAT) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)dictionary.decodeToFloat(i)));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        if (Varchars.isVarcharType((Type)type) && columnDescriptor.getType() == PrimitiveType.PrimitiveTypeName.BINARY) {
            ArrayList<Domain> domains = new ArrayList<Domain>();
            for (int i = 0; i < dictionarySize; ++i) {
                domains.add(Domain.singleValue((Type)type, (Object)Slices.wrappedBuffer((byte[])dictionary.decodeToBinary(i).getBytes())));
            }
            domains.add(Domain.onlyNull((Type)type));
            return Domain.union(domains);
        }
        return null;
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<T> rangeStatistics) {
        return TupleDomainParquetPredicate.createDomain(type, hasNullValue, rangeStatistics, value -> value);
    }

    private static <F, T extends Comparable<T>> Domain createDomain(Type type, boolean hasNullValue, ParquetRangeStatistics<F> rangeStatistics, Function<F, T> function) {
        F min = rangeStatistics.getMin();
        F max = rangeStatistics.getMax();
        if (min != null && max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)type, function.apply(min), (boolean)true, function.apply(max), (boolean)true), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (max != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)type, function.apply(max)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        if (min != null) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)type, function.apply(min)), (Range[])new Range[0]), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }
}

