/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.thrift;

import com.facebook.presto.hive.authentication.HiveMetastoreAuthentication;
import com.google.common.net.HostAndPort;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public final class Transport {
    public static TTransport create(String host, int port, HostAndPort socksProxy, int timeoutMillis, HiveMetastoreAuthentication authentication) throws TTransportException {
        try {
            TTransport rawTransport = Transport.createRaw(host, port, socksProxy, timeoutMillis);
            TTransport authenticatedTransport = authentication.authenticate(rawTransport, host);
            if (!authenticatedTransport.isOpen()) {
                authenticatedTransport.open();
            }
            return new TTransportWrapper(authenticatedTransport, host);
        }
        catch (TTransportException e) {
            throw Transport.rewriteException(e, host);
        }
    }

    private Transport() {
    }

    private static TTransport createRaw(String host, int port, HostAndPort socksProxy, int timeoutMillis) throws TTransportException {
        if (socksProxy == null) {
            return new TSocket(host, port, timeoutMillis);
        }
        Socket socks = Transport.createSocksSocket(socksProxy);
        try {
            try {
                socks.connect(InetSocketAddress.createUnresolved(host, port), timeoutMillis);
                socks.setSoTimeout(timeoutMillis);
                return new TSocket(socks);
            }
            catch (Throwable t) {
                Transport.closeQuietly(socks);
                throw t;
            }
        }
        catch (IOException e) {
            throw new TTransportException((Throwable)e);
        }
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Socket createSocksSocket(HostAndPort proxy) {
        InetSocketAddress address = InetSocketAddress.createUnresolved(proxy.getHost(), proxy.getPort());
        return new Socket(new Proxy(Proxy.Type.SOCKS, address));
    }

    private static TTransportException rewriteException(TTransportException e, String host) {
        return new TTransportException(e.getType(), String.format("%s: %s", host, e.getMessage()), e.getCause());
    }

    private static class TTransportWrapper
    extends TTransport {
        private final TTransport transport;
        private final String host;

        TTransportWrapper(TTransport transport, String host) {
            this.transport = transport;
            this.host = host;
        }

        public boolean isOpen() {
            return this.transport.isOpen();
        }

        public boolean peek() {
            return this.transport.peek();
        }

        public byte[] getBuffer() {
            return this.transport.getBuffer();
        }

        public int getBufferPosition() {
            return this.transport.getBufferPosition();
        }

        public int getBytesRemainingInBuffer() {
            return this.transport.getBytesRemainingInBuffer();
        }

        public void consumeBuffer(int len) {
            this.transport.consumeBuffer(len);
        }

        public void close() {
            this.transport.close();
        }

        public void open() throws TTransportException {
            try {
                this.transport.open();
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.host);
            }
        }

        public int readAll(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.readAll(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.host);
            }
        }

        public int read(byte[] bytes, int off, int len) throws TTransportException {
            try {
                return this.transport.read(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.host);
            }
        }

        public void write(byte[] bytes) throws TTransportException {
            try {
                this.transport.write(bytes);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.host);
            }
        }

        public void write(byte[] bytes, int off, int len) throws TTransportException {
            try {
                this.transport.write(bytes, off, len);
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.host);
            }
        }

        public void flush() throws TTransportException {
            try {
                this.transport.flush();
            }
            catch (TTransportException e) {
                throw Transport.rewriteException(e, this.host);
            }
        }
    }
}

