/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.strategy;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Queue;
import org.n3r.idworker.Id;
import org.n3r.idworker.RandomCodeStrategy;
import org.n3r.idworker.strategy.FileLock;
import org.n3r.idworker.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRandomCodeStrategy
implements RandomCodeStrategy {
    public static final int MAX_BITS = 1000000;
    Logger log = LoggerFactory.getLogger(DefaultRandomCodeStrategy.class);
    File idWorkerHome = Utils.createIdWorkerHome();
    volatile FileLock fileLock;
    BitSet codesFilter;
    int prefixIndex = -1;
    File codePrefixIndex;
    int minRandomSize = 6;
    int maxRandomSize = 6;
    static final int CACHE_CODES_NUM = 1000;
    SecureRandom secureRandom = new SecureRandom();
    Queue<Integer> availableCodes = new ArrayDeque<Integer>(1000);

    public DefaultRandomCodeStrategy() {
        this.destroyFileLockWhenShutdown();
    }

    @Override
    public void init() {
        this.release();
        while (++this.prefixIndex < 1000) {
            if (!this.tryUsePrefix()) continue;
            return;
        }
        throw new RuntimeException("all prefixes are used up, the world maybe ends!");
    }

    public DefaultRandomCodeStrategy setMinRandomSize(int minRandomSize) {
        this.minRandomSize = minRandomSize;
        return this;
    }

    public DefaultRandomCodeStrategy setMaxRandomSize(int maxRandomSize) {
        this.maxRandomSize = maxRandomSize;
        return this;
    }

    protected boolean tryUsePrefix() {
        this.codePrefixIndex = new File(this.idWorkerHome, Id.getWorkerId() + ".code.prefix." + this.prefixIndex);
        if (!this.createPrefixIndexFile()) {
            return false;
        }
        if (!this.createFileLock()) {
            return false;
        }
        if (!this.createBloomFilter()) {
            return false;
        }
        this.log.info("get available prefix index file {}", (Object)this.codePrefixIndex);
        return true;
    }

    private boolean createFileLock() {
        if (this.fileLock != null) {
            this.fileLock.destroy();
        }
        this.fileLock = new FileLock(this.codePrefixIndex);
        return this.fileLock.tryLock();
    }

    private boolean createBloomFilter() {
        this.codesFilter = (BitSet)this.fileLock.readObject();
        if (this.codesFilter == null) {
            this.log.info("create new bloom filter");
            this.codesFilter = new BitSet(1000000);
        } else {
            int size = this.codesFilter.cardinality();
            if (size >= 1000000) {
                this.log.warn("bloom filter with prefix file {} is already full", (Object)this.codePrefixIndex);
                return false;
            }
            this.log.info("recreate bloom filter with cardinality {}", (Object)size);
        }
        return true;
    }

    private void destroyFileLockWhenShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DefaultRandomCodeStrategy.this.release();
            }
        });
    }

    private boolean createPrefixIndexFile() {
        try {
            this.codePrefixIndex.createNewFile();
            return this.codePrefixIndex.exists();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.log.warn("create file {} error {}", (Object)this.codePrefixIndex, (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public int prefix() {
        return this.prefixIndex;
    }

    @Override
    public int next() {
        if (this.availableCodes.isEmpty()) {
            this.generate();
        }
        return this.availableCodes.poll();
    }

    @Override
    public synchronized void release() {
        if (this.fileLock != null) {
            this.fileLock.writeObject(this.codesFilter);
            this.fileLock.destroy();
            this.fileLock = null;
        }
    }

    private void generate() {
        for (int i = 0; i < 1000; ++i) {
            this.availableCodes.add(this.generateOne());
        }
        this.fileLock.writeObject(this.codesFilter);
    }

    private int generateOne() {
        while (true) {
            boolean existed;
            int code;
            int n = code = !(existed = this.contains(code = this.secureRandom.nextInt(this.max(this.maxRandomSize)))) ? this.add(code) : this.tryFindAvailableCode(code);
            if (code >= 0) {
                return code;
            }
            this.init();
        }
    }

    private int tryFindAvailableCode(int code) {
        int next = this.codesFilter.nextClearBit(code);
        if (next != -1 && next < this.max(this.maxRandomSize)) {
            return this.add(next);
        }
        next = this.codesFilter.previousClearBit(code);
        if (next != -1) {
            return this.add(next);
        }
        return -1;
    }

    private int add(int code) {
        this.codesFilter.set(code);
        return code;
    }

    private boolean contains(int code) {
        return this.codesFilter.get(code);
    }

    private int max(int size) {
        switch (size) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 10000;
            }
            case 5: {
                return 100000;
            }
            case 6: {
                return 1000000;
            }
            case 7: {
                return 10000000;
            }
            case 8: {
                return 100000000;
            }
            case 9: {
                return 1000000000;
            }
        }
        return Integer.MAX_VALUE;
    }
}

