/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.strategy;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import org.n3r.idworker.WorkerIdStrategy;
import org.n3r.idworker.strategy.FileLock;
import org.n3r.idworker.utils.HttpReq;
import org.n3r.idworker.utils.Ip;
import org.n3r.idworker.utils.Props;
import org.n3r.idworker.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkerIdStrategy
implements WorkerIdStrategy {
    static long workerIdBits = 10L;
    static long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)workerIdBits;
    static Random random = new SecureRandom();
    public static final WorkerIdStrategy instance = new DefaultWorkerIdStrategy();
    private final Properties props = Props.tryProperties("idworker-client.properties", ".idworkers");
    private final String idWorkerServerUrl = this.props.getProperty("server.address", "http://id.worker.server:18001");
    String userName = System.getProperty("user.name");
    String ipDotUsername = Ip.ip + "." + this.userName;
    String ipudotlock = this.ipDotUsername + ".lock.";
    int workerIdIndex = this.ipudotlock.length();
    long workerId;
    FileLock fileLock;
    Logger logger = LoggerFactory.getLogger(DefaultWorkerIdStrategy.class);
    private boolean inited;

    private void init() {
        this.workerId = this.findAvailWorkerId();
        if (this.workerId >= 0L) {
            this.destroyFileLockWhenShutdown();
            this.startSyncThread();
        } else {
            this.syncWithWorkerIdServer();
            this.workerId = this.findAvailWorkerId();
            if (this.workerId < 0L) {
                this.workerId = this.increaseWithWorkerIdServer();
            }
        }
        if (this.workerId < 0L) {
            this.workerId = this.tryToCreateOnIp();
        }
        if (this.workerId < 0L) {
            this.logger.warn("DANGEROUS!!! Try to use random worker id.");
            this.workerId = this.tryToRandomOnIp();
        }
        if (this.workerId < 0L) {
            this.logger.warn("the world may be ended!");
            throw new RuntimeException("the world may be ended");
        }
    }

    private void destroyFileLockWhenShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DefaultWorkerIdStrategy.this.fileLock.destroy();
            }
        });
    }

    private void startSyncThread() {
        new Thread(){

            @Override
            public void run() {
                DefaultWorkerIdStrategy.this.syncWithWorkerIdServer();
            }
        }.start();
    }

    private long increaseWithWorkerIdServer() {
        String incId = HttpReq.get(this.idWorkerServerUrl).req("/inc").param("ipu", this.ipDotUsername).exec();
        if (incId == null || incId.trim().isEmpty()) {
            return -1L;
        }
        long lid = Long.parseLong(incId);
        return this.checkAvail(lid);
    }

    private long tryToCreateOnIp() {
        long wid = Ip.lip & maxWorkerId;
        return this.checkAvail(wid);
    }

    private long tryToRandomOnIp() {
        long avaiWorkerId = -1L;
        long tryTimes = -1L;
        while (avaiWorkerId < 0L && ++tryTimes < maxWorkerId) {
            long wid = 0xFF & random.nextInt((int)maxWorkerId);
            avaiWorkerId = this.checkAvail(wid);
        }
        return avaiWorkerId;
    }

    private long checkAvail(long wid) {
        this.logger.debug("check availability worker id {}", (Object)wid);
        long availWorkerId = -1L;
        try {
            File idWorkerHome = Utils.createIdWorkerHome();
            File file = new File(idWorkerHome, this.ipudotlock + String.format("%04d", wid));
            boolean newFile = file.createNewFile();
            this.logger.debug("try create lock file {} with result {}", (Object)file.toString(), (Object)newFile);
            availWorkerId = this.findAvailWorkerId();
        }
        catch (IOException e) {
            this.logger.warn("checkAvail error", (Throwable)e);
        }
        return availWorkerId;
    }

    private void syncWithWorkerIdServer() {
        String syncIds = HttpReq.get(this.idWorkerServerUrl).req("/sync").param("ipu", this.ipDotUsername).param("ids", this.buildWorkerIdsOfCurrentIp()).exec();
        if (syncIds == null || syncIds.trim().isEmpty()) {
            return;
        }
        String[] syncIdsArr = syncIds.split(",");
        File idWorkerHome = Utils.createIdWorkerHome();
        for (String syncId : syncIdsArr) {
            try {
                new File(idWorkerHome, this.ipudotlock + syncId).createNewFile();
            }
            catch (IOException e) {
                this.logger.warn("create workerid lock file error", (Throwable)e);
            }
        }
    }

    private String buildWorkerIdsOfCurrentIp() {
        StringBuilder sb = new StringBuilder();
        File idWorkerHome = Utils.createIdWorkerHome();
        for (File lockFile : idWorkerHome.listFiles()) {
            String workerId;
            if (!lockFile.getName().startsWith(this.ipudotlock) || !(workerId = lockFile.getName().substring(this.workerIdIndex)).matches("\\d\\d\\d\\d")) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(workerId);
        }
        return sb.toString();
    }

    private long findAvailWorkerId() {
        File idWorkerHome = Utils.createIdWorkerHome();
        for (File lockFile : idWorkerHome.listFiles()) {
            String workerId;
            if (!lockFile.getName().startsWith(this.ipudotlock) || !(workerId = lockFile.getName().substring(this.workerIdIndex)).matches("\\d\\d\\d\\d")) continue;
            FileLock fileLock = new FileLock(lockFile);
            if (!fileLock.tryLock()) {
                fileLock.destroy();
                continue;
            }
            this.fileLock = fileLock;
            return Long.parseLong(workerId);
        }
        return -1L;
    }

    @Override
    public void initialize() {
        if (this.inited) {
            return;
        }
        this.init();
        this.inited = true;
    }

    @Override
    public long availableWorkerId() {
        return this.workerId;
    }

    @Override
    public void release() {
        if (this.fileLock != null) {
            this.fileLock.destroy();
        }
        this.inited = false;
    }
}

