/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.idworker.utils;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class Serializes {
    public static <T> List<T> readObjects(File file) {
        ArrayList<Object> objects = new ArrayList<Object>();
        ObjectInputStream objectReader = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            objectReader = new ObjectInputStream(fis);
            while (true) {
                objects.add(objectReader.readObject());
            }
        }
        catch (EOFException eOFException) {
            Serializes.closeQuietly(objectReader);
            Serializes.closeQuietly(fis);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Serializes.closeQuietly(objectReader);
                Serializes.closeQuietly(fis);
                throw throwable;
            }
        }
        return objects;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T readObject(File file) {
        Object object;
        ObjectInputStream objectReader = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            objectReader = new ObjectInputStream(fis);
            object = objectReader.readObject();
        }
        catch (EOFException eOFException) {
            Serializes.closeQuietly(objectReader);
            Serializes.closeQuietly(fis);
            return null;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Serializes.closeQuietly(objectReader);
                Serializes.closeQuietly(fis);
                throw throwable;
            }
        }
        Serializes.closeQuietly(objectReader);
        Serializes.closeQuietly(fis);
        return (T)object;
    }

    public static void writeObject(File file, Object object) {
        ObjectOutputStream objectOutput = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            objectOutput = new ObjectOutputStream(fos);
            objectOutput.writeObject(object);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Serializes.closeQuietly(objectOutput);
                Serializes.closeQuietly(fos);
                throw throwable;
            }
        }
        Serializes.closeQuietly(objectOutput);
        Serializes.closeQuietly(fos);
    }

    public static void writeObject(FileOutputStream fos, Object object) {
        FileChannel channel = fos.getChannel();
        if (!channel.isOpen()) {
            throw new RuntimeException("channel is closed");
        }
        try {
            channel.position(0L);
            ObjectOutputStream objectOutput = new ObjectOutputStream(fos);
            objectOutput.writeObject(object);
            fos.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeObjects(File file, Object ... objects) {
        ObjectOutputStream objectOutput = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            objectOutput = new ObjectOutputStream(fos);
            for (Object object : objects) {
                objectOutput.writeObject(object);
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Serializes.closeQuietly(objectOutput);
                Serializes.closeQuietly(fos);
                throw throwable;
            }
        }
        Serializes.closeQuietly(objectOutput);
        Serializes.closeQuietly(fos);
    }

    public static void closeQuietly(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

