/*
 * Decompiled with CFR 0.152.
 */
package com.github.dozermapper.core.builder.model.jaxb;

import com.github.dozermapper.core.MappingException;
import com.github.dozermapper.core.builder.model.jaxb.FieldDefinition;
import com.github.dozermapper.core.builder.model.jaxb.FieldExcludeDefinition;
import com.github.dozermapper.core.builder.model.jaxb.FieldType;
import com.github.dozermapper.core.fieldmap.DozerField;
import com.github.dozermapper.core.util.MappingUtils;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.commons.lang3.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="fieldDefinition")
public class FieldDefinitionDefinition {
    @XmlTransient
    private final FieldExcludeDefinition fieldExcludeParent;
    @XmlTransient
    private final FieldDefinition fieldParent;
    @XmlValue
    private String name;
    @XmlAttribute(name="date-format")
    private String dateFormat;
    @XmlAttribute(name="type")
    private FieldType type;
    @XmlAttribute(name="set-method")
    private String setMethod;
    @XmlAttribute(name="get-method")
    private String getMethod;
    @XmlAttribute(name="key")
    private String key;
    @XmlAttribute(name="map-set-method")
    private String mapSetMethod;
    @XmlAttribute(name="map-get-method")
    private String mapGetMethod;
    @XmlAttribute(name="is-accessible")
    private Boolean isAccessible;
    @XmlAttribute(name="create-method")
    private String createMethod;

    public FieldDefinitionDefinition() {
        this(null, null);
    }

    public FieldDefinitionDefinition(FieldExcludeDefinition fieldExcludeParent, FieldDefinition fieldParent) {
        this.fieldExcludeParent = fieldExcludeParent;
        this.fieldParent = fieldParent;
    }

    public FieldDefinitionDefinition withName(String name) {
        this.setName(name);
        return this;
    }

    public FieldDefinitionDefinition withDateFormat(String dateFormat) {
        this.setDateFormat(dateFormat);
        return this;
    }

    public FieldDefinitionDefinition withType(FieldType type) {
        this.setType(type);
        return this;
    }

    public FieldDefinitionDefinition withSetMethod(String setMethod) {
        this.setSetMethod(setMethod);
        return this;
    }

    public FieldDefinitionDefinition withGetMethod(String getMethod) {
        this.setGetMethod(getMethod);
        return this;
    }

    public FieldDefinitionDefinition withKey(String key) {
        this.setKey(key);
        return this;
    }

    public FieldDefinitionDefinition withMapSetMethod(String mapSetMethod) {
        this.setMapSetMethod(mapSetMethod);
        return this;
    }

    public FieldDefinitionDefinition withMapGetMethod(String mapGetMethod) {
        this.setMapGetMethod(mapGetMethod);
        return this;
    }

    public FieldDefinitionDefinition withAccessible(Boolean accessible) {
        this.setIsAccessible(accessible);
        return this;
    }

    public FieldDefinitionDefinition withCreateMethod(String createMethod) {
        this.setCreateMethod(createMethod);
        return this;
    }

    public FieldExcludeDefinition end() {
        return this.fieldExcludeParent;
    }

    public FieldDefinition endField() {
        return this.fieldParent;
    }

    public DozerField convert() {
        DozerField field = this.prepareField(this.name, this.type == null ? "" : this.type.value());
        field.setDateFormat(this.dateFormat);
        field.setMapGetMethod(this.mapGetMethod);
        field.setMapSetMethod(this.mapSetMethod);
        field.setTheGetMethod(this.getMethod);
        field.setTheSetMethod(this.setMethod);
        if (StringUtils.isNotEmpty((CharSequence)this.key)) {
            field.setKey(this.key);
        }
        if (this.isAccessible != null) {
            field.setAccessible(this.isAccessible);
        }
        field.setCreateMethod(this.createMethod);
        return field;
    }

    private DozerField prepareField(String name, String type) {
        if (MappingUtils.isBlankOrNull(name)) {
            throw new MappingException("Field name can not be empty");
        }
        String fieldType = null;
        String fieldName = this.isIndexed(name) ? this.getFieldNameOfIndexedField(name) : name;
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            fieldType = type;
        }
        String trimmedFieldName = fieldName.trim();
        DozerField field = new DozerField(trimmedFieldName, fieldType);
        if (this.isIndexed(name)) {
            field.setIndexed(true);
            field.setIndex(this.getIndexOfIndexedField(name));
        }
        return field;
    }

    private boolean isIndexed(String fieldName) {
        return fieldName != null && fieldName.matches(".+\\[\\d+\\]");
    }

    private String getFieldNameOfIndexedField(String fieldName) {
        return fieldName == null ? null : fieldName.replaceAll("\\[\\d+\\]$", "");
    }

    private int getIndexOfIndexedField(String fieldName) {
        return Integer.parseInt(fieldName.replaceAll(".*\\[", "").replaceAll("\\]", ""));
    }

    public FieldExcludeDefinition getFieldExcludeParent() {
        return this.fieldExcludeParent;
    }

    public FieldDefinition getFieldParent() {
        return this.fieldParent;
    }

    public String getName() {
        return this.name;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public FieldType getType() {
        return this.type;
    }

    public String getSetMethod() {
        return this.setMethod;
    }

    public String getGetMethod() {
        return this.getMethod;
    }

    public String getKey() {
        return this.key;
    }

    public String getMapSetMethod() {
        return this.mapSetMethod;
    }

    public String getMapGetMethod() {
        return this.mapGetMethod;
    }

    public Boolean getIsAccessible() {
        return this.isAccessible;
    }

    public String getCreateMethod() {
        return this.createMethod;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected void setType(FieldType type) {
        this.type = type;
    }

    protected void setSetMethod(String setMethod) {
        this.setMethod = setMethod;
    }

    protected void setGetMethod(String getMethod) {
        this.getMethod = getMethod;
    }

    protected void setKey(String key) {
        this.key = key;
    }

    protected void setMapSetMethod(String mapSetMethod) {
        this.mapSetMethod = mapSetMethod;
    }

    protected void setMapGetMethod(String mapGetMethod) {
        this.mapGetMethod = mapGetMethod;
    }

    protected void setIsAccessible(Boolean isAccessible) {
        this.isAccessible = isAccessible;
    }

    protected void setCreateMethod(String createMethod) {
        this.createMethod = createMethod;
    }

    public String toString() {
        return "FieldDefinitionDefinition(fieldExcludeParent=" + this.getFieldExcludeParent() + ", fieldParent=" + this.getFieldParent() + ", name=" + this.getName() + ", dateFormat=" + this.getDateFormat() + ", type=" + (Object)((Object)this.getType()) + ", setMethod=" + this.getSetMethod() + ", getMethod=" + this.getGetMethod() + ", key=" + this.getKey() + ", mapSetMethod=" + this.getMapSetMethod() + ", mapGetMethod=" + this.getMapGetMethod() + ", isAccessible=" + this.getIsAccessible() + ", createMethod=" + this.getCreateMethod() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldDefinitionDefinition)) {
            return false;
        }
        FieldDefinitionDefinition other = (FieldDefinitionDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FieldExcludeDefinition this$fieldExcludeParent = this.getFieldExcludeParent();
        FieldExcludeDefinition other$fieldExcludeParent = other.getFieldExcludeParent();
        if (this$fieldExcludeParent == null ? other$fieldExcludeParent != null : !((Object)this$fieldExcludeParent).equals(other$fieldExcludeParent)) {
            return false;
        }
        FieldDefinition this$fieldParent = this.getFieldParent();
        FieldDefinition other$fieldParent = other.getFieldParent();
        if (this$fieldParent == null ? other$fieldParent != null : !((Object)this$fieldParent).equals(other$fieldParent)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$dateFormat = this.getDateFormat();
        String other$dateFormat = other.getDateFormat();
        if (this$dateFormat == null ? other$dateFormat != null : !this$dateFormat.equals(other$dateFormat)) {
            return false;
        }
        FieldType this$type = this.getType();
        FieldType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$setMethod = this.getSetMethod();
        String other$setMethod = other.getSetMethod();
        if (this$setMethod == null ? other$setMethod != null : !this$setMethod.equals(other$setMethod)) {
            return false;
        }
        String this$getMethod = this.getGetMethod();
        String other$getMethod = other.getGetMethod();
        if (this$getMethod == null ? other$getMethod != null : !this$getMethod.equals(other$getMethod)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$mapSetMethod = this.getMapSetMethod();
        String other$mapSetMethod = other.getMapSetMethod();
        if (this$mapSetMethod == null ? other$mapSetMethod != null : !this$mapSetMethod.equals(other$mapSetMethod)) {
            return false;
        }
        String this$mapGetMethod = this.getMapGetMethod();
        String other$mapGetMethod = other.getMapGetMethod();
        if (this$mapGetMethod == null ? other$mapGetMethod != null : !this$mapGetMethod.equals(other$mapGetMethod)) {
            return false;
        }
        Boolean this$isAccessible = this.getIsAccessible();
        Boolean other$isAccessible = other.getIsAccessible();
        if (this$isAccessible == null ? other$isAccessible != null : !((Object)this$isAccessible).equals(other$isAccessible)) {
            return false;
        }
        String this$createMethod = this.getCreateMethod();
        String other$createMethod = other.getCreateMethod();
        return !(this$createMethod == null ? other$createMethod != null : !this$createMethod.equals(other$createMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FieldDefinitionDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FieldExcludeDefinition $fieldExcludeParent = this.getFieldExcludeParent();
        result = result * 59 + ($fieldExcludeParent == null ? 43 : ((Object)$fieldExcludeParent).hashCode());
        FieldDefinition $fieldParent = this.getFieldParent();
        result = result * 59 + ($fieldParent == null ? 43 : ((Object)$fieldParent).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $dateFormat = this.getDateFormat();
        result = result * 59 + ($dateFormat == null ? 43 : $dateFormat.hashCode());
        FieldType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $setMethod = this.getSetMethod();
        result = result * 59 + ($setMethod == null ? 43 : $setMethod.hashCode());
        String $getMethod = this.getGetMethod();
        result = result * 59 + ($getMethod == null ? 43 : $getMethod.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $mapSetMethod = this.getMapSetMethod();
        result = result * 59 + ($mapSetMethod == null ? 43 : $mapSetMethod.hashCode());
        String $mapGetMethod = this.getMapGetMethod();
        result = result * 59 + ($mapGetMethod == null ? 43 : $mapGetMethod.hashCode());
        Boolean $isAccessible = this.getIsAccessible();
        result = result * 59 + ($isAccessible == null ? 43 : ((Object)$isAccessible).hashCode());
        String $createMethod = this.getCreateMethod();
        result = result * 59 + ($createMethod == null ? 43 : $createMethod.hashCode());
        return result;
    }
}

