/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.ConfigApplier;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoEventTrigger;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RequestMatcher;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.ResponseSetting;
import com.github.dreamhead.moco.internal.BaseServer;
import com.github.dreamhead.moco.server.ServerSetting;
import com.github.dreamhead.moco.setting.Setting;
import com.github.dreamhead.moco.util.Configs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;

public abstract class BaseActualServer<T extends ResponseSetting<T>, U extends BaseActualServer>
extends BaseServer<T>
implements ServerSetting {
    private final MocoConfig[] configs;
    private final MocoMonitor monitor;
    private final List<Setting<T>> settings = Lists.newArrayList();
    private int port;
    private RequestMatcher anyMatcher = RequestMatcher.ANY_REQUEST_MATCHER;

    protected abstract Setting<T> newSetting(RequestMatcher var1);

    public BaseActualServer(int port, MocoMonitor monitor, MocoConfig[] configs) {
        this.port = port;
        this.monitor = monitor;
        this.configs = configs;
    }

    @Override
    public final int port() {
        if (this.port != 0) {
            return this.port;
        }
        throw new IllegalStateException("unbound port should not be returned");
    }

    @Override
    public final void setPort(int port) {
        this.port = port;
    }

    public final ImmutableList<Setting<T>> getSettings() {
        return Configs.configItems(this.settings, this.configs);
    }

    public final Setting<T> getAnySetting() {
        Setting<T> setting = this.newSetting(this.configuredAnyMatcher());
        if (this.handler != null) {
            setting.response(this.configuredAnyResponseHandler(), new ResponseHandler[0]);
        }
        for (MocoEventTrigger trigger : this.eventTriggers) {
            setting.on(trigger);
        }
        return setting;
    }

    @Override
    public final Optional<Integer> getPort() {
        if (this.port == 0) {
            return Optional.empty();
        }
        return Optional.of(this.port);
    }

    public final MocoMonitor getMonitor() {
        return this.monitor;
    }

    protected final void addSetting(Setting<T> setting) {
        this.settings.add(setting);
    }

    protected final void addEvents(List<MocoEventTrigger> eventTriggers) {
        this.eventTriggers.addAll(eventTriggers);
    }

    protected final void anySetting(RequestMatcher anyMatcher, ResponseHandler handler) {
        if (handler != null) {
            this.response(handler, new ResponseHandler[0]);
            this.anyMatcher = anyMatcher;
        }
    }

    protected final void addSettings(ImmutableList<Setting<T>> thatSettings) {
        for (Setting thatSetting : thatSettings) {
            this.addSetting(thatSetting);
        }
    }

    private <V extends ConfigApplier<V>> V configured(V source) {
        return Configs.configItem(source, this.configs);
    }

    protected final RequestMatcher configuredAnyMatcher() {
        return this.configured(this.anyMatcher);
    }

    protected final ResponseHandler configuredAnyResponseHandler() {
        return this.configured(this.handler);
    }

    public final U mergeServer(U thatServer) {
        U newServer = this.createMergeServer(thatServer);
        ((BaseActualServer)newServer).addSettings(this.getSettings());
        ((BaseActualServer)newServer).addSettings(((BaseActualServer)thatServer).getSettings());
        ((BaseActualServer)newServer).anySetting(this.configuredAnyMatcher(), this.configuredAnyResponseHandler());
        ((BaseActualServer)newServer).anySetting(((BaseActualServer)thatServer).configuredAnyMatcher(), ((BaseActualServer)thatServer).configuredAnyResponseHandler());
        ((BaseActualServer)newServer).addEvents(this.eventTriggers);
        ((BaseActualServer)newServer).addEvents(((BaseActualServer)thatServer).eventTriggers);
        return newServer;
    }

    protected abstract U createMergeServer(U var1);
}

