/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.HttpResponseSetting;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.DefaultHttpRequest;
import com.github.dreamhead.moco.model.DefaultMutableHttpResponse;
import com.github.dreamhead.moco.setting.Setting;
import com.google.common.collect.ImmutableList;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.concurrent.GenericFutureListener;

@ChannelHandler.Sharable
public final class MocoHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final int DEFAULT_STATUS = HttpResponseStatus.OK.code();
    private final ImmutableList<Setting<HttpResponseSetting>> settings;
    private final Setting<HttpResponseSetting> anySetting;
    private final MocoMonitor monitor;

    public MocoHandler(ActualHttpServer server) {
        this.settings = server.getSettings();
        this.anySetting = server.getAnySetting();
        this.monitor = server.getMonitor();
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest message) {
        FullHttpResponse response = this.handleRequest(message);
        this.closeIfNotKeepAlive(message, ctx.write((Object)response));
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private FullHttpResponse handleRequest(FullHttpRequest message) {
        HttpRequest request = DefaultHttpRequest.newRequest(message);
        DefaultMutableHttpResponse httpResponse = this.getHttpResponse(request);
        FullHttpResponse response = httpResponse.toFullResponse();
        this.prepareForKeepAlive(message, response);
        this.monitor.onMessageLeave(httpResponse);
        return response;
    }

    private DefaultMutableHttpResponse getHttpResponse(HttpRequest request) {
        try {
            this.monitor.onMessageArrived(request);
            return this.doGetHttpResponse(request);
        }
        catch (RuntimeException e) {
            this.monitor.onException(e);
            return DefaultMutableHttpResponse.newResponse(request, HttpResponseStatus.BAD_REQUEST.code());
        }
        catch (Exception e) {
            this.monitor.onException(e);
            return DefaultMutableHttpResponse.newResponse(request, HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        }
    }

    private DefaultMutableHttpResponse doGetHttpResponse(HttpRequest request) {
        DefaultMutableHttpResponse httpResponse = DefaultMutableHttpResponse.newResponse(request, DEFAULT_STATUS);
        SessionContext context = new SessionContext(request, httpResponse);
        for (Setting setting : this.settings) {
            if (!setting.match(request)) continue;
            setting.writeToResponse(context);
            return httpResponse;
        }
        if (this.anySetting.match(request)) {
            this.anySetting.writeToResponse(context);
            return httpResponse;
        }
        this.monitor.onUnexpectedMessage(request);
        return DefaultMutableHttpResponse.newResponse(request, HttpResponseStatus.BAD_REQUEST.code());
    }

    private void closeIfNotKeepAlive(FullHttpRequest request, ChannelFuture future) {
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private void prepareForKeepAlive(FullHttpRequest request, FullHttpResponse response) {
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
            this.setContentLengthForKeepAlive(response);
        }
    }

    private void setContentLengthForKeepAlive(FullHttpResponse response) {
        if (!HttpUtil.isContentLengthSet((HttpMessage)response)) {
            HttpUtil.setContentLength((HttpMessage)response, (long)response.content().writerIndex());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.monitor.onException(cause);
    }
}

