/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.internal.ActualHttpServer;
import com.github.dreamhead.moco.internal.MocoHandler;
import com.github.dreamhead.moco.internal.ServerConfig;
import com.github.dreamhead.moco.server.ServerConfiguration;
import com.github.dreamhead.moco.server.ServerSetting;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;

public class MocoHttpServer
implements ServerConfiguration {
    private static final int MAX_INITIAL_LINE_LENGTH = 4096;
    private static final int MAX_CHUNK_SIZE = 8192;
    private final ActualHttpServer serverSetting;

    public MocoHttpServer(ActualHttpServer serverSetting) {
        this.serverSetting = serverSetting;
    }

    @Override
    public final ServerSetting serverSetting() {
        return this.serverSetting;
    }

    public final ChannelInitializer<SocketChannel> channelInitializer() {
        return new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                if (MocoHttpServer.this.serverSetting.isSecure()) {
                    pipeline.addFirst("ssl", (ChannelHandler)MocoHttpServer.this.serverSetting.sslHandler().get());
                }
                ServerConfig serverConfig = MocoHttpServer.this.serverSetting.getServerConfig();
                pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec(4096, serverConfig.getHeaderSize(), 8192, false));
                pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(serverConfig.getContentLength()));
                pipeline.addLast("handler", (ChannelHandler)new MocoHandler(MocoHttpServer.this.serverSetting));
            }
        };
    }
}

