/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.internal;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.SocketResponseSetting;
import com.github.dreamhead.moco.internal.ActualSocketServer;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.DefaultSocketRequest;
import com.github.dreamhead.moco.model.DefaultSocketResponse;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.setting.Setting;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.InputStream;

@ChannelHandler.Sharable
public final class MocoSocketHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private final ImmutableList<Setting<SocketResponseSetting>> settings;
    private final Setting<SocketResponseSetting> anySetting;
    private final MocoMonitor monitor;

    public MocoSocketHandler(ActualSocketServer server) {
        this.settings = server.getSettings();
        this.anySetting = server.getAnySetting();
        this.monitor = server.getMonitor();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        try {
            MessageContent content = MessageContent.content().withContent((InputStream)new ByteBufInputStream(msg)).build();
            DefaultSocketRequest request = new DefaultSocketRequest(content);
            this.monitor.onMessageArrived(request);
            DefaultSocketResponse response = new DefaultSocketResponse();
            this.handleSession(new SessionContext(request, response));
            this.monitor.onMessageLeave(response);
            ctx.write((Object)Unpooled.wrappedBuffer((byte[])response.getContent().getContent()));
        }
        catch (Exception e) {
            this.monitor.onException(e);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleSession(SessionContext context) {
        for (Setting setting : this.settings) {
            if (!setting.match(context.getRequest())) continue;
            setting.writeToResponse(context);
            return;
        }
        if (this.anySetting.match(context.getRequest())) {
            this.anySetting.writeToResponse(context);
            return;
        }
        this.monitor.onUnexpectedMessage(context.getRequest());
        throw new MocoException(String.format("No handler found for request: %s", context.getRequest().getContent()));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.monitor.onException(cause);
    }
}

