/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.HttpProtocolVersion;
import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.extractor.CookiesRequestExtractor;
import com.github.dreamhead.moco.extractor.FormsRequestExtractor;
import com.github.dreamhead.moco.model.DefaultHttpMessage;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.util.Suppliers;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@JsonDeserialize(builder=Builder.class)
public final class DefaultHttpRequest
extends DefaultHttpMessage
implements HttpRequest {
    private final Supplier<ImmutableMap<String, String>> formSupplier;
    private final Supplier<ImmutableMap<String, String>> cookieSupplier;
    private final HttpMethod method;
    private final String uri;
    private final ImmutableMap<String, String[]> queries;

    private DefaultHttpRequest(HttpProtocolVersion version, MessageContent content, HttpMethod method, String uri, ImmutableMap<String, String[]> headers, ImmutableMap<String, String[]> queries) {
        super(version, content, headers);
        this.method = method;
        this.uri = uri;
        this.queries = queries;
        this.formSupplier = this.formSupplier();
        this.cookieSupplier = this.cookieSupplier();
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @JsonIgnore
    public ImmutableMap<String, String> getForms() {
        return this.formSupplier.get();
    }

    @JsonIgnore
    public ImmutableMap<String, String> getCookies() {
        return this.cookieSupplier.get();
    }

    @Override
    @JsonSerialize(as=Map.class)
    public ImmutableMap<String, String[]> getQueries() {
        return this.queries;
    }

    private Supplier<ImmutableMap<String, String>> formSupplier() {
        return Suppliers.memoize(() -> {
            Optional<ImmutableMap> forms = new FormsRequestExtractor().extract(this);
            return forms.orElseGet(ImmutableMap::of);
        });
    }

    private Supplier<ImmutableMap<String, String>> cookieSupplier() {
        return Suppliers.memoize(() -> {
            Optional<ImmutableMap> cookies = new CookiesRequestExtractor().extract(this);
            return cookies.orElseGet(ImmutableMap::of);
        });
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("uri", (Object)this.uri).add("method", (Object)this.method).add("queries", this.queries);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static MessageContent toMessageContent(FullHttpRequest request) {
        long contentLength = HttpUtil.getContentLength((HttpMessage)request, (int)-1);
        if (contentLength <= 0L) {
            return MessageContent.content().build();
        }
        return MessageContent.content().withCharset(HttpUtil.getCharset((HttpMessage)request)).withContent((InputStream)new ByteBufInputStream(request.content())).build();
    }

    public static HttpRequest newRequest(FullHttpRequest request) {
        QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
        ImmutableMap<String, String[]> queries = DefaultHttpRequest.toQueries(decoder);
        return ((Builder)((Builder)((Builder)DefaultHttpRequest.builder().withVersion(HttpProtocolVersion.versionOf(request.protocolVersion().text()))).withHeaders(DefaultHttpRequest.toHeaders((HttpMessage)request))).withMethod(HttpMethod.valueOf(request.method().toString().toUpperCase())).withUri(decoder.path()).withQueries((Map<String, String[]>)queries).withContent(DefaultHttpRequest.toMessageContent(request))).build();
    }

    private static ImmutableMap<String, String[]> toQueries(QueryStringDecoder decoder) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : decoder.parameters().entrySet()) {
            List value = (List)entry.getValue();
            builder.put(entry.getKey(), (Object)value.toArray(new String[0]));
        }
        return builder.build();
    }

    public FullHttpRequest toFullHttpRequest() {
        ByteBuf buffer = Unpooled.buffer();
        MessageContent content = this.getContent();
        if (content != null) {
            buffer.writeBytes(content.getContent());
        }
        QueryStringEncoder encoder = new QueryStringEncoder(this.uri);
        for (Map.Entry entry : this.queries.entrySet()) {
            String[] values;
            for (String value : values = (String[])entry.getValue()) {
                encoder.addParam((String)entry.getKey(), value);
            }
        }
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.valueOf((String)this.getVersion().text()), io.netty.handler.codec.http.HttpMethod.valueOf((String)this.method.name()), encoder.toString(), buffer);
        for (Map.Entry entry : this.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (String[])entry.getValue()) {
                request.headers().add(key, (Object)value);
            }
        }
        return request;
    }

    public static final class Builder
    extends DefaultHttpMessage.Builder<Builder> {
        private HttpMethod method;
        private String uri;
        private ImmutableMap<String, String[]> queries;

        public Builder withMethod(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder withUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder withQueries(Map<String, String[]> queries) {
            if (queries != null) {
                this.queries = ImmutableMap.copyOf(queries);
            }
            return this;
        }

        public DefaultHttpRequest build() {
            return new DefaultHttpRequest(this.getVersion(), this.getContent(), this.method, this.uri, this.getHeaders(), this.queries);
        }
    }
}

