/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.util.FileContentType;
import com.google.common.net.MediaType;
import java.nio.charset.Charset;

public abstract class AbstractFileResourceReader
implements ContentResourceReader {
    private final Resource filename;
    private final Charset charset;

    protected abstract byte[] doReadFor(Request var1);

    protected AbstractFileResourceReader(Resource filename, Charset charset) {
        this.charset = charset;
        this.filename = filename;
    }

    @Override
    public final MessageContent readFor(Request request) {
        return this.asMessageContent(this.doReadFor(request));
    }

    private MessageContent asMessageContent(byte[] content) {
        MessageContent.Builder builder = MessageContent.content().withContent(content);
        if (this.charset != null) {
            builder.withCharset(this.charset);
        }
        return builder.build();
    }

    @Override
    public final MediaType getContentType(HttpRequest request) {
        String targetFilename = this.filename(request);
        return new FileContentType(targetFilename, this.charset).getContentType();
    }

    protected final String filename(Request request) {
        MessageContent messageContent = this.filename.readFor(request);
        return messageContent.toString();
    }
}

