/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.resource.reader.AbstractFileResourceReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class FileResourceReader
extends AbstractFileResourceReader {
    private final MocoConfig config;

    public FileResourceReader(Resource file) {
        this(file, null, null);
    }

    public FileResourceReader(Resource file, Charset charset, MocoConfig config) {
        super(file, charset);
        this.config = config;
    }

    @Override
    protected byte[] doReadFor(Request request) {
        String pathname = this.targetFileName(request);
        Path path = Paths.get(pathname, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("%s does not exist", path.getFileName().toString()));
        }
        try {
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new MocoException(e);
        }
    }

    private String targetFileName(Request request) {
        String filename = this.filename(request);
        if (this.config != null) {
            return this.config.apply(filename);
        }
        return filename;
    }
}

