/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.resource.reader;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.resource.ContentResource;
import com.github.dreamhead.moco.resource.reader.ContentResourceReader;
import com.github.dreamhead.moco.resource.reader.TemplateRequest;
import com.github.dreamhead.moco.resource.reader.Variable;
import com.github.dreamhead.moco.util.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.net.MediaType;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.Version;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateResourceReader
implements ContentResourceReader {
    private static final Version CURRENT_VERSION = Configuration.getVersion();
    private static final String TEMPLATE_NAME = "template";
    private static final List<String> RESERVED_NAME = ImmutableList.of((Object)"req", (Object)"now", (Object)"random");
    private static Logger logger = LoggerFactory.getLogger(TemplateResourceReader.class);
    private final ContentResource template;
    private final ImmutableMap<String, ? extends Variable> variables;

    public static String checkValidVariableName(String name) {
        if (!RESERVED_NAME.contains(Preconditions.checkNotNullOrEmpty(name, "Template variable name should not be null"))) {
            return name;
        }
        throw new IllegalArgumentException("Template variable name should not be same with reserved name");
    }

    public TemplateResourceReader(ContentResource template, ImmutableMap<String, ? extends Variable> variables) {
        this.template = template;
        this.variables = variables;
    }

    @Override
    public final MessageContent readFor(Request request) {
        if (request == null) {
            throw new IllegalStateException("Request is required to render template");
        }
        MessageContent content = this.template.readFor(request);
        try {
            Template targetTemplate = this.createTemplate(content);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(stream);
            targetTemplate.process(this.variables(request), (Writer)writer);
            return MessageContent.content().withContent(stream.toByteArray()).build();
        }
        catch (ParseException e) {
            logger.error("Fail to parse template: {}", (Object)content.toString());
            throw new MocoException(e);
        }
        catch (TemplateException | IOException e) {
            throw new MocoException(e);
        }
    }

    private Template createTemplate(MessageContent messageContent) throws IOException {
        StringTemplateLoader templateLoader = this.createTemplateLoader(messageContent);
        Configuration cfg = this.createConfiguration((TemplateLoader)templateLoader, messageContent.getCharset());
        return cfg.getTemplate(TEMPLATE_NAME);
    }

    private StringTemplateLoader createTemplateLoader(MessageContent messageContent) {
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        templateLoader.putTemplate(TEMPLATE_NAME, messageContent.toString());
        return templateLoader;
    }

    private Configuration createConfiguration(TemplateLoader templateLoader, Charset charset) {
        Configuration cfg = new Configuration(CURRENT_VERSION);
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapperBuilder(CURRENT_VERSION).build());
        cfg.setDefaultEncoding(charset.name());
        cfg.setTemplateLoader(templateLoader);
        return cfg;
    }

    private ImmutableMap<String, Object> variables(Request request) {
        return ImmutableMap.builder().putAll(this.toVariableString(request)).put((Object)"now", (Object)new NowMethod()).put((Object)"random", (Object)new RandomMethod()).put((Object)"req", (Object)this.toTemplateRequest(request)).build();
    }

    private TemplateRequest toTemplateRequest(Request request) {
        return new TemplateRequest(request);
    }

    private ImmutableMap<String, Object> toVariableString(final Request request) {
        return ImmutableMap.copyOf((Map)Maps.transformEntries(this.variables, (Maps.EntryTransformer)new Maps.EntryTransformer<String, Variable, Object>(){

            public Object transformEntry(String key, Variable value) {
                return value.toTemplateVariable(request);
            }
        }));
    }

    @Override
    public final MediaType getContentType(HttpRequest request) {
        return this.template.getContentType(request);
    }

    static {
        System.setProperty("org.freemarker.loggerLibrary", "none");
    }

    private static class RandomMethod
    implements TemplateMethodModelEx {
        private RandomMethod() {
        }

        public Object exec(List arguments) {
            Optional<Long> range = this.getRange(arguments);
            Optional<? extends NumberFormat> format = this.getFormat(arguments);
            double result = new Random().nextDouble() * (double)range.orElse(1L).longValue();
            if (format.isPresent()) {
                return format.get().format(result);
            }
            return result;
        }

        private Optional<? extends NumberFormat> getFormat(List<?> arguments) {
            Object last;
            if (arguments.size() > 0 && (last = arguments.get(arguments.size() - 1)) instanceof SimpleScalar) {
                SimpleScalar lastArgument = (SimpleScalar)last;
                return Optional.of(new DecimalFormat(lastArgument.toString()));
            }
            return Optional.empty();
        }

        private Optional<Long> getRange(List<?> arguments) {
            Object range;
            if (arguments.size() > 0 && (range = arguments.get(0)) instanceof SimpleNumber) {
                return this.getRange((SimpleNumber)range);
            }
            return Optional.empty();
        }

        private Optional<Long> getRange(SimpleNumber range) {
            long reference = range.getAsNumber().longValue();
            if (reference <= 0L) {
                throw new IllegalArgumentException("Random range should be greater than 0");
            }
            return Optional.of(reference);
        }
    }

    private static class NowMethod
    implements TemplateMethodModelEx {
        private NowMethod() {
        }

        public Object exec(List arguments) {
            if (arguments.size() < 1) {
                throw new IllegalArgumentException("Date format is required");
            }
            Date date = new Date();
            SimpleDateFormat format = new SimpleDateFormat(arguments.get(0).toString());
            return format.format(date);
        }
    }
}

