/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.server;

import com.github.dreamhead.moco.MocoException;
import com.github.dreamhead.moco.util.MocoExecutors;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public final class MocoServer {
    private EventLoopGroup group = new NioEventLoopGroup(0, (Executor)MocoExecutors.executor());
    private ChannelFuture future;

    public int start(int port, ChannelInitializer<? extends Channel> pipelineFactory) {
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.group).channel(NioServerSocketChannel.class)).childHandler(pipelineFactory);
        try {
            this.future = bootstrap.bind(port).sync();
            SocketAddress socketAddress = this.future.channel().localAddress();
            return ((InetSocketAddress)socketAddress).getPort();
        }
        catch (InterruptedException e) {
            throw new MocoException(e);
        }
    }

    public void stop() {
        this.doStop();
    }

    private void doStop() {
        if (this.future != null) {
            this.future.channel().close().syncUninterruptibly();
            this.future = null;
        }
        if (this.group != null) {
            Future groupFuture = this.group.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
            try {
                groupFuture.get();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.group = null;
        }
    }
}

