/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco;

import com.github.dreamhead.moco.HttpMethod;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.RestIdMatcher;
import com.github.dreamhead.moco.RestServer;
import com.github.dreamhead.moco.RestSettingBuilder;
import com.github.dreamhead.moco.internal.ApiUtils;
import com.github.dreamhead.moco.monitor.QuietMonitor;
import com.github.dreamhead.moco.rest.ActualRestServer;
import com.github.dreamhead.moco.rest.RestIdMatchers;
import com.github.dreamhead.moco.rest.RestIds;
import com.github.dreamhead.moco.rest.builder.ActualSubResourceSettingBuilder;
import com.github.dreamhead.moco.rest.builder.RestSettingBuilders;
import com.github.dreamhead.moco.rest.builder.SubResourceSettingBuilder;
import com.google.common.base.Preconditions;

public final class MocoRest {
    public static RestServer restServer(int port, MocoConfig ... configs) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        Preconditions.checkNotNull((Object)configs, (Object)"Config should not be null");
        return new ActualRestServer(port, null, (MocoMonitor)new QuietMonitor(), (MocoConfig[])Preconditions.checkNotNull((Object)configs, (Object)"Configuration should not be null"));
    }

    public static RestServer restServer(int port, MocoMonitor monitor, MocoConfig ... configs) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        Preconditions.checkNotNull((Object)configs, (Object)"Config should not be null");
        return new ActualRestServer(port, null, (MocoMonitor)Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), (MocoConfig[])Preconditions.checkNotNull((Object)configs, (Object)"Configuration should not be null"));
    }

    public static RestServer restServer(int port, MocoMonitor monitor, MocoMonitor monitor2, MocoMonitor ... monitors) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be greater than zero");
        return new ActualRestServer(port, null, ApiUtils.mergeMonitor((MocoMonitor)Preconditions.checkNotNull((Object)monitor, (Object)"Monitor should not be null"), (MocoMonitor)Preconditions.checkNotNull((Object)monitor2, (Object)"Monitor should not be null"), (MocoMonitor[])Preconditions.checkNotNull((Object)monitors, (Object)"Monitor should not be null")), new MocoConfig[0]);
    }

    public static RestIdMatcher anyId() {
        return RestIdMatchers.anyId();
    }

    public static SubResourceSettingBuilder id(String id) {
        return new ActualSubResourceSettingBuilder(RestIdMatchers.eq(RestIds.checkId(id)));
    }

    public static SubResourceSettingBuilder id(RestIdMatcher id) {
        return new ActualSubResourceSettingBuilder((RestIdMatcher)Preconditions.checkNotNull((Object)id, (Object)"ID matcher should not be null"));
    }

    public static RestSettingBuilder get(String id) {
        return MocoRest.get(RestIdMatchers.eq(RestIds.checkId(id)));
    }

    public static RestSettingBuilder get() {
        return RestSettingBuilders.all(HttpMethod.GET);
    }

    public static RestSettingBuilder get(RestIdMatcher idMatcher) {
        return RestSettingBuilders.single(HttpMethod.GET, (RestIdMatcher)Preconditions.checkNotNull((Object)idMatcher, (Object)"ID Matcher should not be null"));
    }

    public static RestSettingBuilder post() {
        return RestSettingBuilders.all(HttpMethod.POST);
    }

    public static RestSettingBuilder put(RestIdMatcher idMatcher) {
        return RestSettingBuilders.single(HttpMethod.PUT, (RestIdMatcher)Preconditions.checkNotNull((Object)idMatcher, (Object)"ID Matcher should not be null"));
    }

    public static RestSettingBuilder put(String id) {
        return MocoRest.put(RestIdMatchers.eq(RestIds.checkId(id)));
    }

    public static RestSettingBuilder delete(RestIdMatcher idMatcher) {
        return RestSettingBuilders.single(HttpMethod.DELETE, (RestIdMatcher)Preconditions.checkNotNull((Object)idMatcher, (Object)"ID Matcher should not be null"));
    }

    public static RestSettingBuilder delete(String id) {
        return MocoRest.delete(RestIdMatchers.eq(RestIds.checkId(id)));
    }

    public static RestSettingBuilder head() {
        return RestSettingBuilders.all(HttpMethod.HEAD);
    }

    public static RestSettingBuilder head(RestIdMatcher idMatcher) {
        return RestSettingBuilders.single(HttpMethod.HEAD, (RestIdMatcher)Preconditions.checkNotNull((Object)idMatcher, (Object)"ID Matcher should not be null"));
    }

    public static RestSettingBuilder head(String id) {
        return MocoRest.head(RestIdMatchers.eq(RestIds.checkId(id)));
    }

    public static RestSettingBuilder patch(RestIdMatcher idMatcher) {
        return RestSettingBuilders.single(HttpMethod.PATCH, (RestIdMatcher)Preconditions.checkNotNull((Object)idMatcher, (Object)"ID Matcher should not be null"));
    }

    public static RestSettingBuilder patch(String id) {
        return MocoRest.patch(RestIdMatchers.eq(RestIds.checkId(id)));
    }

    private MocoRest() {
    }
}

