/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.handler;

import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseElement;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.util.Iterables;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class AndResponseHandler
extends AbstractResponseHandler {
    private final Iterable<ResponseHandler> handlers;

    private AndResponseHandler(Iterable<ResponseHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void writeToResponse(SessionContext context) {
        for (ResponseHandler handler : this.handlers) {
            handler.writeToResponse(context);
        }
    }

    @Override
    public ResponseHandler doApply(MocoConfig config) {
        return AndResponseHandler.and(StreamSupport.stream(this.handlers.spliterator(), false).map(handler -> (ResponseHandler)handler.apply(config)).collect(Collectors.toList()));
    }

    public static ResponseHandler and(Iterable<ResponseHandler> handlers) {
        return new AndResponseHandler(handlers);
    }

    public static ResponseHandler and(ResponseElement handler, ResponseElement ... handlers) {
        if (handlers.length == 0) {
            return Moco.with(handler);
        }
        List<ResponseElement> elements = Iterables.asIterable(handler, handlers);
        List<ResponseHandler> responseHandlers = elements.stream().map(Moco::with).collect(Collectors.toList());
        return new AndResponseHandler(responseHandlers);
    }
}

