/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.monitor;

import com.github.dreamhead.moco.MocoMonitor;
import com.github.dreamhead.moco.Request;
import com.github.dreamhead.moco.Response;

public final class CompositeMonitor
implements MocoMonitor {
    private final Iterable<MocoMonitor> monitors;

    public CompositeMonitor(Iterable<MocoMonitor> monitors) {
        this.monitors = monitors;
    }

    @Override
    public void onMessageArrived(Request request) {
        for (MocoMonitor monitor : this.monitors) {
            monitor.onMessageArrived(request);
        }
    }

    @Override
    public void onException(Throwable t) {
        for (MocoMonitor monitor : this.monitors) {
            monitor.onException(t);
        }
    }

    @Override
    public void onMessageLeave(Response response) {
        for (MocoMonitor monitor : this.monitors) {
            monitor.onMessageLeave(response);
        }
    }

    @Override
    public void onUnexpectedMessage(Request request) {
        for (MocoMonitor monitor : this.monitors) {
            monitor.onUnexpectedMessage(request);
        }
    }
}

