/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.recorder;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.recorder.RequestRecorder;
import com.google.common.net.MediaType;

public class InMemoryRequestRecorder
implements RequestRecorder {
    private HttpRequest httpRequest;

    @Override
    public final void record(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    @Override
    public final HttpRequest getRequest() {
        return this.httpRequest;
    }

    public final MessageContent getContent() {
        if (this.httpRequest != null) {
            return this.httpRequest.getContent();
        }
        return MessageContent.content().build();
    }

    public final MediaType getContentType() {
        if (this.httpRequest == null) {
            return MediaType.PLAIN_TEXT_UTF_8;
        }
        String header = this.httpRequest.getHeader("Content-Type");
        if (header == null) {
            return MediaType.PLAIN_TEXT_UTF_8;
        }
        try {
            return MediaType.parse((String)header);
        }
        catch (Exception e) {
            return MediaType.PLAIN_TEXT_UTF_8;
        }
    }
}

