/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.HttpRequest;
import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.MutableHttpResponse;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.RestSetting;
import com.github.dreamhead.moco.handler.AbstractHttpResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.rest.RestRequestDispatcher;
import java.util.Optional;

public final class RestHandler
extends AbstractHttpResponseHandler {
    private final RestRequestDispatcher dispatcher;
    private final String name;
    private final Iterable<RestSetting> settings;

    public RestHandler(String name, Iterable<RestSetting> settings) {
        this.name = name;
        this.dispatcher = new RestRequestDispatcher(name, settings);
        this.settings = settings;
    }

    @Override
    protected void doWriteToResponse(HttpRequest httpRequest, MutableHttpResponse httpResponse) {
        Optional<ResponseHandler> responseHandler = this.dispatcher.getResponseHandler(httpRequest);
        if (responseHandler.isPresent()) {
            responseHandler.get().writeToResponse(new SessionContext(httpRequest, httpResponse));
            return;
        }
        throw new UnsupportedOperationException("Unsupported REST request");
    }

    @Override
    public ResponseHandler doApply(MocoConfig config) {
        if (config.isFor("uri")) {
            return new RestHandler(config.apply(this.name), this.settings);
        }
        return this;
    }
}

