/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.rest;

import com.github.dreamhead.moco.util.Preconditions;
import com.github.dreamhead.moco.util.URLs;

public final class RestIds {
    public static String checkId(String id) {
        return RestIds.checkValidUrlItem(id, "Rest ID");
    }

    public static String checkResourceName(String name) {
        return RestIds.checkValidUrlItem(name, "Resource name");
    }

    private static String checkValidUrlItem(String id, String item) {
        Preconditions.checkNotNullOrEmpty(id, item + " should not be null or empty");
        if (id.contains("/")) {
            throw new IllegalArgumentException(item + " should not contain '/'");
        }
        if (!URLs.isValidUrl(id)) {
            throw new IllegalArgumentException(item + " should not contains invalid URI character");
        }
        return id;
    }

    private RestIds() {
    }
}

