/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.websocket;

import com.github.dreamhead.moco.MocoConfig;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.AbstractResponseHandler;
import com.github.dreamhead.moco.internal.SessionContext;
import com.github.dreamhead.moco.model.MessageContent;
import com.github.dreamhead.moco.recorder.MocoGroup;
import com.github.dreamhead.moco.resource.Resource;
import com.github.dreamhead.moco.util.ByteBufs;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;

public class WebSocketBroadcastHandler
extends AbstractResponseHandler {
    private final Resource content;
    private final MocoGroup group;

    public WebSocketBroadcastHandler(Resource content, MocoGroup group) {
        this.content = content;
        this.group = group;
    }

    @Override
    public void writeToResponse(SessionContext context) {
        MessageContent content = this.content.readFor(context.getRequest());
        ByteBuf byteBuf = ByteBufs.toByteBuf(content.getContent());
        context.writeAndFlush(new BinaryWebSocketFrame(byteBuf), this.group);
    }

    @Override
    public ResponseHandler doApply(MocoConfig config) {
        Resource applied = this.content.apply(config);
        if (applied == this.content) {
            return this;
        }
        return new WebSocketBroadcastHandler(applied, this.group);
    }
}

