/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.Utils;
import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RedisCommand(value="scan")
public class Scan
extends AbstractRedisOperation {
    private static final long CURSOR_START = 0L;
    private static final long DEFAULT_COUNT = 10L;
    private static final String MATCH = "match";
    private static final String COUNT = "count";
    protected Slice cursorSlice;
    protected int size;

    public Scan(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected void doOptionalWork() {
        this.cursorSlice = this.params().get(0);
        this.size = this.base().keys().size();
    }

    @Override
    protected Slice response() {
        long cursor = this.cursorSlice != null ? Utils.convertToLong(this.cursorSlice.toString()) : 0L;
        String match = Scan.extractParameter(this.params(), MATCH).map(Slice::toString).orElse("*");
        long count = Scan.extractParameter(this.params(), COUNT).map(s -> Utils.convertToLong(s.toString())).orElse(10L);
        String regex = Utils.createRegexFromGlob(match);
        List<Slice> matchingValues = this.getMatchingValues(regex, cursor, count);
        if ((cursor += count) >= (long)this.size) {
            cursor = 0L;
        }
        ArrayList<Slice> response = new ArrayList<Slice>();
        Collections.addAll(response, Response.bulkString(Slice.create(String.valueOf(cursor))), Response.array(matchingValues));
        return Response.array(response);
    }

    private static Optional<Slice> extractParameter(List<Slice> params, String name) {
        for (int i = 0; i < params.size(); ++i) {
            String param = new String(params.get(i).data());
            if (!name.equalsIgnoreCase(param)) continue;
            return Optional.of(params.get(i + 1));
        }
        return Optional.empty();
    }

    protected List<Slice> getMatchingValues(String regex, long cursor, long count) {
        return this.base().keys().stream().skip(cursor).limit(count).filter(x -> x.toString().matches(regex)).map(Response::bulkString).collect(Collectors.toList());
    }
}

