/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.taglib;

import com.google.javascript.jscomp.CompilationLevel;
import com.googlecode.htmlcompressor.compressor.ClosureJavaScriptCompressor;
import com.googlecode.htmlcompressor.compressor.YuiJavaScriptCompressor;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptCompressorTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(JavaScriptCompressorTag.class);
    private boolean enabled = true;
    private String jsCompressor = "yui";
    private boolean yuiJsNoMunge;
    private boolean yuiJsPreserveAllSemiColons;
    private boolean yuiJsDisableOptimizations;
    private int yuiJsLineBreak = -1;
    private String closureOptLevel = "simple";

    public int doEndTag() throws JspException {
        BodyContent bodyContent = this.getBodyContent();
        String content = bodyContent.getString();
        try {
            if (this.enabled) {
                String result;
                if (this.jsCompressor.equalsIgnoreCase("closure")) {
                    ClosureJavaScriptCompressor closureCompressor = new ClosureJavaScriptCompressor();
                    if (this.closureOptLevel.equalsIgnoreCase("advanced")) {
                        closureCompressor.setCompilationLevel(CompilationLevel.ADVANCED_OPTIMIZATIONS);
                    } else if (this.closureOptLevel.equalsIgnoreCase("whitespace")) {
                        closureCompressor.setCompilationLevel(CompilationLevel.WHITESPACE_ONLY);
                    } else {
                        closureCompressor.setCompilationLevel(CompilationLevel.SIMPLE_OPTIMIZATIONS);
                    }
                    result = closureCompressor.compress(content);
                } else {
                    YuiJavaScriptCompressor yuiCompressor = new YuiJavaScriptCompressor();
                    yuiCompressor.setDisableOptimizations(this.yuiJsDisableOptimizations);
                    yuiCompressor.setLineBreak(this.yuiJsLineBreak);
                    yuiCompressor.setNoMunge(this.yuiJsNoMunge);
                    yuiCompressor.setPreserveAllSemiColons(this.yuiJsPreserveAllSemiColons);
                    result = yuiCompressor.compress(content);
                }
                bodyContent.clear();
                bodyContent.append((CharSequence)result);
                bodyContent.writeOut((Writer)this.pageContext.getOut());
            } else {
                bodyContent.clear();
                bodyContent.append((CharSequence)content);
                bodyContent.writeOut((Writer)this.pageContext.getOut());
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return super.doEndTag();
    }

    public void setYuiJsNoMunge(boolean yuiJsNoMunge) {
        this.yuiJsNoMunge = yuiJsNoMunge;
    }

    public void setYuiJsPreserveAllSemiColons(boolean yuiJsPreserveAllSemiColons) {
        this.yuiJsPreserveAllSemiColons = yuiJsPreserveAllSemiColons;
    }

    public void setYuiJsDisableOptimizations(boolean yuiJsDisableOptimizations) {
        this.yuiJsDisableOptimizations = yuiJsDisableOptimizations;
    }

    public void setYuiJsLineBreak(int yuiJsLineBreak) {
        this.yuiJsLineBreak = yuiJsLineBreak;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setJsCompressor(String jsCompressor) {
        this.jsCompressor = jsCompressor;
    }

    public void setClosureOptLevel(String closureOptLevel) {
        this.closureOptLevel = closureOptLevel;
    }
}

