/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.htmlcompressor.velocity;

import com.googlecode.htmlcompressor.compressor.YuiCssCompressor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.TemplateInitException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.Node;

public class CssCompressorDirective
extends Directive {
    private boolean enabled = true;
    private int yuiCssLineBreak = -1;

    public String getName() {
        return "compressCss";
    }

    public int getType() {
        return 1;
    }

    public void init(RuntimeServices rs, InternalContextAdapter context, Node node) throws TemplateInitException {
        super.init(rs, context, node);
        this.log = rs.getLog();
        this.enabled = rs.getBoolean("userdirective.compressCss.enabled", true);
        this.yuiCssLineBreak = rs.getInt("userdirective.compressCss.yuiCssLineBreak", -1);
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, MethodInvocationException {
        StringWriter content = new StringWriter();
        node.jjtGetChild(0).render(context, (Writer)content);
        if (this.enabled) {
            try {
                YuiCssCompressor compressor = new YuiCssCompressor();
                compressor.setLineBreak(this.yuiCssLineBreak);
                String result = compressor.compress(content.toString());
                writer.write(result);
            }
            catch (Exception e) {
                writer.write(content.toString());
                String msg = "Failed to compress content: " + content.toString();
                this.log.error(msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        } else {
            writer.write(content.toString());
        }
        return true;
    }
}

