/*
 * Decompiled with CFR 0.152.
 */
package com.github.inspektr.error.support;

import com.github.inspektr.common.spi.PrincipalResolver;
import com.github.inspektr.error.ErrorLogManager;
import com.github.inspektr.error.ErrorReporter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultErrorLogManager
implements ErrorLogManager {
    private String applicationCode;
    private PrincipalResolver currentContextPrincipalResolver;
    private List<ErrorReporter> errorReporters;

    public DefaultErrorLogManager(String applicationCode, List<ErrorReporter> errorReporters) {
        this.applicationCode = applicationCode;
        this.errorReporters = errorReporters;
    }

    public void setCurrentContextPrincipalResolver(PrincipalResolver resolver) {
        this.currentContextPrincipalResolver = resolver;
    }

    @Override
    public void recordError(String errorDescription) {
        String principal = this.resolvePrincipal();
        for (ErrorReporter r : this.errorReporters) {
            r.reportError(this.applicationCode, principal, errorDescription);
        }
    }

    @Override
    public void recordError(Throwable throwable) {
        String principal = this.resolvePrincipal();
        for (ErrorReporter r : this.errorReporters) {
            r.reportError(this.applicationCode, principal, throwable);
        }
    }

    @Override
    public List<ErrorReporter> getErrorReporters() {
        return this.errorReporters;
    }

    private String resolvePrincipal() {
        return this.currentContextPrincipalResolver == null ? null : this.currentContextPrincipalResolver.resolve();
    }
}

