/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.utils;

import cn.hutool.core.util.StrUtil;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeZoneUtil
implements Serializable {
    private static final long serialVersionUID = -1331008203306650395L;

    public static String dateToTimeZone(long time) throws Exception {
        return DateTimeZoneUtil.dateToTimeZone(new Date(time));
    }

    public static String dateToTimeZone(Date date) throws Exception {
        if (date == null) {
            throw new Exception("date is not null");
        }
        ZonedDateTime zonedDateTime = DateTimeConverterUtil.toZonedDateTime((Date)date);
        String time = DateTimeFormatterUtil.format((ZonedDateTime)zonedDateTime, (DateTimeFormatter)DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_XXX_FMT);
        return time;
    }

    public static String timeZoneDateToStr(String str) throws Exception {
        if (StrUtil.isBlank((CharSequence)str)) {
            throw new Exception("str is not null");
        }
        ZonedDateTime zonedDateTime = DateTimeFormatterUtil.parseToZonedDateTime((String)str, (DateTimeFormatter)DateTimeFormatterUtil.YYYY_MM_DD_T_HH_MM_SS_XXX_FMT);
        if (zonedDateTime == null) {
            throw new Exception("str to zonedDateTime fail");
        }
        String time = zonedDateTime.format(DateTimeFormatterUtil.YYYY_MM_DD_HH_MM_SS_FMT);
        return time;
    }

    public static void main(String[] args) throws Exception {
        String timeZone = DateTimeZoneUtil.dateToTimeZone(System.currentTimeMillis() + 180000L);
        String timeZone2 = DateTimeZoneUtil.dateToTimeZone(new Date());
        System.out.println(timeZone + " " + timeZone2);
        String date = DateTimeZoneUtil.timeZoneDateToStr(timeZone);
        System.out.println(date);
    }
}

