/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.core.utils;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);

    public static <V extends ResultCheck> V retryOnException(int retryLimit, Callable<V> retryCallable) {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            try {
                v = (ResultCheck)retryCallable.call();
            }
            catch (Exception e) {
                log.warn("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson()), (Throwable)e);
            }
            if (null != v && v.matching()) break;
            log.error("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson()));
        }
        return (V)v;
    }

    public static <V extends ResultCheck> V retryOnException(int retryLimit, long sleepMillis, Callable<V> retryCallable) throws InterruptedException {
        ResultCheck v = null;
        for (int i = 0; i < retryLimit; ++i) {
            try {
                v = (ResultCheck)retryCallable.call();
            }
            catch (Exception e) {
                log.warn("retry on " + (i + 1) + " times v = " + (v == null ? null : v.getJson()), (Throwable)e);
            }
            if (null != v && v.matching()) break;
            log.error("retry on " + (i + 1) + " times but not matching v = " + (v == null ? null : v.getJson()));
            if (sleepMillis <= 0L) continue;
            Thread.sleep(sleepMillis);
        }
        return (V)v;
    }

    public static interface ResultCheck {
        public boolean matching();

        public String getJson();
    }
}

