/*
 * Decompiled with CFR 0.152.
 */
package com.github.lalyos.jfiglet;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;

public class FigletFont {
    public char hardblank;
    public int height = -1;
    public int heightWithoutDescenders = -1;
    public int maxLine = -1;
    public int smushMode = -1;
    public char[][][] font = new char[1024][][];
    public String fontName = null;
    public static final int MAX_CHARS = 1024;

    public char[][][] getFont() {
        return this.font;
    }

    public char[][] getChar(int c) {
        return this.font[c];
    }

    public String getCharLineString(int c, int l) {
        if (this.font[c][l] == null) {
            return null;
        }
        return new String(this.font[c][l]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FigletFont(InputStream stream) throws IOException {
        BufferedReader data = null;
        try {
            data = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), "UTF-8"));
            String dummyS = data.readLine();
            StringTokenizer st = new StringTokenizer(dummyS, " ");
            String s = st.nextToken();
            this.hardblank = s.charAt(s.length() - 1);
            this.height = Integer.parseInt(st.nextToken());
            this.heightWithoutDescenders = Integer.parseInt(st.nextToken());
            this.maxLine = Integer.parseInt(st.nextToken());
            this.smushMode = Integer.parseInt(st.nextToken());
            int dummyI = Integer.parseInt(st.nextToken());
            st = new StringTokenizer(data.readLine(), " ");
            this.fontName = st.hasMoreElements() ? st.nextToken() : "";
            for (int i = 0; i < dummyI - 1; ++i) {
                dummyS = data.readLine();
            }
            int charCode = 31;
            while (dummyS != null) {
                ++charCode;
                for (int h = 0; h < this.height; ++h) {
                    dummyS = data.readLine();
                    if (dummyS == null) continue;
                    int iNormal = charCode;
                    boolean abnormal = true;
                    if (h == 0) {
                        try {
                            String codeTag = dummyS.concat(" ").split(" ")[0];
                            charCode = codeTag.length() > 2 && "x".equals(codeTag.substring(1, 2)) ? Integer.parseInt(codeTag.substring(2), 16) : Integer.parseInt(codeTag);
                        }
                        catch (NumberFormatException e) {
                            abnormal = false;
                        }
                        if (abnormal) {
                            dummyS = data.readLine();
                        } else {
                            charCode = iNormal;
                        }
                    }
                    if (h == 0) {
                        this.font[charCode] = new char[this.height][];
                    }
                    int t = dummyS.length() - 1 - (h == this.height - 1 ? 1 : 0);
                    if (this.height == 1) {
                        ++t;
                    }
                    this.font[charCode][h] = new char[t];
                    for (int l = 0; l < t; ++l) {
                        char a = dummyS.charAt(l);
                        this.font[charCode][h][l] = a == this.hardblank ? 32 : (int)a;
                    }
                }
            }
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
    }

    public String convert(String message) throws IOException {
        String result = "";
        for (int l = 0; l < this.height; ++l) {
            for (int c = 0; c < message.length(); ++c) {
                result = result + this.getCharLineString(message.charAt(c), l);
            }
            result = result + '\n';
        }
        return result;
    }

    public static String convertOneLine(InputStream fontFileStream, String message) throws IOException {
        return new FigletFont(fontFileStream).convert(message);
    }

    public static String convertOneLine(String message) throws IOException {
        return FigletFont.convertOneLine(FigletFont.class.getClassLoader().getResourceAsStream("standard.flf"), message);
    }

    public static String convertOneLine(File fontFile, String message) throws IOException {
        return FigletFont.convertOneLine(new FileInputStream(fontFile), message);
    }

    public static String convertOneLine(String fontPath, String message) throws IOException {
        InputStream fontStream = null;
        fontStream = fontPath.startsWith("classpath:") ? FigletFont.class.getResourceAsStream(fontPath.substring(10)) : (fontPath.startsWith("http://") || fontPath.startsWith("https://") ? new URL(fontPath).openStream() : new FileInputStream(fontPath));
        return FigletFont.convertOneLine(fontStream, message);
    }
}

