/*
 * Decompiled with CFR 0.152.
 */
package com.github.lalyos.jfiglet;

import com.github.lalyos.jfiglet.FigletFont;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;

public class JFiglet {
    public static void main(String[] args) throws IOException {
        Iterator<String> arguments = Arrays.asList(args).iterator();
        String font = null;
        String text = null;
        PrintStream out = System.out;
        while (arguments.hasNext()) {
            String arg = arguments.next();
            if ("-f".equals(arg)) {
                font = JFiglet.requireNextArgument(arguments, arg);
                continue;
            }
            if ("-o".equals(arg)) {
                out = new PrintStream(new FileOutputStream(JFiglet.requireNextArgument(arguments, arg)));
                continue;
            }
            if (arguments.hasNext()) break;
            text = arg;
            break;
        }
        if (text == null) {
            System.err.println(JFiglet.usage());
        } else if (font == null) {
            out.println(FigletFont.convertOneLine(text));
        } else {
            out.println(FigletFont.convertOneLine(font, text));
        }
        out.close();
    }

    private static String requireNextArgument(Iterator<String> arguments, String sw) {
        if (arguments.hasNext()) {
            return arguments.next();
        }
        throw new IllegalStateException("Argument required after " + sw);
    }

    private static String usage() {
        StringWriter result = new StringWriter();
        PrintWriter pw = new PrintWriter(result);
        pw.println("Usage: java -jar jfiglet.jar [-f FLF] [-o OUTFILE] MESSAGE");
        pw.println("Prints MESSAGE to OUTFILE (default stdout) as ASCII art using Figlet font");
        pw.println("Example: java -jar jfiglet.jar -f \"/opt/myfont.flf\" \"Hello World\"");
        pw.println("\n");
        pw.println("Figlet font:");
        pw.println("  -f  FLF is font file location within file system, java classpath or www.");
        pw.println("      When FLF starts with `http://'|`https://' file will be fetched from WWW,");
        pw.println("      if FLF starts with `classpath:' then it will be looked for in JRE classpath,");
        pw.println("      otherwise FLF is path to FLF file in file system.");
        return result.toString();
    }
}

