/*
 * Decompiled with CFR 0.152.
 */
package com.lk.api.controller;

import com.itextpdf.text.pdf.PdfPTable;
import com.lk.api.controller.LKADController;
import com.lk.api.domain.MethodModel;
import com.lk.api.domain.ModelModel;
import com.lk.api.domain.ParamModel;
import com.lk.api.domain.PropertyModel;
import com.lk.api.domain.ResposeModel;
import com.lk.api.domain.TypeModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"lkad"})
public class ExportMarkDownController {
    @Autowired
    private LKADController lkadController;

    @PostMapping(value={"exportMarkDown"})
    public Object exportPdf(String serverName, HttpServletResponse response) throws Exception {
        Object object;
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> data = this.lkadController.loadLKADocument(serverName, "", 0);
        String projectName = data.get("projectName").toString();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(projectName + ".md"), "UTF-8"));
        pw.println("# " + projectName);
        pw.println("##### \u9879\u76ee\u63cf\u8ff0\uff1a" + data.get("description").toString());
        if (data.get("version") != null) {
            pw.println("##### \u9879\u76ee\u7248\u672c\uff1a" + data.get("version").toString());
        }
        if ((object = data.get("apiDoc")) == null) {
            result.put("code", "500");
            result.put("msg", "\u6ca1\u6709\u627e\u5230\u63a5\u53e3\u4fe1\u606f!");
            return result;
        }
        if (!(object instanceof List)) {
            result.put("code", "500");
            result.put("msg", "\u63a5\u53e3\u4fe1\u606f\u7ed3\u6784\u5f02\u5e38!");
            return result;
        }
        List typeModels = (List)object;
        if (typeModels.size() == 0) {
            result.put("code", "500");
            result.put("msg", "\u6ca1\u6709\u627e\u5230\u63a5\u53e3\u4fe1\u606f!");
            return result;
        }
        int i = 1;
        for (Object typeObj : typeModels) {
            if (!(typeObj instanceof TypeModel)) continue;
            TypeModel typeModel = (TypeModel)typeObj;
            String typeName = typeModel.getName();
            String typeDesc = typeModel.getDescription();
            if (typeDesc != null && !"".equals(typeDesc)) {
                typeName = typeName + "," + typeDesc;
            }
            pw.println();
            pw.println();
            pw.println("### " + i + " " + typeName);
            List<MethodModel> methodModels = typeModel.getMethodModels();
            if (methodModels == null || methodModels.size() == 0) continue;
            int j = 1;
            for (MethodModel methodModel : methodModels) {
                String methodName = methodModel.getName();
                String methodDesc = methodModel.getDescription();
                if (methodDesc != null && !"".equals(methodDesc)) {
                    methodName = methodName + "," + methodDesc;
                }
                pw.println();
                pw.println("#### " + i + "." + j + " " + methodName);
                String author = methodModel.getAuthor();
                String createTime = methodModel.getCreateTime();
                String updateTime = methodModel.getUpdateTime();
                if (author == null || "".equals(author)) {
                    author = "\u672a\u8bbe\u7f6e";
                }
                if (createTime == null || "".equals(createTime)) {
                    createTime = "\u672a\u8bbe\u7f6e";
                }
                if (updateTime == null || "".equals(updateTime)) {
                    updateTime = "\u672a\u8bbe\u7f6e";
                }
                pw.println("**\u7248\u672c\u53f7\uff1a** " + methodModel.getVersion());
                pw.println("**Method Type\uff1a** " + methodModel.getRequestType());
                pw.println("**Url\uff1a** " + methodModel.getUrl());
                pw.println("**Content Type\uff1a** " + methodModel.getContentType());
                pw.println("**Author\uff1a** " + author + " **CreateTime\uff1a** " + createTime + " **updateTime\uff1a** " + updateTime);
                pw.println("##### \u8bf7\u6c42\u53c2\u6570");
                pw.println("| \u540d\u79f0 | \u4f5c\u7528 | \u662f\u5426\u5fc5\u987b | \u6570\u636e\u7c7b\u578b | \u53c2\u6570\u7c7b\u578b | \u63cf\u8ff0 |");
                pw.println("| :---- | :---- | :---- | :---- | :---- | :---- |");
                List<ParamModel> paramModels = methodModel.getRequest();
                if (paramModels != null && paramModels.size() > 0) {
                    this.buildRequests(paramModels, "method", "req", pw);
                } else {
                    pw.println("| \u8be5\u63a5\u53e3\u6ca1\u6709\u8bf7\u6c42\u53c2\u6570 |  |  |  |  |  |");
                }
                pw.println("##### \u54cd\u5e94\u53c2\u6570");
                PdfPTable responseTable = new PdfPTable(4);
                List<ResposeModel> resposeModels = methodModel.getRespose();
                pw.println("| \u540d\u79f0 | \u4f5c\u7528 |  \u6570\u636e\u7c7b\u578b | \u63cf\u8ff0 |");
                pw.println("| :---- | :---- | :---- | :---- |");
                if (resposeModels != null && resposeModels.size() > 0) {
                    ArrayList<String> valueRecord = new ArrayList<String>();
                    this.buildParams(resposeModels, "method", "res", valueRecord, pw);
                } else {
                    pw.println("| \u8be5\u63a5\u53e3\u6ca1\u6709\u54cd\u5e94\u53c2\u6570 |  |   |  |");
                }
                pw.println();
                pw.println("------");
                ++j;
            }
            ++i;
        }
        pw.flush();
        pw.close();
        this.download(projectName + ".md", response);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String path, HttpServletResponse response) {
        OutputStream toClient = null;
        try {
            File file = new File(path);
            String filename = file.getName();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            toClient.write(buffer);
            toClient.flush();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (toClient != null) {
                try {
                    toClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void buildRequests(List<ParamModel> rms, String loc, String type, PrintWriter pw) {
        if (rms != null && rms.size() > 0) {
            for (ParamModel resp : rms) {
                ModelModel modelModel;
                String value = resp.getValue();
                boolean array = resp.getArray();
                String name = resp.getName();
                if (!(loc == null || "".equals(loc) || "method".equals(loc) || value == null || "".equals(value))) {
                    value = loc + "." + value;
                }
                if (value == null || "".equals(value)) {
                    value = loc;
                }
                if (array) {
                    value = value + "[]";
                }
                String tValue = value;
                if (value.contains(".")) {
                    int lastIndexOf = value.lastIndexOf(".");
                    String[] split = value.split("[.]");
                    tValue = value.substring(lastIndexOf + 1);
                    for (int len = split.length; len > 1; --len) {
                        tValue = "   " + tValue;
                    }
                }
                if ((modelModel = resp.getModelModel()) == null) {
                    pw.println("| " + value + " | " + name + " | " + (resp.getRequired() ? "\u662f" : "\u5426") + " | " + resp.getDataType() + " | " + resp.getParamType() + " | " + resp.getDescription() + " |");
                    continue;
                }
                if ("req".equals(type)) {
                    this.buildPropertys(modelModel.getPropertyModels(), "", "reqs", pw);
                }
                if (!"reqs".equals(type)) continue;
                pw.println("| " + value + " | " + name + " | " + (resp.getRequired() ? "\u662f" : "\u5426") + " | | | " + resp.getDescription() + " |");
                this.buildPropertys(modelModel.getPropertyModels(), value, "reqs", pw);
            }
        }
    }

    public void buildParams(List<ResposeModel> rms, String loc, String type, List<String> valueRecord, PrintWriter pw) {
        try {
            if (rms != null && rms.size() > 0) {
                for (ResposeModel resp : rms) {
                    String value = resp.getValue();
                    boolean array = resp.getArray();
                    String dataType = resp.getDataType();
                    String name = resp.getName();
                    String description = resp.getDescription();
                    ArrayList<ResposeModel> arr = new ArrayList<ResposeModel>();
                    this.filter(value, rms, arr);
                    if (!(loc == null || "".equals(loc) || "method".equals(loc) || value == null || "".equals(value))) {
                        value = loc + "." + value;
                    }
                    if (value == null || "".equals(value)) {
                        value = loc;
                    }
                    if (array) {
                        value = value + "[]";
                    }
                    String tValue = value;
                    if (value.contains(".")) {
                        int lastIndexOf = value.lastIndexOf(".");
                        String[] split = value.split("[.]");
                        tValue = value.substring(lastIndexOf + 1);
                        for (int len = split.length; len > 1; --len) {
                            tValue = "   " + tValue;
                        }
                    }
                    if (arr != null && arr.size() > 0) {
                        boolean bool = true;
                        if (valueRecord != null && valueRecord.size() > 0) {
                            for (String vr : valueRecord) {
                                if (!vr.equals(value)) continue;
                                bool = false;
                                break;
                            }
                        }
                        if (bool) {
                            pw.println("| " + value + " | " + name + " |  | " + description + " |");
                        }
                        this.buildParams(arr, value, "resp", valueRecord, pw);
                        continue;
                    }
                    ModelModel modelModel = resp.getModelModel();
                    if (modelModel == null) {
                        boolean bool = true;
                        if (valueRecord != null && valueRecord.size() > 0) {
                            for (String vr : valueRecord) {
                                if (!vr.equals(value)) continue;
                                bool = false;
                                break;
                            }
                        }
                        if (!bool) continue;
                        pw.println("| " + value + " | " + name + " | " + dataType + " | " + description + " |");
                        continue;
                    }
                    if ("res".equals(type)) {
                        this.buildPropertys(modelModel.getPropertyModels(), "", "resps", pw);
                    }
                    if ("resp".equals(type)) {
                        this.buildPropertys(modelModel.getPropertyModels(), value, "resps", pw);
                    }
                    if (!"resps".equals(type)) continue;
                    boolean bool = true;
                    if (valueRecord != null && valueRecord.size() > 0) {
                        for (String vr : valueRecord) {
                            if (!vr.equals(value)) continue;
                            bool = false;
                            break;
                        }
                    }
                    if (bool) {
                        pw.println("| " + value + " | " + name + " |  | " + description + " |");
                    }
                    this.buildPropertys(modelModel.getPropertyModels(), value, "resps", pw);
                }
            }
        }
        catch (ConcurrentModificationException e) {
            this.buildParams(rms, loc, type, valueRecord, pw);
        }
    }

    public void buildPropertys(List<PropertyModel> rms, String loc, String type, PrintWriter pw) {
        if (rms != null && rms.size() > 0) {
            for (PropertyModel resp : rms) {
                ModelModel modelModel;
                String value = resp.getValue();
                boolean array = resp.getArray();
                String dataType = resp.getDataType();
                String name = resp.getName();
                String description = resp.getDescription();
                if (!(loc == null || "".equals(loc) || "method".equals(loc) || value == null || "".equals(value))) {
                    value = loc + "." + value;
                }
                if (value == null || "".equals(value)) {
                    value = loc;
                }
                if (array) {
                    value = value + "[]";
                }
                String tValue = value;
                if (value.contains(".")) {
                    int lastIndexOf = value.lastIndexOf(".");
                    String[] split = value.split("[.]");
                    tValue = value.substring(lastIndexOf + 1);
                    for (int len = split.length; len > 1; --len) {
                        tValue = "   " + tValue;
                    }
                }
                if ((modelModel = resp.getModelModel()) == null) {
                    if ("reqs".equals(type) || "req".equals(type)) {
                        pw.println("| " + value + " | " + name + " | " + (resp.getRequired() ? "\u662f" : "\u5426") + " | " + resp.getDataType() + " | " + resp.getParamType() + " | " + resp.getDescription() + " |");
                        continue;
                    }
                    pw.println("| " + value + " | " + name + " | " + dataType + " | " + description + " |");
                    continue;
                }
                if ("res".equals(type)) {
                    this.buildPropertys(modelModel.getPropertyModels(), "", "resps", pw);
                }
                if ("resp".equals(type)) {
                    this.buildPropertys(modelModel.getPropertyModels(), value, "resps", pw);
                }
                if ("resps".equals(type)) {
                    pw.println("| " + value + " | " + name + " |  | " + description + " |");
                    this.buildPropertys(modelModel.getPropertyModels(), value, "resps", pw);
                }
                if (!"reqs".equals(type)) continue;
                pw.println("| " + value + " | " + name + " | " + (resp.getRequired() ? "\u662f" : "\u5426") + " | | | " + resp.getDescription() + " |");
                this.buildPropertys(modelModel.getPropertyModels(), value, "reqs", pw);
            }
        }
    }

    public void filter(String value, List<ResposeModel> rms, List<ResposeModel> arr) {
        if (rms == null || rms.size() == 0 || value == null || "".equals(value)) {
            return;
        }
        Iterator<ResposeModel> iterator = rms.iterator();
        while (iterator.hasNext()) {
            try {
                ResposeModel rm = iterator.next();
                if (!value.equals(rm.getParentName())) continue;
                String var = rm.getValue();
                arr.add(rm);
                iterator.remove();
                this.filter(var, rms, arr);
            }
            catch (Exception e) {
                this.filter(value, rms, arr);
                break;
            }
        }
    }
}

