/*
 * Decompiled with CFR 0.152.
 */
package com.lk.api.controller;

import com.itextpdf.text.Chapter;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Section;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.lk.api.controller.LKADController;
import com.lk.api.controller.PdfFontUtils;
import com.lk.api.domain.MethodModel;
import com.lk.api.domain.ModelModel;
import com.lk.api.domain.ParamModel;
import com.lk.api.domain.PropertyModel;
import com.lk.api.domain.ResposeModel;
import com.lk.api.domain.TypeModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"lkad"})
public class ExportPDFController {
    @Autowired
    private LKADController lkadController;

    @PostMapping(value={"exportPdf"})
    public Object exportPdf(String serverName, HttpServletResponse response) throws Exception {
        Object object;
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, Object> data = this.lkadController.loadLKADocument(serverName, "", 0);
        String projectName = data.get("projectName").toString();
        Document doc = this.createPdf(projectName + ".pdf");
        int chNum = 1;
        doc.add((Element)PdfFontUtils.getFont(1, projectName));
        doc.add((Element)PdfFontUtils.getFont(6, "\u9879\u76ee\u63cf\u8ff0\uff1a" + data.get("description").toString()));
        if (data.get("version") != null) {
            doc.add((Element)PdfFontUtils.getFont(6, "\u9879\u76ee\u7248\u672c\uff1a" + data.get("version").toString()));
        }
        if ((object = data.get("apiDoc")) == null) {
            result.put("code", "500");
            result.put("msg", "\u6ca1\u6709\u627e\u5230\u63a5\u53e3\u4fe1\u606f!");
            return result;
        }
        if (!(object instanceof List)) {
            result.put("code", "500");
            result.put("msg", "\u63a5\u53e3\u4fe1\u606f\u7ed3\u6784\u5f02\u5e38!");
            return result;
        }
        List typeModels = (List)object;
        if (typeModels.size() == 0) {
            result.put("code", "500");
            result.put("msg", "\u6ca1\u6709\u627e\u5230\u63a5\u53e3\u4fe1\u606f!");
            return result;
        }
        for (Object typeObj : typeModels) {
            if (!(typeObj instanceof TypeModel)) continue;
            TypeModel typeModel = (TypeModel)typeObj;
            String typeName = typeModel.getName();
            String typeDesc = typeModel.getDescription();
            if (typeDesc != null && !"".equals(typeDesc)) {
                typeName = typeName + "," + typeDesc;
            }
            Chapter chapter = new Chapter(PdfFontUtils.getFont(2, typeName), chNum++);
            List<MethodModel> methodModels = typeModel.getMethodModels();
            if (methodModels == null || methodModels.size() == 0) continue;
            for (MethodModel methodModel : methodModels) {
                String methodName = methodModel.getName();
                String methodDesc = methodModel.getDescription();
                if (methodDesc != null && !"".equals(methodDesc)) {
                    methodName = methodName + "," + methodDesc;
                }
                Section section = chapter.addSection(PdfFontUtils.getFont(3, methodName));
                section.setIndentation(10.0f);
                section.setIndentationLeft(10.0f);
                section.setBookmarkOpen(false);
                section.setNumberStyle(1);
                String author = methodModel.getAuthor();
                String createTime = methodModel.getCreateTime();
                String updateTime = methodModel.getUpdateTime();
                if (author == null || "".equals(author)) {
                    author = "\u672a\u8bbe\u7f6e";
                }
                if (createTime == null || "".equals(createTime)) {
                    createTime = "\u672a\u8bbe\u7f6e";
                }
                if (updateTime == null || "".equals(updateTime)) {
                    updateTime = "\u672a\u8bbe\u7f6e";
                }
                section.add((Element)PdfFontUtils.getFont(6, "\u7248\u672c\u53f7\uff1a" + methodModel.getVersion()));
                section.add((Element)PdfFontUtils.getFont(6, "Method Type\uff1a" + methodModel.getRequestType()));
                section.add((Element)PdfFontUtils.getFont(6, "Url\uff1a" + methodModel.getUrl()));
                section.add((Element)PdfFontUtils.getFont(6, "Content Type\uff1a" + methodModel.getContentType()));
                section.add((Element)PdfFontUtils.getFont(6, "Author\uff1a" + author + " CreateTime\uff1a" + createTime + " updateTime\uff1a" + updateTime));
                section.add((Element)PdfFontUtils.getFont(5, "\u8bf7\u6c42\u53c2\u6570"));
                section.add((Element)PdfFontUtils.getFont(6, ""));
                PdfPTable requestTable = new PdfPTable(6);
                requestTable.setWidthPercentage(100.0f);
                requestTable.getDefaultCell().setBorder(0);
                List<ParamModel> paramModels = methodModel.getRequest();
                PdfPCell cell = null;
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u540d\u79f0")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u4f5c\u7528")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u662f\u5426\u5fc5\u987b")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u6570\u636e\u7c7b\u578b")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u53c2\u6570\u7c7b\u578b")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u63cf\u8ff0")));
                requestTable.addCell(cell);
                if (paramModels != null && paramModels.size() > 0) {
                    this.buildRequests(paramModels, "method", cell, requestTable, "req");
                } else {
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u8be5\u63a5\u53e3\u6ca1\u6709\u8bf7\u6c42\u53c2\u6570")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                }
                section.add((Element)requestTable);
                section.add((Element)PdfFontUtils.getFont(5, "\u54cd\u5e94\u53c2\u6570"));
                section.add((Element)PdfFontUtils.getFont(6, ""));
                PdfPTable responseTable = new PdfPTable(4);
                responseTable.setWidthPercentage(100.0f);
                responseTable.getDefaultCell().setBorder(0);
                List<ResposeModel> resposeModels = methodModel.getRespose();
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u540d\u79f0")));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u4f5c\u7528")));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u6570\u636e\u7c7b\u578b")));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u63cf\u8ff0")));
                responseTable.addCell(cell);
                if (resposeModels != null && resposeModels.size() > 0) {
                    ArrayList<String> valueRecord = new ArrayList<String>();
                    this.buildParams(resposeModels, "method", cell, responseTable, "res", valueRecord);
                } else {
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "\u8be5\u63a5\u53e3\u6ca1\u6709\u54cd\u5e94\u53c2\u6570")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    requestTable.addCell(cell);
                }
                section.add((Element)responseTable);
                section.add((Element)PdfFontUtils.getFont(6, ""));
                section.add((Element)PdfFontUtils.getFont(6, ""));
                section.add((Element)PdfFontUtils.getFont(6, ""));
                section.add((Element)PdfFontUtils.getFont(6, ""));
                section.add((Element)PdfFontUtils.getFont(6, ""));
            }
            doc.add((Element)chapter);
        }
        doc.close();
        this.download(projectName + ".pdf", response);
        return null;
    }

    public void download(String path, HttpServletResponse response) {
        try {
            File file = new File(path);
            String filename = file.getName();
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setContentType("application/octet-stream");
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void buildRequests(List<ParamModel> rms, String loc, PdfPCell cell, PdfPTable requestTable, String type) {
        if (rms != null && rms.size() > 0) {
            for (ParamModel resp : rms) {
                ModelModel modelModel;
                String value = resp.getValue();
                boolean array = resp.getArray();
                String name = resp.getName();
                if (!(loc == null || "".equals(loc) || "method".equals(loc) || value == null || "".equals(value))) {
                    value = loc + "." + value;
                }
                if (value == null || "".equals(value)) {
                    value = loc;
                }
                if (array) {
                    value = value + "[]";
                }
                String tValue = value;
                if (value.contains(".")) {
                    int lastIndexOf = value.lastIndexOf(".");
                    String[] split = value.split("[.]");
                    tValue = value.substring(lastIndexOf + 1);
                    for (int len = split.length; len > 1; --len) {
                        tValue = "   " + tValue;
                    }
                }
                if ((modelModel = resp.getModelModel()) == null) {
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getRequired() ? "\u662f" : "\u5426")));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getDataType())));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getParamType())));
                    requestTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getDescription())));
                    requestTable.addCell(cell);
                    continue;
                }
                if ("req".equals(type)) {
                    this.buildPropertys(modelModel.getPropertyModels(), "", cell, requestTable, "reqs");
                }
                if (!"reqs".equals(type)) continue;
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getRequired() ? "\u662f" : "\u5426")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                requestTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getDescription())));
                requestTable.addCell(cell);
                this.buildPropertys(modelModel.getPropertyModels(), value, cell, requestTable, "reqs");
            }
        }
    }

    public void buildParams(List<ResposeModel> rms, String loc, PdfPCell cell, PdfPTable responseTable, String type, List<String> valueRecord) {
        try {
            if (rms != null && rms.size() > 0) {
                for (ResposeModel resp : rms) {
                    String value = resp.getValue();
                    boolean array = resp.getArray();
                    String dataType = resp.getDataType();
                    String name = resp.getName();
                    String description = resp.getDescription();
                    ArrayList<ResposeModel> arr = new ArrayList<ResposeModel>();
                    this.filter(value, rms, arr);
                    if (!(loc == null || "".equals(loc) || "method".equals(loc) || value == null || "".equals(value))) {
                        value = loc + "." + value;
                    }
                    if (value == null || "".equals(value)) {
                        value = loc;
                    }
                    if (array) {
                        value = value + "[]";
                    }
                    String tValue = value;
                    if (value.contains(".")) {
                        int lastIndexOf = value.lastIndexOf(".");
                        String[] split = value.split("[.]");
                        tValue = value.substring(lastIndexOf + 1);
                        for (int len = split.length; len > 1; --len) {
                            tValue = "   " + tValue;
                        }
                    }
                    if (arr != null && arr.size() > 0) {
                        boolean bool = true;
                        if (valueRecord != null && valueRecord.size() > 0) {
                            for (String vr : valueRecord) {
                                if (!vr.equals(value)) continue;
                                bool = false;
                                break;
                            }
                        }
                        if (bool) {
                            cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                            responseTable.addCell(cell);
                            valueRecord.add(value);
                            cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                            responseTable.addCell(cell);
                            cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                            responseTable.addCell(cell);
                            cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, description)));
                            responseTable.addCell(cell);
                        }
                        this.buildParams(arr, value, cell, responseTable, "resp", valueRecord);
                        continue;
                    }
                    ModelModel modelModel = resp.getModelModel();
                    if (modelModel == null) {
                        boolean bool = true;
                        if (valueRecord != null && valueRecord.size() > 0) {
                            for (String vr : valueRecord) {
                                if (!vr.equals(value)) continue;
                                bool = false;
                                break;
                            }
                        }
                        if (!bool) continue;
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                        responseTable.addCell(cell);
                        valueRecord.add(value);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, dataType)));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, description)));
                        responseTable.addCell(cell);
                        continue;
                    }
                    if ("res".equals(type)) {
                        this.buildPropertys(modelModel.getPropertyModels(), "", cell, responseTable, "resps");
                    }
                    if ("resp".equals(type)) {
                        this.buildPropertys(modelModel.getPropertyModels(), value, cell, responseTable, "resps");
                    }
                    if (!"resps".equals(type)) continue;
                    boolean bool = true;
                    if (valueRecord != null && valueRecord.size() > 0) {
                        for (String vr : valueRecord) {
                            if (!vr.equals(value)) continue;
                            bool = false;
                            break;
                        }
                    }
                    if (bool) {
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                        responseTable.addCell(cell);
                        valueRecord.add(value);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, description)));
                        responseTable.addCell(cell);
                    }
                    this.buildPropertys(modelModel.getPropertyModels(), value, cell, responseTable, "resps");
                }
            }
        }
        catch (ConcurrentModificationException e) {
            this.buildParams(rms, loc, cell, responseTable, type, valueRecord);
        }
    }

    public void buildPropertys(List<PropertyModel> rms, String loc, PdfPCell cell, PdfPTable responseTable, String type) {
        if (rms != null && rms.size() > 0) {
            for (PropertyModel resp : rms) {
                ModelModel modelModel;
                String value = resp.getValue();
                boolean array = resp.getArray();
                String dataType = resp.getDataType();
                String name = resp.getName();
                String description = resp.getDescription();
                if (!(loc == null || "".equals(loc) || "method".equals(loc) || value == null || "".equals(value))) {
                    value = loc + "." + value;
                }
                if (value == null || "".equals(value)) {
                    value = loc;
                }
                if (array) {
                    value = value + "[]";
                }
                String tValue = value;
                if (value.contains(".")) {
                    int lastIndexOf = value.lastIndexOf(".");
                    String[] split = value.split("[.]");
                    tValue = value.substring(lastIndexOf + 1);
                    for (int len = split.length; len > 1; --len) {
                        tValue = "   " + tValue;
                    }
                }
                if ((modelModel = resp.getModelModel()) == null) {
                    if ("reqs".equals(type) || "req".equals(type)) {
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getRequired() ? "\u662f" : "\u5426")));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getDataType())));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getParamType())));
                        responseTable.addCell(cell);
                        cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getDescription())));
                        responseTable.addCell(cell);
                        continue;
                    }
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                    responseTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                    responseTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, dataType)));
                    responseTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, description)));
                    responseTable.addCell(cell);
                    continue;
                }
                if ("res".equals(type)) {
                    this.buildPropertys(modelModel.getPropertyModels(), "", cell, responseTable, "resps");
                }
                if ("resp".equals(type)) {
                    this.buildPropertys(modelModel.getPropertyModels(), value, cell, responseTable, "resps");
                }
                if ("resps".equals(type)) {
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                    responseTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                    responseTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                    responseTable.addCell(cell);
                    cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, description)));
                    responseTable.addCell(cell);
                    this.buildPropertys(modelModel.getPropertyModels(), value, cell, responseTable, "resps");
                }
                if (!"reqs".equals(type)) continue;
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, value)));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, name)));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getRequired() ? "\u662f" : "\u5426")));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, "")));
                responseTable.addCell(cell);
                cell = new PdfPCell(new Phrase((Phrase)PdfFontUtils.getFont(6, resp.getDescription())));
                responseTable.addCell(cell);
                this.buildPropertys(modelModel.getPropertyModels(), value, cell, responseTable, "reqs");
            }
        }
    }

    public void filter(String value, List<ResposeModel> rms, List<ResposeModel> arr) {
        if (rms == null || rms.size() == 0 || value == null || "".equals(value)) {
            return;
        }
        Iterator<ResposeModel> iterator = rms.iterator();
        while (iterator.hasNext()) {
            try {
                ResposeModel rm = iterator.next();
                if (!value.equals(rm.getParentName())) continue;
                String var = rm.getValue();
                arr.add(rm);
                iterator.remove();
                this.filter(var, rms, arr);
            }
            catch (Exception e) {
                this.filter(value, rms, arr);
                break;
            }
        }
    }

    public Document createPdf(String outpath) throws Exception {
        Rectangle rect = new Rectangle(PageSize.A4);
        Document doc = new Document(rect);
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(outpath));
        writer.setPdfVersion(PdfWriter.PDF_VERSION_1_2);
        doc.addTitle("Title@lk");
        doc.addAuthor("Author@lk");
        doc.addSubject("Subject@lk");
        doc.addKeywords("Keywords@lk");
        doc.addCreator("Creator@lk");
        doc.setMargins(40.0f, 40.0f, 40.0f, 40.0f);
        doc.open();
        return doc;
    }
}

