/*
 * Decompiled with CFR 0.152.
 */
package com.lk.api.controller;

import com.lk.api.annotation.ApiModel;
import com.lk.api.annotation.ApiModelProperty;
import com.lk.api.annotation.LKADocument;
import com.lk.api.annotation.LKAModel;
import com.lk.api.annotation.LKAProperty;
import com.lk.api.controller.JsonUtils;
import com.lk.api.domain.MethodModel;
import com.lk.api.domain.ModelModel;
import com.lk.api.domain.ParamModel;
import com.lk.api.domain.PropertyModel;
import com.lk.api.domain.ResposeModel;
import com.lk.api.domain.TypeModel;
import com.lk.api.utils.TypeCls;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@RestController
@RequestMapping(value={"lkad"})
public class LKADController {
    @Autowired
    private WebApplicationContext applicationContext;
    @Value(value="${lkad.basePackages:}")
    private String basePackages;
    @Value(value="${lkad.projectName:lkadoc\u63a5\u53e3\u6587\u6863}")
    private String projectName;
    @Value(value="${lkad.description:\u667a\u80fd\u3001\u4fbf\u6377\u3001\u9ad8\u6548\uff01}")
    private String description;
    @Value(value="${lkad.enabled:true}")
    private Boolean enabled;
    @Value(value="${lkad.serverNames:}")
    private String serverNames;
    @Value(value="${lkad.version:}")
    private String version;
    @Value(value="${lkad.sconAll:false}")
    private Boolean sconAll;
    @Value(value="${lkad.password:}")
    private String password;
    @Value(value="${lkad.classNum:5000}")
    private String classNum;
    private int reqNum = 0;
    private int respNum = 0;
    private int proNum = 0;
    private Set<Map.Entry<Object, Object>> entrySet = null;

    @GetMapping(value={"getServerApi"})
    public Object getServerApi(String path, String contentType, String headerJson, String queryData, String type) {
        HttpEntity requestEntity;
        Map<String, Object> headerMap = JsonUtils.toMap(headerJson);
        Map<String, Object> queryMap = JsonUtils.toMap(queryData);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders requestHeaders = new HttpHeaders();
        Set<String> hSet = headerMap.keySet();
        for (String key : hSet) {
            requestHeaders.add(key, headerMap.get(key) == null ? "" : headerMap.get(key).toString());
        }
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(new ByteArrayHttpMessageConverter());
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter(Charset.forName("UTF-8"));
        messageConverters.add(stringHttpMessageConverter);
        messageConverters.add(new ResourceHttpMessageConverter());
        messageConverters.add(new SourceHttpMessageConverter());
        messageConverters.add(new AllEncompassingFormHttpMessageConverter());
        restTemplate.setMessageConverters(messageConverters);
        ResponseEntity object = null;
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        Set<String> qSet = queryMap.keySet();
        String data = "";
        int i = 0;
        for (String key : qSet) {
            requestBody.add((Object)key, (Object)(queryMap.get(key) == null ? "" : queryMap.get(key).toString()));
            data = i == 0 ? "?" + key + "=" + queryMap.get(key) : data + "&" + key + "=" + queryMap.get(key);
            ++i;
        }
        if ("application/json".equals(contentType)) {
            requestEntity = new HttpEntity((Object)queryData, (MultiValueMap)requestHeaders);
            if ("get".equals(type.toLowerCase())) {
                return "<span style='color:red'>ContentType\u503c\u4e3aapplication/json\u65f6\u53ea\u652f\u6301post\u3001put\u3001delete\u8bf7\u6c42\uff01<span>";
            }
            if ("post".equals(type.toLowerCase())) {
                object = restTemplate.exchange(path, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            }
            if ("put".equals(type.toLowerCase())) {
                object = restTemplate.exchange(path, HttpMethod.PUT, requestEntity, String.class, new Object[0]);
            }
            if ("delete".equals(type.toLowerCase())) {
                object = restTemplate.exchange(path, HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
            }
        } else {
            requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)requestHeaders);
            if ("get".equals(type.toLowerCase())) {
                object = restTemplate.exchange(path + data, HttpMethod.GET, null, String.class, new Object[0]);
            }
            if ("post".equals(type.toLowerCase())) {
                object = restTemplate.exchange(path, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            }
            if ("put".equals(type.toLowerCase())) {
                object = restTemplate.exchange(path, HttpMethod.PUT, requestEntity, String.class, new Object[0]);
            }
            if ("delete".equals(type.toLowerCase())) {
                object = restTemplate.exchange(path, HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
            }
        }
        return object;
    }

    @GetMapping(value={"isPwd"})
    public int isPwd() {
        Map beans;
        if ("".equals(this.basePackages) && (beans = this.applicationContext.getBeansWithAnnotation(LKADocument.class)) != null && beans.size() > 0) {
            Set keySet = beans.keySet();
            for (String key : keySet) {
                Object obj = beans.get(key);
                Class<?> bootClass = obj.getClass();
                LKADocument annotation = bootClass.getAnnotation(LKADocument.class);
                this.password = annotation.password();
            }
        }
        if (this.password == null || "".equals(this.password)) {
            return 0;
        }
        return 1;
    }

    @GetMapping(value={"doc"})
    public Map<String, Object> loadLKADocument(String serverName, String pwd, int type) throws Exception {
        List<TypeModel> typeModels;
        String bpk = "";
        Map<String, Object> map = new HashMap<String, Object>();
        if (serverName != null && !"".equals(serverName)) {
            RestTemplate restTemplate = new RestTemplate();
            try {
                map = (Map)restTemplate.getForObject(serverName + "/lkad/doc?pwd=" + pwd + "&type=" + type, Map.class, new Object[0]);
                return map;
            }
            catch (Exception e) {
                map.put("error", serverName + "\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25\uff01");
                return map;
            }
        }
        if (!"".equals(this.basePackages)) {
            bpk = this.basePackages;
            map.put("projectName", this.projectName);
            map.put("description", this.description);
            map.put("enabled", this.enabled != false ? "yes" : "no");
            map.put("serverNames", this.serverNames);
            map.put("version", this.version);
            if (!this.enabled.booleanValue()) {
                map.put("error", "Lkadoc\u63a5\u53e3\u6587\u6863\u529f\u80fd\u5df2\u5173\u95ed");
                return map;
            }
        } else {
            Set keySet;
            Iterator iterator;
            Map beans = this.applicationContext.getBeansWithAnnotation(LKADocument.class);
            boolean bool = false;
            if (beans != null && beans.size() > 0 && (iterator = (keySet = beans.keySet()).iterator()).hasNext()) {
                String key = (String)iterator.next();
                Object obj = beans.get(key);
                Class<?> bootClass = obj.getClass();
                LKADocument annotation = bootClass.getAnnotation(LKADocument.class);
                bpk = annotation.basePackages();
                this.sconAll = annotation.sconAll();
                this.classNum = annotation.classNum();
                if ("".equals(bpk)) {
                    bool = false;
                } else {
                    map.put("projectName", annotation.projectName());
                    map.put("description", annotation.description());
                    map.put("serverNames", annotation.serverNames());
                    map.put("enabled", annotation.enabled() ? "yes" : "no");
                    map.put("version", annotation.version());
                    this.password = annotation.password();
                    if (!annotation.enabled()) {
                        bpk = "";
                        map.put("error", "Lkadoc\u63a5\u53e3\u6587\u6863\u529f\u80fd\u5df2\u5173\u95ed");
                        return map;
                    }
                    bool = true;
                }
            }
            if (!bool) {
                bpk = "";
                map.put("error", "\u6ca1\u6709\u8bbe\u7f6e\u8981\u626b\u63cf\u7684\u5305\u8def\u5f84");
                return map;
            }
        }
        if (this.password != null && !"".equals(this.password) && type == 1 && !this.password.equals(pwd)) {
            bpk = "";
            map.put("error", "\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u60a8\u65e0\u6743\u64cd\u4f5c\u6587\u6863");
            return map;
        }
        try {
            typeModels = this.scanType(bpk.split(","));
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
            e.printStackTrace();
            return map;
        }
        Collections.sort(typeModels);
        ArrayList<MethodModel> tempMethod = new ArrayList<MethodModel>();
        for (TypeModel typeModel : typeModels) {
            List<MethodModel> methods = typeModel.getMethodModels();
            Iterator<MethodModel> iterator = methods.iterator();
            while (iterator.hasNext()) {
                MethodModel method = iterator.next();
                List<ResposeModel> ResposeModels = method.getRespose();
                ArrayList<ResposeModel> rms = new ArrayList<ResposeModel>();
                ArrayList<ResposeModel> rms2 = new ArrayList<ResposeModel>();
                for (ResposeModel m : ResposeModels) {
                    if (m.getParentName() == null || "".equals(m.getParentName())) {
                        rms.add(m);
                        continue;
                    }
                    rms2.add(m);
                }
                int n = 0;
                this.sortResposeModel(rms, rms2, n);
                method.setRespose(rms);
                if ("".equals(method.getDirectory())) continue;
                tempMethod.add(method);
                iterator.remove();
            }
        }
        for (TypeModel typeModel : typeModels) {
            Iterator iterator = tempMethod.iterator();
            while (iterator.hasNext()) {
                MethodModel methodModel = (MethodModel)iterator.next();
                if (!typeModel.getName().equals(methodModel.getDirectory())) continue;
                List<MethodModel> methodModels = typeModel.getMethodModels();
                methodModels.add(methodModel);
                iterator.remove();
            }
            Collections.sort(typeModel.getMethodModels());
        }
        map.put("apiDoc", typeModels);
        return map;
    }

    public void sortResposeModel(List<ResposeModel> rms, List<ResposeModel> rms2, int n) {
        if (rms2 == null || rms2.size() < 1 || ++n == 20) {
            return;
        }
        Iterator<ResposeModel> iterator = rms2.iterator();
        block0: while (iterator.hasNext()) {
            ResposeModel next = iterator.next();
            for (ResposeModel m : rms) {
                if (!m.getValue().equals(next.getParentName())) continue;
                rms.add(next);
                iterator.remove();
                continue block0;
            }
        }
        this.sortResposeModel(rms, rms2, n);
    }

    public List<File> getFile(String[] basePackages) {
        ArrayList<File> packageFiles = new ArrayList<File>();
        for (String basePackage : basePackages) {
            String path = basePackage.replace(".", "/");
            URL url = this.getClass().getClassLoader().getResource(path);
            if (url == null) {
                return null;
            }
            path = url.getPath().replace("!", "");
            File packageFile = new File(path);
            packageFiles.add(packageFile);
        }
        return packageFiles;
    }

    public List<File> queryFiles(File baseFile) {
        File[] files = baseFile.listFiles();
        ArrayList<File> allFiles = new ArrayList<File>();
        if (files == null || files.length < 1) {
            return null;
        }
        for (File file : files) {
            if (file == null || file.getName() == null) continue;
            if (file.isDirectory()) {
                List<File> queryFiles = this.queryFiles(file);
                if (queryFiles == null) {
                    return allFiles;
                }
                allFiles.addAll(queryFiles);
                continue;
            }
            allFiles.add(file);
        }
        return allFiles;
    }

    /*
     * Exception decompiling
     */
    public List<TypeModel> scanType(String[] basePackages) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [112[CATCHBLOCK]], but top level block is 646[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Map<String, Object>> getMethodURL() {
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean(RequestMappingHandlerMapping.class);
        Map map = requestMappingHandlerMapping.getHandlerMethods();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (map == null || map.entrySet() == null) {
            return resultList;
        }
        for (Map.Entry mappingInfoHandlerMethodEntry : map.entrySet()) {
            RequestMethodsRequestCondition methodsCondition;
            PatternsRequestCondition p;
            Annotation[] parentAnnotations;
            LinkedHashMap<String, Object> resultMap = new LinkedHashMap<String, Object>();
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)mappingInfoHandlerMethodEntry.getKey();
            HandlerMethod handlerMethod = (HandlerMethod)mappingInfoHandlerMethodEntry.getValue();
            if (requestMappingInfo == null || handlerMethod == null || handlerMethod.getMethod() == null || handlerMethod.getMethod().getDeclaringClass() == null) continue;
            resultMap.put("className", handlerMethod.getMethod().getDeclaringClass().getName());
            Class<?>[] interfaces = handlerMethod.getMethod().getDeclaringClass().getInterfaces();
            ArrayList<String> interfacesNames = new ArrayList<String>();
            if (interfaces != null) {
                for (Class<?> c : interfaces) {
                    interfacesNames.add(c.getName());
                }
            }
            resultMap.put("interfacesNames", interfacesNames);
            if (handlerMethod.getBeanType() != null && (parentAnnotations = handlerMethod.getBeanType().getAnnotations()) != null && parentAnnotations.length > 0) {
                for (Annotation annotation : parentAnnotations) {
                    RequestMapping requestMapping;
                    if (!(annotation instanceof RequestMapping) || null == (requestMapping = (RequestMapping)annotation).value() || requestMapping.value().length <= 0) continue;
                    resultMap.put("classURL", requestMapping.value()[0]);
                }
            }
            resultMap.put("methodName", handlerMethod.getMethod().getName());
            Parameter[] parameters = handlerMethod.getMethod().getParameters();
            if (parameters != null && parameters.length > 0) {
                resultMap.put("params", parameters);
            }
            if ((p = requestMappingInfo.getPatternsCondition()) != null && p.getPatterns() != null) {
                for (String url : p.getPatterns()) {
                    resultMap.put("methodURL", url);
                }
            }
            if ((methodsCondition = requestMappingInfo.getMethodsCondition()) != null && methodsCondition.getMethods() != null) {
                for (RequestMethod requestMethod : methodsCondition.getMethods()) {
                    if (requestMethod == null) continue;
                    resultMap.put("requestType", requestMethod.toString());
                }
            }
            resultList.add(resultMap);
        }
        return resultList;
    }

    public ParamModel analysisModel(String url, Class<?> typeCls, String group) throws Exception {
        Field[] declaredField;
        LKAModel lkaModel;
        ++this.reqNum;
        if (this.reqNum > 10) {
            this.reqNum = 0;
            return null;
        }
        if (!typeCls.isAnnotationPresent(LKAModel.class) && !typeCls.isAnnotationPresent(ApiModel.class)) {
            this.reqNum = 0;
            return null;
        }
        ParamModel pm = new ParamModel();
        ModelModel modelModel = new ModelModel();
        if (typeCls.isAnnotationPresent(LKAModel.class)) {
            lkaModel = typeCls.getAnnotation(LKAModel.class);
            modelModel.setValue(typeCls.getSimpleName());
            modelModel.setName(lkaModel.value());
            modelModel.setDescription(lkaModel.description());
        } else {
            lkaModel = typeCls.getAnnotation(ApiModel.class);
            modelModel.setValue(typeCls.getSimpleName());
            modelModel.setName(lkaModel.value());
            modelModel.setDescription(lkaModel.description());
        }
        Field[] fields = typeCls.getDeclaredFields();
        try {
            declaredField = this.getDeclaredField(typeCls.newInstance());
        }
        catch (Exception e) {
            declaredField = null;
        }
        Object[] arrays = null;
        if (declaredField != null) {
            ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(declaredField));
            arrays = list.toArray();
        } else {
            arrays = fields;
        }
        if (arrays != null && arrays.length > 0) {
            ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
            for (Object obj : arrays) {
                String[] split2;
                String[] split;
                PropertyModel propertyModel;
                String[] pValue;
                Class ctype;
                String[] gs;
                String[] groups;
                boolean bool;
                LKAProperty param;
                Field field = (Field)obj;
                String name = field.getName();
                Class<?> type = field.getType();
                if (!field.isAnnotationPresent(LKAProperty.class) && !field.isAnnotationPresent(ApiModelProperty.class)) {
                    if (!this.sconAll.booleanValue()) continue;
                    PropertyModel propertyModel2 = new PropertyModel();
                    int isArray = this.isObj(type);
                    if ((type = this.getGenericType(type, field).getCls()) == null) {
                        type = field.getType();
                    }
                    propertyModel2.setDataType(type.getSimpleName());
                    int flag = this.isObj(type);
                    if (flag == 3 && (propertyModel2 = this.analysisProModel(url, type, "", 1, null)) == null) {
                        propertyModel2 = new PropertyModel();
                        propertyModel2.setDataType("Object");
                    }
                    propertyModel2.setArray(false);
                    if (isArray == 2 || isArray == 4) {
                        propertyModel2.setArray(true);
                        propertyModel2.setDataType(propertyModel2.getDataType() + "[]");
                    }
                    propertyModel2.setName(this.enToCn(url, 1, name));
                    propertyModel2.setValue(name);
                    propertyModel2.setRequired(false);
                    propertyModel2.setDescription("");
                    propertyModel2.setTestData("");
                    try {
                        if (type.isAnnotationPresent(PathVariable.class)) {
                            propertyModel2.setParamType("path");
                        } else if (type.isAnnotationPresent(RequestHeader.class)) {
                            propertyModel2.setParamType("header");
                        } else {
                            propertyModel2.setParamType("query");
                        }
                    }
                    catch (Exception e) {
                        propertyModel2.setParamType("query");
                    }
                    propertyModels.add(propertyModel2);
                    continue;
                }
                boolean bool2 = false;
                if (field.isAnnotationPresent(LKAProperty.class)) {
                    param = field.getAnnotation(LKAProperty.class);
                    if (param.hidden()) continue;
                    bool = false;
                    if (group != null && !"".equals(group)) {
                        groups = param.groups();
                        if (groups != null && groups.length > 0) {
                            for (String gst : groups) {
                                if (gst == null || (gs = gst.split("-")) == null || gs[0] == null || "".equals(gs[0]) || !gs[0].equals(group)) continue;
                                if (gs.length > 1 && gs[1].equals("n")) {
                                    bool2 = true;
                                }
                                bool = true;
                                break;
                            }
                        }
                        if (!bool) continue;
                    }
                    ctype = param.type();
                    pValue = field.getName();
                    Class<?> pType = field.getType();
                    Class<?> gType = this.getGenericType(pType, field).getCls();
                    if (gType == null) {
                        gType = pType;
                    }
                    propertyModel = new PropertyModel();
                    if (ctype.getName() != "java.lang.Object" || this.isObj(gType) == 3) {
                        propertyModel = ctype.getName() != "java.lang.Object" ? this.analysisProModel(url, ctype, group, 1, null) : this.analysisProModel(url, gType, group, 1, null);
                        if (propertyModel == null) {
                            propertyModel = new PropertyModel();
                            propertyModel.setDataType("Object");
                        }
                        propertyModel.setArray(param.isArray());
                        if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                            propertyModel.setArray(true);
                        }
                        propertyModel.setValue((String)pValue);
                        propertyModel.setName(param.value());
                        propertyModel.setDescription(param.description());
                        propertyModels.add(propertyModel);
                        continue;
                    }
                    propertyModel.setDataType(pType.getSimpleName());
                    propertyModel.setDescription(param.description());
                    propertyModel.setName(param.value());
                    propertyModel.setTestData(param.testData());
                    split = param.value().split("\\^");
                    if (split.length == 2) {
                        propertyModel.setName(split[0]);
                        propertyModel.setTestData(split[1]);
                    }
                    if ((split2 = split[0].split("\\~")).length == 2) {
                        propertyModel.setName(split2[1]);
                        if (split2[0].contains("n")) {
                            propertyModel.setRequired(false);
                        }
                    }
                    if (bool) {
                        propertyModel.setRequired(true);
                    }
                    if (bool2) {
                        propertyModel.setRequired(false);
                    }
                    propertyModel.setParamType("query");
                    propertyModel.setArray(param.isArray());
                    if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                        propertyModel.setArray(true);
                    }
                    propertyModel.setValue((String)pValue);
                    propertyModels.add(propertyModel);
                    continue;
                }
                param = field.getAnnotation(ApiModelProperty.class);
                if (param.hidden()) continue;
                bool = false;
                if (group != null && !"".equals(group)) {
                    groups = param.groups();
                    if (groups != null && groups.length > 0) {
                        for (String gst : groups) {
                            if (gst == null || (gs = gst.split("-")) == null || gs[0] == null || "".equals(gs[0]) || !gs[0].equals(group)) continue;
                            if (gs.length > 1 && gs[1].equals("n")) {
                                bool2 = true;
                            }
                            bool = true;
                            break;
                        }
                    }
                    if (!bool) continue;
                }
                ctype = param.type();
                pValue = field.getName();
                Class<?> pType = field.getType();
                Class<?> gType = this.getGenericType(pType, field).getCls();
                if (gType == null) {
                    gType = pType;
                }
                propertyModel = new PropertyModel();
                if (ctype.getName() != "java.lang.Object" || this.isObj(gType) == 3) {
                    propertyModel = ctype.getName() != "java.lang.Object" ? this.analysisProModel(url, ctype, group, 1, null) : this.analysisProModel(url, gType, group, 1, null);
                    if (propertyModel == null) {
                        propertyModel = new PropertyModel();
                        propertyModel.setDataType("Object");
                    }
                    propertyModel.setArray(param.isArray());
                    if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                        propertyModel.setArray(true);
                    }
                    propertyModel.setValue((String)pValue);
                    propertyModel.setName(param.value());
                    propertyModel.setDescription(param.description());
                    propertyModels.add(propertyModel);
                    continue;
                }
                propertyModel.setDataType(pType.getSimpleName());
                propertyModel.setDescription(param.description());
                propertyModel.setName(param.value());
                propertyModel.setTestData(param.testData());
                split = param.value().split("\\^");
                if (split.length == 2) {
                    propertyModel.setName(split[0]);
                    propertyModel.setTestData(split[1]);
                }
                if ((split2 = split[0].split("\\~")).length == 2) {
                    propertyModel.setName(split2[1]);
                    if (split2[0].contains("n")) {
                        propertyModel.setRequired(false);
                    }
                }
                if (bool) {
                    propertyModel.setRequired(true);
                }
                if (bool2) {
                    propertyModel.setRequired(false);
                }
                propertyModel.setParamType("query");
                propertyModel.setArray(param.isArray());
                if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                    propertyModel.setArray(true);
                }
                propertyModel.setValue((String)pValue);
                propertyModels.add(propertyModel);
            }
            modelModel.setPropertyModels(propertyModels);
        }
        pm.setModelModel(modelModel);
        this.reqNum = 0;
        return pm;
    }

    public PropertyModel analysisProModel(String url, Class<?> typeCls, String group, Integer proType, Class<?> ... proCls) throws Exception {
        Field[] declaredField;
        LKAModel lkaModel;
        ++this.proNum;
        if (this.proNum > 10) {
            this.proNum = 0;
            return null;
        }
        if (!typeCls.isAnnotationPresent(LKAModel.class) && !typeCls.isAnnotationPresent(ApiModel.class)) {
            this.proNum = 0;
            return null;
        }
        PropertyModel pm = new PropertyModel();
        ModelModel modelModel = new ModelModel();
        if (typeCls.isAnnotationPresent(LKAModel.class)) {
            lkaModel = typeCls.getAnnotation(LKAModel.class);
            modelModel.setValue(typeCls.getSimpleName());
            modelModel.setName(lkaModel.value());
            modelModel.setDescription(lkaModel.description());
        } else {
            lkaModel = typeCls.getAnnotation(ApiModel.class);
            modelModel.setValue(typeCls.getSimpleName());
            modelModel.setName(lkaModel.value());
            modelModel.setDescription(lkaModel.description());
        }
        Field[] fields = typeCls.getDeclaredFields();
        try {
            declaredField = this.getDeclaredField(typeCls.newInstance());
        }
        catch (Exception e) {
            declaredField = null;
        }
        Object[] arrays = null;
        if (declaredField != null) {
            ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(declaredField));
            arrays = list.toArray();
        } else {
            arrays = fields;
        }
        if (arrays != null && arrays.length > 0) {
            ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
            for (Object obj : arrays) {
                Field field = (Field)obj;
                if (field.isAnnotationPresent(LKAProperty.class) || field.isAnnotationPresent(ApiModelProperty.class)) {
                    String[] split2;
                    ApiModelProperty param;
                    boolean bool2 = false;
                    ApiModelProperty groups = null;
                    Class ctype = null;
                    boolean paramIsArr = false;
                    String paramValue = "";
                    String paramDescription = "";
                    String paramTestData = "";
                    boolean bool = false;
                    if (field.isAnnotationPresent(LKAProperty.class)) {
                        param = field.getAnnotation(LKAProperty.class);
                        if (param.hidden()) continue;
                        paramIsArr = param.isArray();
                        ctype = param.type();
                        groups = param.groups();
                        paramValue = param.value();
                        paramDescription = param.description();
                        paramTestData = param.testData();
                    } else {
                        param = field.getAnnotation(ApiModelProperty.class);
                        if (param.hidden()) continue;
                        paramIsArr = param.isArray();
                        ctype = param.type();
                        groups = param.groups();
                        paramValue = param.value();
                        paramDescription = param.description();
                        paramTestData = param.testData();
                    }
                    if (group != null && !"".equals(group)) {
                        if (groups != null && ((String[])groups).length > 0) {
                            for (String gst : groups) {
                                String[] gs;
                                if (gst == null || (gs = gst.split("-")) == null || gs[0] == null || "".equals(gs[0]) || !gs[0].equals(group)) continue;
                                if (gs.length > 1 && gs[1].equals("n")) {
                                    bool2 = true;
                                }
                                bool = true;
                                break;
                            }
                        }
                        if (!bool) continue;
                    }
                    String pValue = field.getName();
                    Class<?> pType = field.getType();
                    Class<?> gType = this.getGenericType(pType, field).getCls();
                    PropertyModel propertyModel = new PropertyModel();
                    if (ctype.getName() != "java.lang.Object" || this.isObj(gType) == 3) {
                        if (ctype.getName() != "java.lang.Object") {
                            propertyModel = this.analysisProModel(url, ctype, group, proType, null);
                        } else {
                            if (gType == null || "Object".equals(gType.getSimpleName())) {
                                if (proCls != null) {
                                    if (proCls != null && proCls.length > 0 && proCls[0] != null) {
                                        int i;
                                        Class[] proCls2;
                                        gType = proCls[0];
                                        boolean isArr = false;
                                        if (this.isObj(gType) == 2 || this.isObj(gType) == 4) {
                                            try {
                                                gType = proCls[1];
                                                paramIsArr = isArr = true;
                                            }
                                            catch (Exception e) {
                                                gType = proCls[0];
                                            }
                                        }
                                        if (!isArr) {
                                            if (proCls.length > 1) {
                                                proCls2 = new Class[proCls.length - 1];
                                                for (i = 0; i < proCls.length - 1 && proCls[i + 1] != null; ++i) {
                                                    proCls2[i] = proCls[i + 1];
                                                }
                                                proCls = proCls2;
                                            }
                                        } else if (proCls.length > 2) {
                                            proCls2 = new Class[proCls.length - 2];
                                            for (i = 0; i < proCls.length - 2 && proCls[i + 2] != null; ++i) {
                                                proCls2[i] = proCls[i + 2];
                                            }
                                            proCls = proCls2;
                                        }
                                    }
                                } else {
                                    gType = pType;
                                }
                            }
                            propertyModel = this.analysisProModel(url, gType, group, proType, proCls);
                        }
                        if (propertyModel == null) {
                            propertyModel = new PropertyModel();
                        }
                        propertyModel.setArray(paramIsArr);
                        if (!paramIsArr && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                            propertyModel.setArray(true);
                        }
                        propertyModel.setValue(pValue);
                        propertyModel.setName(paramValue);
                        propertyModel.setDescription(paramDescription);
                        propertyModel.setDataType("Object");
                        propertyModels.add(propertyModel);
                        continue;
                    }
                    propertyModel.setDataType(pType.getSimpleName());
                    propertyModel.setDescription(paramDescription);
                    propertyModel.setName(paramValue);
                    propertyModel.setTestData(paramTestData);
                    String[] split = paramValue.split("\\^");
                    if (split.length == 2) {
                        propertyModel.setName(split[0]);
                        propertyModel.setTestData(split[1]);
                    }
                    if ((split2 = split[0].split("\\~")).length == 2) {
                        propertyModel.setName(split2[1]);
                        if (split2[0].contains("n")) {
                            propertyModel.setRequired(false);
                        }
                    }
                    if (bool) {
                        propertyModel.setRequired(true);
                    }
                    if (bool2) {
                        propertyModel.setRequired(false);
                    }
                    propertyModel.setParamType("query");
                    propertyModel.setArray(paramIsArr);
                    if (!paramIsArr && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                        propertyModel.setArray(true);
                    }
                    propertyModel.setValue(pValue);
                    propertyModels.add(propertyModel);
                    continue;
                }
                if (!this.sconAll.booleanValue()) continue;
                Class<?> type = field.getType();
                PropertyModel propertyModel = new PropertyModel();
                int isArray = this.isObj(type);
                if ((type = this.getGenericType(type, field).getCls()) == null) {
                    type = field.getType();
                }
                propertyModel.setDataType(type.getSimpleName());
                int flag = this.isObj(type);
                if (flag == 3 && (propertyModel = this.analysisProModel(url, type, "", proType, null)) == null) {
                    propertyModel = new PropertyModel();
                    propertyModel.setDataType("Object");
                }
                String name = field.getName();
                propertyModel.setArray(false);
                if (isArray == 2 || isArray == 4) {
                    propertyModel.setDataType(propertyModel.getDataType() + "[]");
                }
                propertyModel.setName(this.enToCn(url, proType, name));
                propertyModel.setValue(name);
                propertyModel.setRequired(false);
                propertyModel.setDescription("");
                propertyModel.setTestData("");
                try {
                    if (type.isAnnotationPresent(PathVariable.class)) {
                        propertyModel.setParamType("path");
                    } else if (type.isAnnotationPresent(RequestHeader.class)) {
                        propertyModel.setParamType("header");
                    } else {
                        propertyModel.setParamType("query");
                    }
                }
                catch (Exception e) {
                    propertyModel.setParamType("query");
                }
                propertyModels.add(propertyModel);
            }
            modelModel.setPropertyModels(propertyModels);
        }
        pm.setModelModel(modelModel);
        this.proNum = 0;
        return pm;
    }

    public ResposeModel analysisResModel(String url, Class<?> typeCls, String group) throws Exception {
        Field[] declaredField;
        LKAModel lkaModel;
        ++this.respNum;
        if (this.respNum > 10) {
            this.respNum = 0;
            return null;
        }
        if (!typeCls.isAnnotationPresent(LKAModel.class) && !typeCls.isAnnotationPresent(ApiModel.class)) {
            this.respNum = 0;
            return null;
        }
        ResposeModel rm = new ResposeModel();
        ModelModel modelModel = new ModelModel();
        if (typeCls.isAnnotationPresent(LKAModel.class)) {
            lkaModel = typeCls.getAnnotation(LKAModel.class);
            modelModel.setValue(typeCls.getSimpleName());
            modelModel.setName(lkaModel.value());
            modelModel.setDescription(lkaModel.description());
        } else {
            lkaModel = typeCls.getAnnotation(ApiModel.class);
            modelModel.setValue(typeCls.getSimpleName());
            modelModel.setName(lkaModel.value());
            modelModel.setDescription(lkaModel.description());
        }
        Field[] fields = typeCls.getDeclaredFields();
        try {
            declaredField = this.getDeclaredField(typeCls.newInstance());
        }
        catch (Exception e) {
            declaredField = null;
        }
        Object[] arrays = null;
        if (declaredField != null) {
            ArrayList<Field> list = new ArrayList<Field>(Arrays.asList(declaredField));
            arrays = list.toArray();
        } else {
            arrays = fields;
        }
        if (arrays != null && arrays.length > 0) {
            ArrayList<PropertyModel> propertyModels = new ArrayList<PropertyModel>();
            for (Object obj : arrays) {
                String[] split2;
                String[] split;
                PropertyModel propertyModel;
                Class ctype;
                String[] gs;
                String[] groups;
                boolean bool;
                LKAProperty param;
                Field field = (Field)obj;
                if (!field.isAnnotationPresent(LKAProperty.class) && !field.isAnnotationPresent(ApiModelProperty.class)) {
                    if (!this.sconAll.booleanValue()) continue;
                    Class<?> type = field.getType();
                    PropertyModel propertyModel2 = new PropertyModel();
                    int isArray = this.isObj(type);
                    if ((type = this.getGenericType(type, field).getCls()) == null) {
                        type = field.getType();
                    }
                    propertyModel2.setDataType(type.getSimpleName());
                    int flag = this.isObj(type);
                    if (flag == 3 && (propertyModel2 = this.analysisProModel(url, type, "", 2, null)) == null) {
                        propertyModel2 = new PropertyModel();
                        propertyModel2.setDataType("Object");
                    }
                    String string = field.getName();
                    propertyModel2.setArray(false);
                    if (isArray == 2 || isArray == 4) {
                        propertyModel2.setDataType(propertyModel2.getDataType() + "[]");
                    }
                    propertyModel2.setName(this.enToCn(url, 2, string));
                    propertyModel2.setValue(string);
                    propertyModel2.setRequired(false);
                    propertyModel2.setDescription("");
                    propertyModel2.setTestData("");
                    try {
                        if (type.isAnnotationPresent(PathVariable.class)) {
                            propertyModel2.setParamType("path");
                        } else if (type.isAnnotationPresent(RequestHeader.class)) {
                            propertyModel2.setParamType("header");
                        } else {
                            propertyModel2.setParamType("query");
                        }
                    }
                    catch (Exception e) {
                        propertyModel2.setParamType("query");
                    }
                    propertyModels.add(propertyModel2);
                    continue;
                }
                boolean bool2 = false;
                if (field.isAnnotationPresent(LKAProperty.class)) {
                    param = field.getAnnotation(LKAProperty.class);
                    if (param.hidden()) continue;
                    bool = false;
                    if (group != null && !"".equals(group)) {
                        groups = param.groups();
                        if (groups != null && groups.length > 0) {
                            for (String gst : groups) {
                                if (gst == null || (gs = gst.split("-")) == null || gs[0] == null || "".equals(gs[0]) || !gs[0].equals(group)) continue;
                                if (gs.length > 1 && gs[1].equals("n")) {
                                    bool2 = true;
                                }
                                bool = true;
                                break;
                            }
                        }
                        if (!bool) continue;
                    }
                    ctype = param.type();
                    String string = field.getName();
                    Class<?> pType = field.getType();
                    Class<?> gType = this.getGenericType(pType, field).getCls();
                    if (gType == null) {
                        gType = pType;
                    }
                    propertyModel = new PropertyModel();
                    if (ctype.getName() != "java.lang.Object" || this.isObj(gType) == 3) {
                        propertyModel = ctype.getName() != "java.lang.Object" ? this.analysisProModel(url, ctype, group, 2, null) : this.analysisProModel(url, gType, group, 2, null);
                        if (propertyModel == null) {
                            propertyModel = new PropertyModel();
                            propertyModel.setDataType("Object");
                        }
                        propertyModel.setArray(param.isArray());
                        if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                            propertyModel.setArray(true);
                        }
                        propertyModel.setValue(string);
                        propertyModel.setName(param.value());
                        propertyModel.setDescription(param.description());
                        propertyModels.add(propertyModel);
                        continue;
                    }
                    propertyModel.setDataType(pType.getSimpleName());
                    propertyModel.setDescription(param.description());
                    propertyModel.setName(param.value());
                    propertyModel.setTestData(param.testData());
                    split = param.value().split("\\^");
                    if (split.length == 2) {
                        propertyModel.setName(split[0]);
                        propertyModel.setTestData(split[1]);
                    }
                    if ((split2 = split[0].split("\\~")).length == 2) {
                        propertyModel.setName(split2[1]);
                        if (split2[0].contains("n")) {
                            propertyModel.setRequired(false);
                        }
                    }
                    if (bool) {
                        propertyModel.setRequired(true);
                    }
                    if (bool2) {
                        propertyModel.setRequired(false);
                    }
                    propertyModel.setParamType("query");
                    propertyModel.setArray(param.isArray());
                    if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                        propertyModel.setArray(true);
                    }
                    propertyModel.setValue(string);
                    propertyModels.add(propertyModel);
                    continue;
                }
                param = field.getAnnotation(ApiModelProperty.class);
                if (param.hidden()) continue;
                bool = false;
                if (group != null && !"".equals(group)) {
                    groups = param.groups();
                    if (groups != null && groups.length > 0) {
                        for (String gst : groups) {
                            if (gst == null || (gs = gst.split("-")) == null || gs[0] == null || "".equals(gs[0]) || !gs[0].equals(group)) continue;
                            if (gs.length > 1 && gs[1].equals("n")) {
                                bool2 = true;
                            }
                            bool = true;
                            break;
                        }
                    }
                    if (!bool) continue;
                }
                ctype = param.type();
                String string = field.getName();
                Class<?> pType = field.getType();
                Class<?> gType = this.getGenericType(pType, field).getCls();
                if (gType == null) {
                    gType = pType;
                }
                propertyModel = new PropertyModel();
                if (ctype.getName() != "java.lang.Object" || this.isObj(gType) == 3) {
                    propertyModel = ctype.getName() != "java.lang.Object" ? this.analysisProModel(url, ctype, group, 2, null) : this.analysisProModel(url, gType, group, 2, null);
                    if (propertyModel == null) {
                        propertyModel = new PropertyModel();
                        propertyModel.setDataType("Object");
                    }
                    propertyModel.setArray(param.isArray());
                    if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                        propertyModel.setArray(true);
                    }
                    propertyModel.setValue(string);
                    propertyModel.setName(param.value());
                    propertyModel.setDescription(param.description());
                    propertyModels.add(propertyModel);
                    continue;
                }
                propertyModel.setDataType(pType.getSimpleName());
                propertyModel.setDescription(param.description());
                propertyModel.setName(param.value());
                propertyModel.setTestData(param.testData());
                split = param.value().split("\\^");
                if (split.length == 2) {
                    propertyModel.setName(split[0]);
                    propertyModel.setTestData(split[1]);
                }
                if ((split2 = split[0].split("\\~")).length == 2) {
                    propertyModel.setName(split2[1]);
                    if (split2[0].contains("n")) {
                        propertyModel.setRequired(false);
                    }
                }
                if (bool) {
                    propertyModel.setRequired(true);
                }
                if (bool2) {
                    propertyModel.setRequired(false);
                }
                propertyModel.setParamType("query");
                propertyModel.setArray(param.isArray());
                if (!param.isArray() && (pType.getSimpleName().contains("[]") || pType.equals(List.class) || pType.equals(Set.class) || pType.equals(ArrayList.class) || pType.equals(LinkedList.class) || pType.equals(Vector.class) || pType.equals(SortedSet.class) || pType.equals(HashSet.class) || pType.equals(TreeSet.class) || pType.equals(LinkedHashSet.class))) {
                    propertyModel.setArray(true);
                }
                propertyModel.setValue(string);
                propertyModels.add(propertyModel);
            }
            modelModel.setPropertyModels(propertyModels);
        }
        rm.setModelModel(modelModel);
        this.respNum = 0;
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"addParamInfo"})
    public String addParamInfo(String value, String type, String url, String modaltype, String content, String serverName) {
        if (serverName != null && !"".equals(serverName)) {
            RestTemplate restTemplate = new RestTemplate();
            LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
            requestBody.add((Object)"value", (Object)value);
            requestBody.add((Object)"type", (Object)type);
            requestBody.add((Object)"url", (Object)url);
            requestBody.add((Object)"modaltype", (Object)modaltype);
            requestBody.add((Object)"content", (Object)content);
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.add("Content-Type", "application/x-www-form-urlencoded");
            HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)requestHeaders);
            ResponseEntity exchange = restTemplate.exchange(serverName + "/lkad/addParamInfo", HttpMethod.POST, requestEntity, String.class, new Object[0]);
            return (String)exchange.getBody();
        }
        if ("5".equals(modaltype)) {
            value = value.replace("[]", "");
            Map<Object, Object> map = this.getParamInfo(serverName);
            if (map != null) {
                for (Map.Entry<Object, Object> entry : map.entrySet()) {
                    if (!entry.getKey().equals(url + "." + type + "." + value)) continue;
                    this.delParamInfo(value, type, url, serverName);
                }
            }
        }
        File file = new File("lkadParamInfo.properties");
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(file, true);
            Properties prop = new Properties();
            prop.setProperty(url + "." + type + "." + value, modaltype + "-" + content);
            prop.store(outStream, null);
            String string = "\u64cd\u4f5c\u6210\u529f";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "\u64cd\u4f5c\u5931\u8d25";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"delParamInfo"})
    public String delParamInfo(String value, String type, String url, String serverName) {
        if (serverName != null && !"".equals(serverName)) {
            RestTemplate restTemplate = new RestTemplate();
            LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
            requestBody.add((Object)"value", (Object)value);
            requestBody.add((Object)"type", (Object)type);
            requestBody.add((Object)"url", (Object)url);
            HttpHeaders requestHeaders = new HttpHeaders();
            requestHeaders.add("Content-Type", "application/x-www-form-urlencoded");
            HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)requestHeaders);
            ResponseEntity exchange = restTemplate.exchange(serverName + "/lkad/delParamInfo", HttpMethod.POST, requestEntity, String.class, new Object[0]);
            return (String)exchange.getBody();
        }
        File file = new File("lkadParamInfo.properties");
        FileOutputStream outStream = null;
        FileInputStream inStream = null;
        try {
            Properties prop = new Properties();
            inStream = new FileInputStream(file);
            prop.load(inStream);
            prop.remove(url + "." + type + "." + value);
            outStream = new FileOutputStream(file);
            prop.store(outStream, null);
            String string = "\u64cd\u4f5c\u6210\u529f";
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "\u64cd\u4f5c\u5931\u8d25";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"getParamInfo"})
    public Map<Object, Object> getParamInfo(String serverName) {
        if (serverName != null && !"".equals(serverName)) {
            RestTemplate restTemplate = new RestTemplate();
            Map forObject = (Map)restTemplate.getForObject(serverName + "/lkad/getParamInfo", Map.class, new Object[0]);
            return forObject;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        File file = new File("lkadParamInfo.properties");
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            Properties prop = new Properties();
            prop.load(inStream);
            Set<Map.Entry<Object, Object>> entrySet = prop.entrySet();
            for (Map.Entry<Object, Object> entry : entrySet) {
                map.put(entry.getKey(), entry.getValue());
            }
            HashMap<Object, Object> hashMap = map;
            return hashMap;
        }
        catch (Exception prop) {
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Field[] getDeclaredField(Object object) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
        }
        Field[] fields = new Field[fieldList.size()];
        fieldList.toArray(fields);
        return fields;
    }

    public String toHump(String str) {
        String rs = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            rs = Character.isUpperCase(c) ? rs + " " + Character.toLowerCase(c) : rs + c;
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String enToCn(String url, Integer type, String name) {
        block18: {
            FileInputStream inStream = null;
            try {
                if (this.entrySet == null) {
                    File file = new File("lkadParamInfo.properties");
                    inStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(inStream);
                    this.entrySet = properties.entrySet();
                }
                if (this.entrySet == null) break block18;
                for (Map.Entry entry : this.entrySet) {
                    String value;
                    String[] split;
                    if (!entry.getKey().equals(url + "." + type + "." + name) || !"5".equals((split = (value = entry.getValue().toString()).split("-"))[0])) continue;
                    String str = "";
                    for (int i = 1; i < split.length; ++i) {
                        str = str + split[i];
                    }
                    String string = str;
                    return string;
                }
            }
            catch (Exception e) {
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return name;
    }

    public int isObj(Class<?> type) {
        if (type == null) {
            return 3;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return 0;
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return 0;
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return 0;
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return 0;
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            return 0;
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return 0;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return 0;
        }
        if (type.equals(String.class) || type.equals(BigDecimal.class)) {
            return 0;
        }
        if (type.equals(java.util.Date.class) || type.equals(Date.class) || type.equals(LocalDate.class) || type.equals(LocalDateTime.class)) {
            return 0;
        }
        if (type.equals(Map.class) || type.equals(HashMap.class) || type.equals(LinkedHashMap.class) || type.equals(TreeMap.class) || type.equals(Hashtable.class) || type.equals(ConcurrentHashMap.class)) {
            return 1;
        }
        if (type.equals(List.class) || type.equals(Set.class) || type.equals(ArrayList.class) || type.equals(LinkedList.class) || type.equals(Vector.class) || type.equals(SortedSet.class) || type.equals(HashSet.class) || type.equals(TreeSet.class) || type.equals(LinkedHashSet.class)) {
            return 2;
        }
        if (type.isArray()) {
            return 4;
        }
        return 3;
    }

    public TypeCls getGenericType(Class<?> type, Field field) {
        TypeCls typeCls;
        block10: {
            typeCls = new TypeCls();
            typeCls.setArray(false);
            typeCls.setName(type.getSimpleName());
            try {
                if (type.equals(List.class) || type.equals(Set.class) || type.equals(ArrayList.class) || type.equals(LinkedList.class) || type.equals(Vector.class) || type.equals(SortedSet.class) || type.equals(HashSet.class) || type.equals(TreeSet.class) || type.equals(LinkedHashSet.class)) {
                    typeCls.setArray(true);
                    Type genericType = field.getGenericType();
                    if (null == genericType) {
                        type = Object.class;
                    }
                    if (!(genericType instanceof ParameterizedType)) break block10;
                    ParameterizedType pt = (ParameterizedType)genericType;
                    try {
                        type = (Class)pt.getActualTypeArguments()[0];
                    }
                    catch (Exception e) {
                        try {
                            ParameterizedType pt2 = (ParameterizedType)pt.getActualTypeArguments()[0];
                            type = (Class)pt2.getRawType();
                            break block10;
                        }
                        catch (Exception e1) {
                            TypeVariable pt3 = (TypeVariable)pt.getActualTypeArguments()[0];
                            String name = pt3.getName();
                            if ("T".equals(name)) {
                                type = null;
                            }
                            break block10;
                        }
                    }
                }
                if (type.isArray()) {
                    type = type.getComponentType();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        typeCls.setCls(type);
        return typeCls;
    }

    public boolean isParentArray(Class<?> returnType) {
        boolean isParentArray = false;
        if (returnType.getSimpleName().equals("List") || returnType.getSimpleName().equals("Set") || returnType.getSimpleName().equals("ArrayList") || returnType.getSimpleName().equals("LinkedList") || returnType.getSimpleName().equals("Vector") || returnType.getSimpleName().equals("SortedSet") || returnType.getSimpleName().equals("HashSet") || returnType.getSimpleName().equals("TreeSet") || returnType.getSimpleName().equals("LinkedHashSet")) {
            isParentArray = true;
        }
        return isParentArray;
    }
}

