/*
 * Decompiled with CFR 0.152.
 */
package com.lk.api.controller;

import com.lk.api.controller.SconPackageInterface;
import com.lk.api.controller.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SconPackage
implements SconPackageInterface {
    private String basePackage;
    private ClassLoader cl;

    public static void main(String[] args) throws IOException {
        SconPackage sconPackage = new SconPackage("com.lk.api");
        List<String> list = sconPackage.getFullyQualifiedClassNameList();
        for (String s : list) {
            System.out.println(s);
        }
    }

    public SconPackage(String basePackage) {
        this.basePackage = basePackage;
        this.cl = this.getClass().getClassLoader();
    }

    public SconPackage(String basePackage, ClassLoader cl) {
        this.basePackage = basePackage;
        this.cl = cl;
    }

    @Override
    public List<String> getFullyQualifiedClassNameList() throws IOException {
        List<String> doScan = this.doScan(this.basePackage, new ArrayList<String>());
        return doScan;
    }

    private List<String> doScan(String basePackage, List<String> nameList) throws IOException {
        String splashPath = StringUtil.dotToSplash(basePackage);
        Enumeration<URL> resources = this.cl.getResources(splashPath);
        if (resources == null) {
            return nameList;
        }
        while (resources.hasMoreElements()) {
            boolean bool;
            String s1;
            URL url = resources.nextElement();
            String path = URLDecoder.decode(url.getFile(), "utf-8");
            String filePath = StringUtil.getRootPath(path);
            List<String> names = null;
            if (this.isJarFile(filePath)) {
                names = this.readFromJarFile(filePath, splashPath);
                if (names == null) continue;
                for (String name : names) {
                    if (this.isClassFile(name)) {
                        s1 = name.substring(0, name.lastIndexOf(".class"));
                        bool = true;
                        for (String s2 : nameList) {
                            if (!s1.equals(s2)) continue;
                            bool = false;
                        }
                        if (!bool) continue;
                        nameList.add(s1);
                        continue;
                    }
                    this.doScan(name, nameList);
                }
                continue;
            }
            names = this.readFromDirectory(filePath);
            if (names == null) continue;
            for (String name : names) {
                if (this.isClassFile(name)) {
                    s1 = this.toFullyQualifiedName(name, basePackage);
                    bool = true;
                    for (String s2 : nameList) {
                        if (!s1.equals(s2)) continue;
                        bool = false;
                    }
                    if (!bool) continue;
                    nameList.add(s1);
                    continue;
                }
                this.doScan(basePackage + "." + name, nameList);
            }
        }
        return nameList;
    }

    private String toFullyQualifiedName(String shortName, String basePackage) {
        StringBuilder sb = new StringBuilder(basePackage);
        sb.append('.');
        sb.append(StringUtil.trimExtension(shortName));
        return sb.toString();
    }

    private List<String> readFromJarFile(String jarPath, String splashedPackageName) throws IOException {
        JarFile jarFile = new JarFile(new File(jarPath));
        Enumeration<JarEntry> entries = jarFile.entries();
        ArrayList<String> nameList = new ArrayList<String>();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.contains(splashedPackageName) || !this.isClassFile(name)) continue;
            name = name.substring(name.indexOf(splashedPackageName)).replaceAll("\\/", ".");
            nameList.add(name);
        }
        return nameList;
    }

    private List<String> readFromDirectory(String path) {
        if (path == null) {
            return new ArrayList<String>();
        }
        File file = new File(path);
        String[] names = file.list();
        if (null == names) {
            return null;
        }
        return Arrays.asList(names);
    }

    private boolean isClassFile(String name) {
        if (name == null) {
            return false;
        }
        return name.endsWith(".class");
    }

    private boolean isJarFile(String name) {
        if (name == null) {
            return false;
        }
        return name.endsWith(".jar");
    }
}

