/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.autoconfigure.resolver;

import com.github.ltsopensource.autoconfigure.resolver.ArrayResolver;
import com.github.ltsopensource.autoconfigure.resolver.ClassResolver;
import com.github.ltsopensource.autoconfigure.resolver.CollectionResolver;
import com.github.ltsopensource.autoconfigure.resolver.EnumResolver;
import com.github.ltsopensource.autoconfigure.resolver.JavaBeanResolver;
import com.github.ltsopensource.autoconfigure.resolver.MapResolver;
import com.github.ltsopensource.autoconfigure.resolver.PrimitiveTypeResolver;
import com.github.ltsopensource.autoconfigure.resolver.Resolver;
import com.github.ltsopensource.core.commons.utils.PrimitiveTypeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResolverUtils {
    public static Resolver getResolver(Class<?> clazz) {
        if (clazz == Class.class) {
            return ClassResolver.INSTANCE;
        }
        if (PrimitiveTypeUtils.isPrimitiveClass(clazz)) {
            return PrimitiveTypeResolver.INSTANCE;
        }
        if (clazz.isEnum()) {
            return EnumResolver.INSTANCE;
        }
        if (clazz.isArray()) {
            return ArrayResolver.INSTANCE;
        }
        if (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class) {
            return CollectionResolver.INSTANCE;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return CollectionResolver.INSTANCE;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return MapResolver.INSTANCE;
        }
        return JavaBeanResolver.INSTANCE;
    }
}

