/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.cluster;

import com.github.ltsopensource.cmd.HttpCmdServer;
import com.github.ltsopensource.core.AppContext;
import com.github.ltsopensource.core.cluster.Config;
import com.github.ltsopensource.core.cluster.JobNode;
import com.github.ltsopensource.core.cluster.MasterElector;
import com.github.ltsopensource.core.cluster.Node;
import com.github.ltsopensource.core.cluster.SubscribedNodeManager;
import com.github.ltsopensource.core.cmd.JVMInfoGetHttpCmd;
import com.github.ltsopensource.core.cmd.StatusCheckHttpCmd;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.commons.utils.GenericsUtils;
import com.github.ltsopensource.core.commons.utils.NetUtils;
import com.github.ltsopensource.core.commons.utils.StringUtils;
import com.github.ltsopensource.core.compiler.AbstractCompiler;
import com.github.ltsopensource.core.factory.JobNodeConfigFactory;
import com.github.ltsopensource.core.factory.NodeFactory;
import com.github.ltsopensource.core.json.JSONFactory;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.core.listener.MasterElectionListener;
import com.github.ltsopensource.core.listener.NodeChangeListener;
import com.github.ltsopensource.core.listener.SelfChangeListener;
import com.github.ltsopensource.core.logger.Logger;
import com.github.ltsopensource.core.logger.LoggerFactory;
import com.github.ltsopensource.core.protocol.command.CommandBodyWrapper;
import com.github.ltsopensource.core.registry.AbstractRegistry;
import com.github.ltsopensource.core.registry.NotifyEvent;
import com.github.ltsopensource.core.registry.NotifyListener;
import com.github.ltsopensource.core.registry.Registry;
import com.github.ltsopensource.core.registry.RegistryFactory;
import com.github.ltsopensource.core.registry.RegistryStatMonitor;
import com.github.ltsopensource.core.spi.ServiceLoader;
import com.github.ltsopensource.core.support.AliveKeeping;
import com.github.ltsopensource.core.support.ConfigValidator;
import com.github.ltsopensource.ec.EventCenter;
import com.github.ltsopensource.ec.EventInfo;
import com.github.ltsopensource.remoting.serialize.AdaptiveSerializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractJobNode<T extends Node, Context extends AppContext>
implements JobNode {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JobNode.class);
    protected Registry registry;
    protected T node;
    protected Config config;
    protected Context appContext;
    private List<NodeChangeListener> nodeChangeListeners;
    private List<MasterChangeListener> masterChangeListeners;
    protected AtomicBoolean started = new AtomicBoolean(false);

    public AbstractJobNode() {
        this.appContext = this.getAppContext();
        this.node = NodeFactory.create(this.getNodeClass());
        this.config = JobNodeConfigFactory.getDefaultConfig();
        this.config.setNodeType(((Node)this.node).getNodeType());
        ((AppContext)this.appContext).setConfig(this.config);
        this.nodeChangeListeners = new ArrayList<NodeChangeListener>();
        this.masterChangeListeners = new ArrayList<MasterChangeListener>();
    }

    @Override
    public final void start() {
        try {
            if (this.started.compareAndSet(false, true)) {
                this.configValidate();
                this.initConfig();
                this.initHttpCmdServer();
                this.beforeRemotingStart();
                this.remotingStart();
                this.afterRemotingStart();
                this.initRegistry();
                this.registry.register((Node)this.node);
                AliveKeeping.start();
                LOGGER.info("========== Start success, nodeType={}, identity={}", new Object[]{this.config.getNodeType(), this.config.getIdentity()});
            }
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Address already in use")) {
                LOGGER.error("========== Start failed at listen port {}, nodeType={}, identity={}", new Object[]{this.config.getListenPort(), this.config.getNodeType(), this.config.getIdentity(), e});
            }
            LOGGER.error("========== Start failed, nodeType={}, identity={}", new Object[]{this.config.getNodeType(), this.config.getIdentity(), e});
        }
    }

    private void initHttpCmdServer() {
        int port = ((AppContext)this.appContext).getConfig().getParameter("lts.http.cmd.port", 8719);
        ((AppContext)this.appContext).setHttpCmdServer(HttpCmdServer.Factory.getHttpCmdServer(this.config.getIp(), port));
        ((AppContext)this.appContext).getHttpCmdServer().start();
        ((Node)this.node).setHttpCmdPort(((AppContext)this.appContext).getHttpCmdServer().getPort());
        ((AppContext)this.appContext).getHttpCmdServer().registerCommands(new StatusCheckHttpCmd(((AppContext)this.appContext).getConfig()), new JVMInfoGetHttpCmd(((AppContext)this.appContext).getConfig()));
    }

    @Override
    public final void stop() {
        try {
            if (this.started.compareAndSet(true, false)) {
                if (this.registry != null) {
                    this.registry.unregister((Node)this.node);
                }
                this.beforeRemotingStop();
                this.remotingStop();
                this.afterRemotingStop();
                ((AppContext)this.appContext).getEventCenter().publishSync(new EventInfo("NODE_SHUT_DOWN"));
                AliveKeeping.stop();
                LOGGER.info("========== Stop success, nodeType={}, identity={}", new Object[]{this.config.getNodeType(), this.config.getIdentity()});
            }
        }
        catch (Throwable e) {
            LOGGER.error("========== Stop failed, nodeType={}, identity={}", new Object[]{this.config.getNodeType(), this.config.getIdentity(), e});
        }
    }

    @Override
    public void destroy() {
        try {
            this.registry.destroy();
            LOGGER.info("Destroy success, nodeType={}, identity={}", new Object[]{this.config.getNodeType(), this.config.getIdentity()});
        }
        catch (Throwable e) {
            LOGGER.error("Destroy failed, nodeType={}, identity={}", new Object[]{this.config.getNodeType(), this.config.getIdentity(), e});
        }
    }

    protected void configValidate() {
        ConfigValidator.validateNodeGroup(this.config.getNodeGroup());
        ConfigValidator.validateClusterName(this.config.getClusterName());
        ConfigValidator.validateIdentity(this.config.getIdentity());
    }

    protected void initConfig() {
        String compiler = this.config.getParameter("java.compiler");
        if (StringUtils.isNotEmpty(compiler)) {
            AbstractCompiler.setCompiler(compiler);
        }
        if (StringUtils.isEmpty(this.config.getIp())) {
            this.config.setIp(NetUtils.getLocalHost());
        }
        if (StringUtils.isEmpty(this.config.getIdentity())) {
            JobNodeConfigFactory.buildIdentity(this.config);
        }
        NodeFactory.build(this.node, this.config);
        LOGGER.info("Current Node config :{}", this.config);
        ((AppContext)this.appContext).setEventCenter(ServiceLoader.load(EventCenter.class, this.config));
        ((AppContext)this.appContext).setCommandBodyWrapper(new CommandBodyWrapper(this.config));
        ((AppContext)this.appContext).setMasterElector(new MasterElector((AppContext)this.appContext));
        ((AppContext)this.appContext).getMasterElector().addMasterChangeListener(this.masterChangeListeners);
        ((AppContext)this.appContext).setRegistryStatMonitor(new RegistryStatMonitor((AppContext)this.appContext));
        SubscribedNodeManager subscribedNodeManager = new SubscribedNodeManager((AppContext)this.appContext);
        ((AppContext)this.appContext).setSubscribedNodeManager(subscribedNodeManager);
        this.nodeChangeListeners.add(subscribedNodeManager);
        this.nodeChangeListeners.add(new MasterElectionListener((AppContext)this.appContext));
        this.nodeChangeListeners.add(new SelfChangeListener((AppContext)this.appContext));
        this.setSpiConfig();
    }

    private void setSpiConfig() {
        String defaultSerializable = this.config.getParameter("lts.remoting.serializable.default");
        if (StringUtils.isNotEmpty(defaultSerializable)) {
            AdaptiveSerializable.setDefaultSerializable(defaultSerializable);
        }
        String ltsJson = this.config.getParameter("lts.json");
        if (StringUtils.isNotEmpty(ltsJson)) {
            JSONFactory.setJSONAdapter(ltsJson);
        }
        String logger = this.config.getParameter("lts.logger");
        if (StringUtils.isNotEmpty(logger)) {
            LoggerFactory.setLoggerAdapter(logger);
        }
    }

    private void initRegistry() {
        this.registry = RegistryFactory.getRegistry(this.appContext);
        if (this.registry instanceof AbstractRegistry) {
            ((AbstractRegistry)this.registry).setNode((Node)this.node);
        }
        this.registry.subscribe((Node)this.node, new NotifyListener(){
            private final Logger NOTIFY_LOGGER = LoggerFactory.getLogger(NotifyListener.class);

            @Override
            public void notify(NotifyEvent event, List<Node> nodes) {
                if (CollectionUtils.isEmpty(nodes)) {
                    return;
                }
                switch (event) {
                    case ADD: {
                        for (NodeChangeListener listener : AbstractJobNode.this.nodeChangeListeners) {
                            try {
                                listener.addNodes(nodes);
                            }
                            catch (Throwable t) {
                                this.NOTIFY_LOGGER.error("{} add nodes failed , cause: {}", listener.getClass().getName(), t.getMessage(), t);
                            }
                        }
                        break;
                    }
                    case REMOVE: {
                        for (NodeChangeListener listener : AbstractJobNode.this.nodeChangeListeners) {
                            try {
                                listener.removeNodes(nodes);
                            }
                            catch (Throwable t) {
                                this.NOTIFY_LOGGER.error("{} remove nodes failed , cause: {}", listener.getClass().getName(), t.getMessage(), t);
                            }
                        }
                        break;
                    }
                }
            }
        });
    }

    protected abstract void remotingStart();

    protected abstract void remotingStop();

    protected abstract void beforeRemotingStart();

    protected abstract void afterRemotingStart();

    protected abstract void beforeRemotingStop();

    protected abstract void afterRemotingStop();

    private Context getAppContext() {
        try {
            return (Context)((AppContext)GenericsUtils.getSuperClassGenericType(this.getClass(), 1).newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<T> getNodeClass() {
        return GenericsUtils.getSuperClassGenericType(this.getClass(), 0);
    }

    public void setRegistryAddress(String registryAddress) {
        this.config.setRegistryAddress(registryAddress);
    }

    public void setInvokeTimeoutMillis(int invokeTimeoutMillis) {
        this.config.setInvokeTimeoutMillis(invokeTimeoutMillis);
    }

    public void setClusterName(String clusterName) {
        this.config.setClusterName(clusterName);
    }

    public void setIdentity(String identity) {
        this.config.setIdentity(identity);
    }

    public void addNodeChangeListener(NodeChangeListener notifyListener) {
        if (notifyListener != null) {
            this.nodeChangeListeners.add(notifyListener);
        }
    }

    public void setBindIp(String bindIp) {
        if (StringUtils.isEmpty(bindIp) || !NetUtils.isValidHost(bindIp)) {
            throw new IllegalArgumentException("Invalided bind ip:" + bindIp);
        }
        this.config.setIp(bindIp);
    }

    public void addMasterChangeListener(MasterChangeListener masterChangeListener) {
        if (masterChangeListener != null) {
            this.masterChangeListeners.add(masterChangeListener);
        }
    }

    public void setDataPath(String path) {
        if (StringUtils.isNotEmpty(path)) {
            this.config.setDataPath(path);
        }
    }

    public void addConfig(String key, String value) {
        this.config.setParameter(key, value);
    }
}

