/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.commons.utils;

import com.github.ltsopensource.core.commons.time.FastDateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class DateUtils {
    public static final String YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD = "yyyy-MM-dd";
    public static final long ONE_DAY_MillIS = 86400000L;
    private static final ConcurrentMap<Pattern, String> regPatternMap = new ConcurrentHashMap<Pattern, String>();

    public static Date convert(Long timestamp) {
        return new Date(timestamp);
    }

    public static Date now() {
        return new Date();
    }

    public static Long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static String formatDate(Date d, String fmt) {
        return FastDateFormat.getInstance(fmt).format(d);
    }

    public static String formatYMD(Date d) {
        return FastDateFormat.getInstance(YMD).format(d);
    }

    public static String formatYMD_HMS(Date d) {
        return FastDateFormat.getInstance(YMD_HMS).format(d);
    }

    public static String formatDate(Long date, String fmt) {
        return FastDateFormat.getInstance(fmt).format(date);
    }

    public static String format(Date date, String fmt) {
        return FastDateFormat.getInstance(fmt).format(date);
    }

    public static Date parse(String date, String fmt) {
        try {
            return FastDateFormat.getInstance(fmt).parse(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parse(String date) {
        try {
            for (Map.Entry entry : regPatternMap.entrySet()) {
                boolean isMatch = ((Pattern)entry.getKey()).matcher(date).matches();
                if (!isMatch) continue;
                return FastDateFormat.getInstance((String)entry.getValue()).parse(date);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("can't support this pattern , date is " + date);
        }
        throw new IllegalArgumentException("can't support this pattern , date is " + date);
    }

    public static Date parseYMD(String date) {
        try {
            return FastDateFormat.getInstance(YMD).parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date parseYMD_HMS(String date) {
        try {
            return FastDateFormat.getInstance(YMD_HMS).parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("the date pattern is error!");
        }
    }

    public static boolean isSameDay(Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        FastDateFormat df = FastDateFormat.getInstance(YMD);
        return df.format(date).equals(df.format(date2));
    }

    public static Date addMonth(Date date, int interval) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, interval);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int interval) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, interval);
        return calendar.getTime();
    }

    public static Date addHour(Date date, int interval) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(11, interval);
        return calendar.getTime();
    }

    public static Date addMinute(Date date, int interval) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, interval);
        return calendar.getTime();
    }

    static {
        regPatternMap.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2}$"), YMD);
        regPatternMap.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}$"), YMD_HMS);
        regPatternMap.put(Pattern.compile("^\\d{4}\\d{1,2}\\d{1,2}$"), "yyyyMMdd");
        regPatternMap.put(Pattern.compile("^\\d{4}\\d{1,2}$"), "yyyyMM");
        regPatternMap.put(Pattern.compile("^\\d{4}/\\d{1,2}/\\d{1,2}$"), "yyyy/MM/dd");
        regPatternMap.put(Pattern.compile("^\\d{4}\u5e74\\d{1,2}\u6708\\d{1,2}\u65e5$"), "yyyy\u5e74MM\u6708dd\u65e5");
        regPatternMap.put(Pattern.compile("^\\d{4}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}$"), "yyyy/MM/dd HH:mm:ss");
        regPatternMap.put(Pattern.compile("^\\d{4}/\\d{1,2}/\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1}$"), "yyyy/MM/dd HH:mm:ss.S");
        regPatternMap.put(Pattern.compile("^\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}\\.\\d{1}$"), "yyyy-MM-dd HH:mm:ss.S");
    }
}

