/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.core.failstore.rocksdb;

import com.github.ltsopensource.core.commons.file.FileUtils;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.domain.Pair;
import com.github.ltsopensource.core.failstore.AbstractFailStore;
import com.github.ltsopensource.core.failstore.FailStoreException;
import com.github.ltsopensource.core.json.JSON;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteOptions;

public class RocksdbFailStore
extends AbstractFailStore {
    private RocksDB db = null;
    private Options options;
    public static final String name = "rocksdb";

    public RocksdbFailStore(File dbPath, boolean needLock) {
        super(dbPath, needLock);
    }

    @Override
    protected void init() throws FailStoreException {
        try {
            this.options = new Options();
            this.options.setCreateIfMissing(true).setWriteBufferSize(8192L).setMaxWriteBufferNumber(3).setMaxBackgroundCompactions(10).setCompressionType(CompressionType.SNAPPY_COMPRESSION).setCompactionStyle(CompactionStyle.UNIVERSAL);
            BloomFilter bloomFilter = new BloomFilter(10);
            BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
            tableConfig.setBlockCacheSize(65536L).setFilter((Filter)bloomFilter).setCacheNumShardBits(6).setBlockSizeDeviation(5).setBlockRestartInterval(10).setCacheIndexAndFilterBlocks(true).setHashIndexAllowCollision(false).setBlockCacheCompressedSize(65536L).setBlockCacheCompressedNumShardBits(10);
            this.options.setTableFormatConfig((TableFormatConfig)tableConfig);
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    protected String getName() {
        return name;
    }

    @Override
    public void open() throws FailStoreException {
        try {
            this.db = RocksDB.open((Options)this.options, (String)this.dbPath.getPath());
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void put(String key, Object value) throws FailStoreException {
        String valueString = JSON.toJSONString(value);
        WriteOptions writeOpts = new WriteOptions();
        try {
            writeOpts.setSync(true);
            writeOpts.setDisableWAL(true);
            this.db.put(writeOpts, key.getBytes("UTF-8"), valueString.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
        finally {
            writeOpts.dispose();
        }
    }

    @Override
    public void delete(String key) throws FailStoreException {
        try {
            this.db.remove(key.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void delete(List<String> keys) throws FailStoreException {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        for (String key : keys) {
            this.delete(key);
        }
    }

    @Override
    public <T> List<Pair<String, T>> fetchTop(int size, Type type) throws FailStoreException {
        RocksIterator iterator = null;
        try {
            ArrayList<Pair<String, T>> list = new ArrayList<Pair<String, T>>(size);
            iterator = this.db.newIterator();
            iterator.seekToFirst();
            while (iterator.isValid()) {
                iterator.status();
                String key = new String(iterator.key(), "UTF-8");
                Object value = JSON.parse(new String(iterator.value(), "UTF-8"), type);
                Pair pair = new Pair(key, value);
                list.add(pair);
                if (list.size() >= size) break;
                iterator.next();
            }
            ArrayList<Pair<String, T>> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
        finally {
            if (iterator != null) {
                iterator.dispose();
            }
        }
    }

    @Override
    public void close() throws FailStoreException {
        try {
            if (this.db != null) {
                this.db.close();
            }
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
    }

    @Override
    public void destroy() throws FailStoreException {
        try {
            this.db.close();
            this.options.dispose();
        }
        catch (Exception e) {
            throw new FailStoreException(e);
        }
        finally {
            if (this.fileLock != null) {
                this.fileLock.release();
            }
            FileUtils.delete(this.dbPath);
        }
    }
}

